"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sanitizeErrorMessage = exports.stackTraceFilter = void 0;
const constants_1 = require("./constants");
/**
 * filter stack array
 * @param {string} stackRow
 * @returns {boolean}
 */
const stackTraceFilter = (stackRow) => {
    if (stackRow.match(constants_1.STACK_START)) {
        return !constants_1.STACKTRACE_FILTER.some(r => stackRow.includes(r));
    }
    return true;
};
exports.stackTraceFilter = stackTraceFilter;
/**
 * Cleanup stack traces, merge and remove duplicates
 * @param {Error|*} commandError    Error object or anything else including undefined
 * @param {Error}   savedError      Error with root stack trace
 * @returns {Error}
 */
function sanitizeErrorMessage(commandError, savedError) {
    var _a;
    let name, stack, message;
    if (commandError instanceof Error) {
        ({ name, message, stack } = commandError);
    }
    else {
        name = 'Error';
        message = commandError;
    }
    const err = new Error(message);
    err.name = name;
    let stackArr = ((_a = savedError.stack) === null || _a === void 0 ? void 0 : _a.split('\n')) || [];
    /**
     * merge stack traces if `commandError` has stack trace
     */
    if (stack) {
        // remove duplicated error name from stack trace
        stack = stack.replace(`${err.name}: ${err.name}`, err.name);
        // remove first stack trace line from second stack trace
        stackArr[0] = '\n';
        // merge
        stackArr = [...stack.split('\n'), ...stackArr];
    }
    err.stack = stackArr
        // filter stack trace
        .filter(exports.stackTraceFilter)
        // remove duplicates from stack traces
        .reduce((acc, currentValue) => {
        return acc.includes(currentValue) ? acc : `${acc}\n${currentValue}`;
    }, '')
        .trim();
    return err;
}
exports.sanitizeErrorMessage = sanitizeErrorMessage;
