"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fibers_1 = __importDefault(require("./fibers"));
/**
 * global function to wrap callbacks into Fiber context
 * @param  {Function} fn  function to wrap around
 * @return {Function}     wrapped around function
 */
function runFnInFiberContext(fn) {
    return function (...args) {
        delete global.browser._NOT_FIBER;
        return new Promise((resolve, reject) => fibers_1.default(() => {
            try {
                global._HAS_FIBER_CONTEXT = true;
                const result = fn.apply(this, args);
                global._HAS_FIBER_CONTEXT = false;
                return resolve(result);
            }
            catch (err) {
                return reject(err);
            }
        }).run());
    };
}
exports.default = runFnInFiberContext;
