import type { Browser } from 'webdriverio';
import executeHooksWithArgs from './executeHooksWithArgs';
import runFnInFiberContext from './runFnInFiberContext';
import wrapCommand from './wrapCommand';
declare const defaultRetries: {
    attempts: number;
    limit: number;
};
declare global {
    var _HAS_FIBER_CONTEXT: boolean;
    var browser: any;
}
/**
 * execute test or hook synchronously
 *
 * @param  {Function} fn         spec or hook method
 * @param  {Number}   retries    { limit: number, attempts: number }
 * @param  {Array}    args       arguments passed to hook
 * @return {Promise}             that gets resolved once test/hook is done or was retried enough
 */
declare function executeSync(this: Browser<'async'>, fn: Function, retries?: {
    attempts: number;
    limit: number;
}, args?: any[]): Promise<any>;
/**
 * run hook or spec via executeSync
 */
declare function runSync(this: any, fn: Function, repeatTest?: typeof defaultRetries, args?: any[]): (resolve: (value: any) => void, reject: (error: Error) => void) => any;
export { executeHooksWithArgs, wrapCommand, runFnInFiberContext, executeSync, runSync, };
export default function sync(testFn: Function): Promise<unknown>;
//# sourceMappingURL=index.d.ts.map