import type { WaitForOptions } from '../../types';
/**
 * Wait for an element for the provided amount of
 * milliseconds to be clickable or not clickable.
 *
 * <example>
    :waitForClickable.js
    it('should detect when element is clickable', () => {
        const elem = $('#elem')
        elem.waitForClickable({ timeout: 3000 });
    });
    it('should detect when element is no longer clickable', () => {
        const elem = $('#elem')
        elem.waitForClickable({ reverse: true });
    });
 * </example>
 *
 * @alias element.waitForClickable
 * @param {WaitForOptions=}  options             waitForEnabled options (optional)
 * @param {Number=}          options.timeout     time in ms (default: 500)
 * @param {Boolean=}         options.reverse     if true it waits for the opposite (default: false)
 * @param {String=}          options.timeoutMsg  if exists it overrides the default error message
 * @param {Number=}          options.interval    interval between checks (default: `waitforInterval`)
 * @return {Boolean} `true` if element is clickable (or doesn't if flag is set)
 *
 */
export default function waitForClickable(this: WebdriverIO.Element, { timeout, interval, reverse, timeoutMsg }?: WaitForOptions): Promise<true | void>;
//# sourceMappingURL=waitForClickable.d.ts.map