import type { Capabilities, Options, Services } from '@wdio/types';
import { ModuleRequireService } from '../utils';
declare type Spec = string | string[];
interface TestrunnerOptionsWithParameters extends Omit<Options.Testrunner, 'capabilities'> {
    watch?: boolean;
    spec?: string[];
    suite?: string[];
    capabilities?: Capabilities.RemoteCapabilities;
}
interface MergeConfig extends Omit<Partial<TestrunnerOptionsWithParameters>, 'specs' | 'exclude'> {
    specs?: Spec;
    exclude?: Spec;
}
interface CurrentPathFinder {
    getcwd(): string;
}
interface LoadConfigFile {
    loadFile<T>(path: string): T;
}
interface IsFileDetector {
    isFile(path: string): boolean;
}
interface DeterminesAbsolutePath {
    ensureAbsolutePath(path: string): string;
}
interface Globber {
    glob(pattern: string): string[];
}
export interface PathService extends CurrentPathFinder, LoadConfigFile, IsFileDetector, Globber, DeterminesAbsolutePath {
}
export default class ConfigParser {
    private _config;
    private _capabilities;
    private _pathService;
    private _moduleRequireService;
    constructor(pathService?: PathService, moduleRequireService?: ModuleRequireService);
    autoCompile(): void;
    /**
     * merges config file with default values
     * @param {String} filename path of file relative to current directory
     */
    addConfigFile(filename: string): void;
    /**
     * merge external object with config object
     * @param  {Object} object  desired object to merge into the config object
     */
    merge(object?: MergeConfig): void;
    /**
     * Add hooks from an existing service to the runner config.
     * @param {Object} service - an object that contains hook methods.
     */
    addService(service: Services.Hooks): void;
    /**
     * get excluded files from config pattern
     */
    getSpecs(capSpecs?: string[], capExclude?: string[]): Spec[];
    /**
     * sets config attribute with file paths from filtering
     * options from cli argument
     *
     * @param  {String[]} cliArgFileList  list of files in a string form
     * @param  {Object} config  config object that stores the spec and exclude attributes
     * cli argument
     * @return {String[]} List of files that should be included or excluded
     */
    setFilePathToFilterOptions(cliArgFileList: string[], config: string[]): string[];
    /**
     * return configs
     */
    getConfig(): Required<Options.Testrunner>;
    /**
     * return capabilities
     */
    getCapabilities(i?: number): Capabilities.DesiredCapabilities | Capabilities.W3CCapabilities | Capabilities.RemoteCapabilities;
    /**
     * returns a flattened list of globbed files
     *
     * @param  {String[] | String[][]} filenames list of files to glob
     * @param  {Boolean} flag to indicate omission of warnings
     * @param  {FileSystemPathService} file system path service for expanding globbed file names
     * @param  {number} hierarchy depth to prevent recursive calling beyond a depth of 1
     * @return {String[] | String[][]} list of files
     */
    static getFilePaths(patterns: Spec[], omitWarnings?: boolean, findAndGlob?: CurrentPathFinder & Globber & DeterminesAbsolutePath, hierarchyDepth?: number): Spec[];
    /**
     * returns specs files with the excludes filtered
     *
     * @param  {String[] | String[][]} spec files -  list of spec files
     * @param  {String[]} exclude files -  list of exclude files
     * @return {String[] | String[][]} list of spec files with excludes removed
     */
    filterSpecs(specs: Spec[], exclude: string[]): Spec[];
}
export {};
//# sourceMappingURL=ConfigParser.d.ts.map