import WDIOReporter, { SuiteStats, RunnerStats } from '@wdio/reporter';
import type { Capabilities, Reporters } from '@wdio/types';
export default class ConciseReporter extends WDIOReporter {
    private _suiteUids;
    private _suites;
    private _stateCounts;
    constructor(options: Reporters.Options);
    onSuiteStart(suite: SuiteStats): void;
    onSuiteEnd(suite: SuiteStats): void;
    onTestFail(): void;
    onRunnerEnd(runner: RunnerStats): void;
    /**
    * Print the Concise report to the screen
    * @param  {Object} runner Wdio runner
    */
    printReport(runner: RunnerStats): void;
    /**
    * Get the display for failing tests
    * @return {String} Count display
    */
    getCountDisplay(): string;
    /**
    * Get display for failed tests, e.g. stack trace
    * @return {Array} Stack trace output
    */
    getFailureDisplay(): string[];
    /**
     * Get suites in the order they were called
     * @return {Array} Ordered suites
     */
    getOrderedSuites(): SuiteStats[];
    /**
     * Get information about the enviroment
     * @param  {Object}  caps    Enviroment details
     * @param  {Boolean} verbose
     * @return {String}          Enviroment string
     */
    getEnviromentCombo(caps: Capabilities.DesiredCapabilities): string;
}
//# sourceMappingURL=index.d.ts.map