"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getParentSuiteName = exports.isBrowserstackCapability = exports.getBrowserCapabilities = exports.getBrowserDescription = void 0;
const constants_1 = require("./constants");
/**
 * get browser description for Browserstack service
 * @param cap browser capablities
 */
function getBrowserDescription(cap) {
    cap = cap || {};
    if (cap['bstack:options']) {
        cap = { ...cap, ...cap['bstack:options'] };
    }
    /**
     * These keys describe the browser the test was run on
     */
    return constants_1.BROWSER_DESCRIPTION
        .map((k) => cap[k])
        .filter(Boolean)
        .join(' ');
}
exports.getBrowserDescription = getBrowserDescription;
/**
 * get correct browser capabilities object in both multiremote and normal setups
 * @param browser browser object
 * @param caps browser capbilities object. In case of multiremote, the object itself should have a property named 'capabilities'
 * @param browserName browser name in case of multiremote
 */
function getBrowserCapabilities(browser, caps, browserName) {
    if (!browser.isMultiremote) {
        return { ...browser.capabilities, ...caps };
    }
    const multiCaps = caps;
    const globalCap = browserName && browser[browserName] ? browser[browserName].capabilities : {};
    const cap = browserName && multiCaps[browserName] ? multiCaps[browserName].capabilities : {};
    return { ...globalCap, ...cap };
}
exports.getBrowserCapabilities = getBrowserCapabilities;
/**
 * check for browserstack W3C capabilities. Does not support legacy capabilities
 * @param cap browser capabilities
 */
function isBrowserstackCapability(cap) {
    return Boolean(cap && cap['bstack:options']);
}
exports.isBrowserstackCapability = isBrowserstackCapability;
function getParentSuiteName(fullTitle, testSuiteTitle) {
    const fullTitleWords = fullTitle.split(' ');
    const testSuiteTitleWords = testSuiteTitle.split(' ');
    const shortestLength = Math.min(fullTitleWords.length, testSuiteTitleWords.length);
    let c = 0;
    let parentSuiteName = '';
    while (c < shortestLength && fullTitleWords[c] === testSuiteTitleWords[c]) {
        parentSuiteName += fullTitleWords[c++] + ' ';
    }
    return parentSuiteName.trim();
}
exports.getParentSuiteName = getParentSuiteName;
