import type { Browser, MultiRemoteBrowser } from 'webdriverio';
import type { Capabilities } from '@wdio/types';
/**
 * get browser description for Browserstack service
 * @param cap browser capablities
 */
export declare function getBrowserDescription(cap: Capabilities.DesiredCapabilities): string;
/**
 * get correct browser capabilities object in both multiremote and normal setups
 * @param browser browser object
 * @param caps browser capbilities object. In case of multiremote, the object itself should have a property named 'capabilities'
 * @param browserName browser name in case of multiremote
 */
export declare function getBrowserCapabilities(browser: Browser<'async'> | MultiRemoteBrowser<'async'>, caps?: Capabilities.RemoteCapability, browserName?: string): Capabilities.Capabilities;
/**
 * check for browserstack W3C capabilities. Does not support legacy capabilities
 * @param cap browser capabilities
 */
export declare function isBrowserstackCapability(cap?: Capabilities.Capabilities): boolean;
export declare function getParentSuiteName(fullTitle: string, testSuiteTitle: string): string;
//# sourceMappingURL=util.d.ts.map