import type { Services, Capabilities, Options, Frameworks } from '@wdio/types';
import type { Browser, MultiRemoteBrowser } from 'webdriverio';
import { BrowserstackConfig, MultiRemoteAction } from './types';
export default class BrowserstackService implements Services.ServiceInstance {
    private _options;
    private _caps;
    private _config;
    private _sessionBaseUrl;
    private _failReasons;
    private _scenariosThatRan;
    private _failureStatuses;
    private _browser?;
    private _fullTitle?;
    constructor(_options: BrowserstackConfig, _caps: Capabilities.RemoteCapability, _config: Options.Testrunner);
    _updateCaps(fn: (caps: Capabilities.Capabilities | Capabilities.DesiredCapabilities) => void): void;
    /**
     * if no user and key is specified even though a browserstack service was
     * provided set user and key with values so that the session request
     * will fail
     */
    beforeSession(config: Options.Testrunner): void;
    before(caps: Capabilities.RemoteCapability, specs: string[], browser: Browser<'async'> | MultiRemoteBrowser<'async'>): Promise<void>;
    beforeSuite(suite: Frameworks.Suite): void;
    beforeFeature(uri: unknown, feature: {
        name: string;
    }): Promise<any>;
    afterTest(test: Frameworks.Test, context: never, results: Frameworks.TestResult): void;
    after(result: number): Promise<any>;
    /**
     * For CucumberJS
     */
    afterScenario(world: Frameworks.World): void;
    onReload(oldSessionId: string, newSessionId: string): Promise<void>;
    _isAppAutomate(): boolean;
    _updateJob(requestBody: any): Promise<any>;
    _multiRemoteAction(action: MultiRemoteAction): Promise<any>;
    _update(sessionId: string, requestBody: any): import("got").CancelableRequest<import("got").Response<string>>;
    _printSessionURL(): Promise<void>;
}
//# sourceMappingURL=service.d.ts.map