"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("util");
const perf_hooks_1 = require("perf_hooks");
const BrowserstackLocalLauncher = __importStar(require("browserstack-local"));
const logger_1 = __importDefault(require("@wdio/logger"));
const log = (0, logger_1.default)('@wdio/browserstack-service');
class BrowserstackLauncherService {
    constructor(_options, capabilities, _config) {
        this._options = _options;
        this._config = _config;
    }
    onPrepare(config, capabilities) {
        if (!this._options.browserstackLocal) {
            return log.info('browserstackLocal is not enabled - skipping...');
        }
        const opts = {
            key: this._config.key,
            forcelocal: true,
            onlyAutomate: true,
            ...this._options.opts
        };
        this.browserstackLocal = new BrowserstackLocalLauncher.Local();
        if (Array.isArray(capabilities)) {
            capabilities.forEach((capability) => {
                if (!capability['bstack:options']) {
                    capability['bstack:options'] = {};
                }
                capability['bstack:options'].local = true;
            });
        }
        else if (typeof capabilities === 'object') {
            Object.entries(capabilities).forEach(([, caps]) => {
                if (!caps.capabilities['bstack:options']) {
                    caps.capabilities['bstack:options'] = {};
                }
                caps.capabilities['bstack:options'].local = true;
            });
        }
        else {
            throw TypeError('Capabilities should be an object or Array!');
        }
        /**
         * measure TestingBot tunnel boot time
         */
        const obs = new perf_hooks_1.PerformanceObserver((list) => {
            const entry = list.getEntries()[0];
            log.info(`Browserstack Local successfully started after ${entry.duration}ms`);
        });
        obs.observe({ entryTypes: ['measure'] });
        let timer;
        perf_hooks_1.performance.mark('tbTunnelStart');
        return Promise.race([
            (0, util_1.promisify)(this.browserstackLocal.start.bind(this.browserstackLocal))(opts),
            new Promise((resolve, reject) => {
                /* istanbul ignore next */
                timer = setTimeout(function () {
                    reject('Browserstack Local failed to start within 60 seconds!');
                }, 60000);
            })
        ]).then(function (result) {
            clearTimeout(timer);
            perf_hooks_1.performance.mark('tbTunnelEnd');
            perf_hooks_1.performance.measure('bootTime', 'tbTunnelStart', 'tbTunnelEnd');
            return Promise.resolve(result);
        }, function (err) {
            clearTimeout(timer);
            return Promise.reject(err);
        });
    }
    onComplete() {
        if (!this.browserstackLocal || !this.browserstackLocal.isRunning()) {
            return;
        }
        if (this._options.forcedStop) {
            return process.kill(this.browserstackLocal.pid);
        }
        let timer;
        return Promise.race([
            new Promise((resolve, reject) => {
                var _a;
                (_a = this.browserstackLocal) === null || _a === void 0 ? void 0 : _a.stop((err) => {
                    if (err) {
                        return reject(err);
                    }
                    resolve();
                });
            }),
            new Promise((resolve, reject) => {
                /* istanbul ignore next */
                timer = setTimeout(() => reject(new Error('Browserstack Local failed to stop within 60 seconds!')), 60000);
            })
        ]).then(function (result) {
            clearTimeout(timer);
            return Promise.resolve(result);
        }, function (err) {
            clearTimeout(timer);
            return Promise.reject(err);
        });
    }
}
exports.default = BrowserstackLauncherService;
