var _ = require('./utils');
var messages = require('./messages');

module.exports = function molVastSetup(opts) {
  var player = this;
  var options = _.extend({}, this.options_, opts);

  var pluginSettings = {
    playAdAlways: true,
    adCancelTimeout: options.adCancelTimeout || 3000,
    adsEnabled: !!options.adsEnabled,
    vpaidFlashLoaderPath: './scripts/VPAIDFlash.swf'
  };

  if(options.adTagUrl){
    pluginSettings.adTagUrl = options.adTagUrl;
  }

  if(options.adTagXML) {
    pluginSettings.adTagXML = options.adTagXML;
  }

  var vastAd = player.vastClient(pluginSettings);

  player.on('reset', function () {
    if (player.options().plugins['ads-setup'].adsEnabled) {
      vastAd.enable();
    } else {
      vastAd.disable();
    }
  });

  player.on('vast.aderror', function(evt) {
    var error = evt.error;

    if(error && error.message) {
      messages.error(error.message);
    }
  });
};
