var PhotoSphereViewer=function(args){var isCanvasSupported=function(){var canvas=document.createElement("canvas");return!!(canvas.getContext&&canvas.getContext("2d"))};var isWebGLSupported=function(){var canvas=document.createElement("canvas");return!!(window.WebGLRenderingContext&&canvas.getContext("webgl"))};var addEvent=function(elt,evt,f){if(!!elt.addEventListener)elt.addEventListener(evt,f,false);else elt.attachEvent("on"+evt,f)};var stayBetween=function(x,min,max){return Math.max(min,Math.min(max,x))};var dist=function(x1,y1,x2,y2){var x=x2-x1;var y=y2-y1;return x*x+y*y};var getAngleMeasure=function(angle,is_2pi_allowed){is_2pi_allowed=is_2pi_allowed!==undefined?!!is_2pi_allowed:false;return is_2pi_allowed&&angle==2*Math.PI?2*Math.PI:angle-Math.floor(angle/(2*Math.PI))*2*Math.PI};this.load=function(){container.innerHTML="";if(!!loading_html&&loading_html.nodeType===1)container.appendChild(loading_html);else if(!!loading_html&&typeof loading_html=="string")container.innerHTML=loading_html;else if(!!loading_img){var loading=document.createElement("img");loading.setAttribute("src",loading_img);loading.setAttribute("alt",loading_msg);container.appendChild(loading)}else container.textContent=loading_msg;root=document.createElement("div");root.style.width="100%";root.style.height="100%";root.style.position="relative";root.style.overflow="hidden";if(!isCanvasSupported()){container.textContent="Canvas is not supported, update your browser!";return}if(window.THREE===undefined){console.log("PhotoSphereViewer: Three.js is not loaded.");return}viewer_size={width:0,height:0,ratio:0};if(readxmp&&!panorama.match(/^data:image\/[a-z]+;base64/))loadXMP();else createBuffer()};var getXMPData=function(file){var a=0,b=0;var data="";while((a=file.indexOf("<x:xmpmeta",b))!=-1&&(b=file.indexOf("</x:xmpmeta>",a))!=-1){data=file.substring(a,b);if(data.indexOf("GPano:")!=-1)return data}return""};var getAttribute=function(data,attr){var a=data.indexOf("GPano:"+attr)+attr.length+8,b=data.indexOf('"',a);if(b==-1){a=data.indexOf("GPano:"+attr)+attr.length+7;b=data.indexOf("<",a)}return data.substring(a,b)};var loadXMP=function(){var xhr=null;if(window.XMLHttpRequest)xhr=new XMLHttpRequest;else if(window.ActiveXObject){try{xhr=new ActiveXObject("Msxml2.XMLHTTP")}catch(e){xhr=new ActiveXObject("Microsoft.XMLHTTP")}}else{container.textContent="XHR is not supported, update your browser!";return}xhr.onreadystatechange=function(){if(xhr.readyState==4&&xhr.status==200){var data=getXMPData(xhr.responseText);if(!data.length){createBuffer();return}pano_size={full_width:parseInt(getAttribute(data,"FullPanoWidthPixels")),full_height:parseInt(getAttribute(data,"FullPanoHeightPixels")),cropped_width:parseInt(getAttribute(data,"CroppedAreaImageWidthPixels")),cropped_height:parseInt(getAttribute(data,"CroppedAreaImageHeightPixels")),cropped_x:parseInt(getAttribute(data,"CroppedAreaLeftPixels")),cropped_y:parseInt(getAttribute(data,"CroppedAreaTopPixels"))};recalculate_coords=true;createBuffer()}};xhr.open("GET",panorama,true);xhr.send(null)};var createBuffer=function(){var img=new Image;img.onload=function(){var default_pano_size={full_width:img.width,full_height:img.height,cropped_width:img.width,cropped_height:img.height,cropped_x:null,cropped_y:null};if(captured_view.horizontal_fov!=360||captured_view.vertical_fov!=180){pano_size.cropped_width=default_pano_size.cropped_width;pano_size.cropped_height=default_pano_size.cropped_height;pano_size.full_width=default_pano_size.full_width;pano_size.full_height=default_pano_size.full_height;if(captured_view.horizontal_fov!=360){var rh=captured_view.horizontal_fov/360;pano_size.full_width=pano_size.cropped_width/rh}if(captured_view.vertical_fov!=180){var rv=captured_view.vertical_fov/180;pano_size.full_height=pano_size.cropped_height/rv}}else{for(var attr in pano_size){if(pano_size[attr]===null&&default_pano_size[attr]!==undefined)pano_size[attr]=default_pano_size[attr]}if(recalculate_coords){if(pano_size.cropped_width!=default_pano_size.cropped_width){var rx=default_pano_size.cropped_width/pano_size.cropped_width;pano_size.cropped_width=default_pano_size.cropped_width;pano_size.full_width*=rx;pano_size.cropped_x*=rx}if(pano_size.cropped_height!=default_pano_size.cropped_height){var ry=default_pano_size.cropped_height/pano_size.cropped_height;pano_size.cropped_height=default_pano_size.cropped_height;pano_size.full_height*=ry;pano_size.cropped_y*=ry}}}if(pano_size.cropped_x===null)pano_size.cropped_x=(pano_size.full_width-pano_size.cropped_width)/2;if(pano_size.cropped_y===null)pano_size.cropped_y=(pano_size.full_height-pano_size.cropped_height)/2;var max_width=2048;if(isWebGLSupported()){var canvas_tmp=document.createElement("canvas");var ctx_tmp=canvas_tmp.getContext("webgl");max_width=ctx_tmp.getParameter(ctx_tmp.MAX_TEXTURE_SIZE)}var new_width=Math.min(pano_size.full_width,max_width);var r=new_width/pano_size.full_width;pano_size.full_width=new_width;pano_size.cropped_width*=r;pano_size.cropped_x*=r;img.width=pano_size.cropped_width;pano_size.full_height*=r;pano_size.cropped_height*=r;pano_size.cropped_y*=r;img.height=pano_size.cropped_height;var buffer=document.createElement("canvas");buffer.width=pano_size.full_width;buffer.height=pano_size.full_height;var ctx=buffer.getContext("2d");ctx.drawImage(img,pano_size.cropped_x,pano_size.cropped_y,pano_size.cropped_width,pano_size.cropped_height);loadTexture(buffer.toDataURL("image/jpeg"))};if(cors_anonymous&&!panorama.match(/^data:image\/[a-z]+;base64/))img.setAttribute("crossOrigin","anonymous");img.src=panorama};var loadTexture=function(path){var texture=new THREE.Texture;var loader=new THREE.ImageLoader;var onLoad=function(img){texture.needsUpdate=true;texture.image=img;createScene(texture)};loader.load(path,onLoad)};var createScene=function(texture){if(new_viewer_size.width!==undefined)container.style.width=new_viewer_size.width.css;if(new_viewer_size.height!==undefined)container.style.height=new_viewer_size.height.css;fitToContainer();renderer=isWebGLSupported()?new THREE.WebGLRenderer:new THREE.CanvasRenderer;renderer.setSize(viewer_size.width,viewer_size.height);scene=new THREE.Scene;camera=new THREE.PerspectiveCamera(PSV_FOV_MAX,viewer_size.ratio,1,300);camera.position.set(0,0,0);scene.add(camera);var geometry=new THREE.SphereGeometry(200,rings,segments);var material=new THREE.MeshBasicMaterial({map:texture,overdraw:true});var mesh=new THREE.Mesh(geometry,material);mesh.scale.x=-1;scene.add(mesh);canvas_container=document.createElement("div");canvas_container.style.position="absolute";canvas_container.style.zIndex=0;root.appendChild(canvas_container);if(display_navbar){navbar.setStyle(navbar_style);navbar.create();root.appendChild(navbar.getBar())}if(overlay!==null){var overlay_img=document.createElement("img");overlay_img.onload=function(){overlay_img.style.display="block";overlay_img.style.position="absolute";overlay_img.style[overlay.position.x]="5px";overlay_img.style[overlay.position.y]="5px";if(overlay.position.y=="bottom"&&display_navbar)overlay_img.style.bottom=navbar.getBar().offsetHeight+5+"px";if(overlay.size!==undefined){overlay_img.style.width=overlay.size.width;overlay_img.style.height=overlay.size.height}root.appendChild(overlay_img)};overlay_img.src=overlay.image}addEvent(window,"resize",fitToContainer);if(user_interactions_allowed){addEvent(canvas_container,"mousedown",onMouseDown);addEvent(document,"mousemove",onMouseMove);addEvent(canvas_container,"mousemove",showNavbar);addEvent(document,"mouseup",onMouseUp);addEvent(canvas_container,"touchstart",onTouchStart);addEvent(document,"touchend",onMouseUp);addEvent(document,"touchmove",onTouchMove);if(scroll_to_zoom){addEvent(canvas_container,"mousewheel",onMouseWheel);addEvent(canvas_container,"DOMMouseScroll",onMouseWheel)}self.addAction("fullscreen-mode",toggleArrowKeys)}addEvent(document,"fullscreenchange",fullscreenToggled);addEvent(document,"mozfullscreenchange",fullscreenToggled);addEvent(document,"webkitfullscreenchange",fullscreenToggled);addEvent(document,"MSFullscreenChange",fullscreenToggled);sphoords.addListener(onDeviceOrientation);container.innerHTML="";container.appendChild(root);var canvas=renderer.domElement;canvas.style.display="block";canvas_container.appendChild(canvas);render();if(zoom_lvl>0)zoom(zoom_lvl);anim();triggerAction("ready")};var render=function(){var point=new THREE.Vector3;point.setX(Math.cos(lat)*Math.sin(long));point.setY(Math.sin(lat));point.setZ(Math.cos(lat)*Math.cos(long));camera.lookAt(point);if(stereo_effect!==null)stereo_effect.render(scene,camera);else renderer.render(scene,camera)};var startStereo=function(){stereo_effect=new THREE.StereoEffect(renderer);stereo_effect.eyeSeparation=eyes_offset;stereo_effect.setSize(viewer_size.width,viewer_size.height);startDeviceOrientation();enableFullscreen();navbar.mustBeHidden();render();triggerAction("stereo-effect",true)};var stopStereo=function(){stereo_effect=null;renderer.setSize(viewer_size.width,viewer_size.height);navbar.mustBeHidden(false);render();triggerAction("stereo-effect",false)};this.toggleStereo=function(){if(stereo_effect!==null)stopStereo();else startStereo()};var anim=function(){if(anim_delay!==false)anim_timeout=setTimeout(startAutorotate,anim_delay)};var autorotate=function(){lat-=(lat-anim_lat_target)*anim_lat_offset;long+=anim_long_offset;var again=true;if(!whole_circle){long=stayBetween(long,PSV_MIN_LONGITUDE,PSV_MAX_LONGITUDE);if(long==PSV_MIN_LONGITUDE||long==PSV_MAX_LONGITUDE){if(reverse_anim)anim_long_offset*=-1;else{stopAutorotate();again=false}}}long=getAngleMeasure(long,true);triggerAction("position-updated",{longitude:long,latitude:lat});render();if(again)autorotate_timeout=setTimeout(autorotate,PSV_ANIM_TIMEOUT)};var startAutorotate=function(){autorotate();triggerAction("autorotate",true)};var stopAutorotate=function(){clearTimeout(anim_timeout);anim_timeout=null;clearTimeout(autorotate_timeout);autorotate_timeout=null;triggerAction("autorotate",false)};this.toggleAutorotate=function(){clearTimeout(anim_timeout);if(!!autorotate_timeout)stopAutorotate();else startAutorotate()};var fitToContainer=function(){if(container.clientWidth!=viewer_size.width||container.clientHeight!=viewer_size.height){resize({width:container.clientWidth,height:container.clientHeight})}};this.fitToContainer=function(){fitToContainer()};var resize=function(size){viewer_size.width=size.width!==undefined?parseInt(size.width):viewer_size.width;viewer_size.height=size.height!==undefined?parseInt(size.height):viewer_size.height;viewer_size.ratio=viewer_size.width/viewer_size.height;if(!!camera){camera.aspect=viewer_size.ratio;camera.updateProjectionMatrix()}if(!!renderer){renderer.setSize(viewer_size.width,viewer_size.height);render()}if(!!stereo_effect){stereo_effect.setSize(viewer_size.width,viewer_size.height);render()}};this.getPosition=function(){return{longitude:long,latitude:lat}};this.getPositionInDegrees=function(){return{longitude:long*180/Math.PI,latitude:lat*180/Math.PI}};var moveTo=function(longitude,latitude){var long_tmp=parseAngle(longitude);if(!whole_circle)long_tmp=stayBetween(long_tmp,PSV_MIN_LONGITUDE,PSV_MAX_LONGITUDE);var lat_tmp=parseAngle(latitude);if(lat_tmp>Math.PI)lat_tmp-=2*Math.PI;lat_tmp=stayBetween(lat_tmp,PSV_TILT_DOWN_MAX,PSV_TILT_UP_MAX);long=long_tmp;lat=lat_tmp;triggerAction("position-updated",{longitude:long,latitude:lat});render()};this.moveTo=function(longitude,latitude){moveTo(longitude,latitude)};var rotate=function(dlong,dlat){dlong=parseAngle(dlong);dlat=parseAngle(dlat);moveTo(long+dlong,lat+dlat)};this.rotate=function(dlong,dlat){rotate(dlong,dlat)};var toggleArrowKeys=function(attach){var action=attach?window.addEventListener:window.removeEventListener;action("keydown",keyDown)};var retrieveKey=function(evt){if(evt.key){var key=/^Arrow/.test(evt.key)?evt.key:"Arrow"+evt.key;return key}if(evt.keyCode||evt.which){var key_code=evt.keyCode?evt.keyCode:evt.which;var keycodes_map={38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",37:"ArrowLeft"};if(keycodes_map[key_code]!==undefined)return keycodes_map[key_code]}return""};var keyDown=function(evt){var dlong=0,dlat=0;switch(retrieveKey(evt)){case"ArrowUp":dlat=PSV_KEYBOARD_LAT_OFFSET;break;case"ArrowRight":dlong=-PSV_KEYBOARD_LONG_OFFSET;break;case"ArrowDown":dlat=-PSV_KEYBOARD_LAT_OFFSET;break;case"ArrowLeft":dlong=PSV_KEYBOARD_LONG_OFFSET;break}rotate(dlong,dlat)};var onMouseDown=function(evt){startMove(parseInt(evt.clientX),parseInt(evt.clientY))};var onTouchStart=function(evt){if(evt.touches.length==1){var touch=evt.touches[0];if(touch.target.parentNode==canvas_container)startMove(parseInt(touch.clientX),parseInt(touch.clientY))}else if(evt.touches.length==2){onMouseUp();if(evt.touches[0].target.parentNode==canvas_container&&evt.touches[1].target.parentNode==canvas_container)startTouchZoom(dist(evt.touches[0].clientX,evt.touches[0].clientY,evt.touches[1].clientX,evt.touches[1].clientY))}showNavbar()};var startMove=function(x,y){mouse_x=x;mouse_y=y;stopAutorotate();mousedown=true};var startTouchZoom=function(d){touchzoom_dist=d;touchzoom=true};var onMouseUp=function(evt){mousedown=false;touchzoom=false};var onMouseMove=function(evt){evt.preventDefault();move(parseInt(evt.clientX),parseInt(evt.clientY))};var onTouchMove=function(evt){if(evt.touches.length==1&&mousedown){var touch=evt.touches[0];if(touch.target.parentNode==canvas_container){evt.preventDefault();move(parseInt(touch.clientX),parseInt(touch.clientY))}}else if(evt.touches.length==2){if(evt.touches[0].target.parentNode==canvas_container&&evt.touches[1].target.parentNode==canvas_container&&touchzoom){evt.preventDefault();var d=dist(evt.touches[0].clientX,evt.touches[0].clientY,evt.touches[1].clientX,evt.touches[1].clientY);var diff=d-touchzoom_dist;if(diff!==0){var direction=diff/Math.abs(diff);zoom(zoom_lvl+direction*zoom_speed);touchzoom_dist=d}}}};var move=function(x,y){if(mousedown){if(smooth_user_moves){long+=(x-mouse_x)/viewer_size.height*fov*Math.PI/180;lat+=(y-mouse_y)/viewer_size.height*fov*Math.PI/180}else{long+=(x-mouse_x)*PSV_LONG_OFFSET;lat+=(y-mouse_y)*PSV_LAT_OFFSET}mouse_x=x;mouse_y=y;if(!whole_circle)long=stayBetween(long,PSV_MIN_LONGITUDE,PSV_MAX_LONGITUDE);long=getAngleMeasure(long,true);lat=stayBetween(lat,PSV_TILT_DOWN_MAX,PSV_TILT_UP_MAX);triggerAction("position-updated",{longitude:long,latitude:lat});render()}};var startDeviceOrientation=function(){sphoords.start();stopAutorotate();triggerAction("device-orientation",true)};var stopDeviceOrientation=function(){sphoords.stop();triggerAction("device-orientation",false)};this.toggleDeviceOrientation=function(){if(sphoords.isEventAttached())stopDeviceOrientation();else startDeviceOrientation()};var onDeviceOrientation=function(coords){long=stayBetween(coords.longitude,PSV_MIN_LONGITUDE,PSV_MAX_LONGITUDE);lat=stayBetween(coords.latitude,PSV_TILT_DOWN_MAX,PSV_TILT_UP_MAX);triggerAction("position-updated",{longitude:long,latitude:lat});render()};var onMouseWheel=function(evt){evt.preventDefault();evt.stopPropagation();var delta=evt.detail?-evt.detail:evt.wheelDelta;if(delta!==0){var direction=parseInt(delta/Math.abs(delta));zoom(zoom_lvl+direction*zoom_speed)}};this.mouseWheel=function(evt){onMouseWheel(evt)};var zoom=function(level){zoom_lvl=stayBetween(level,0,100);fov=PSV_FOV_MAX+zoom_lvl/100*(PSV_FOV_MIN-PSV_FOV_MAX);camera.fov=fov;camera.updateProjectionMatrix();render();triggerAction("zoom-updated",zoom_lvl)};this.getZoomLevel=function(){return zoom_lvl};this.zoom=function(level){zoom(level)};this.zoomIn=function(){if(zoom_lvl<100)zoom(zoom_lvl+zoom_speed)};this.zoomOut=function(){if(zoom_lvl>0)zoom(zoom_lvl-zoom_speed)};var isFullscreenEnabled=function(){return!!document.fullscreenElement||!!document.mozFullScreenElement||!!document.webkitFullscreenElement||!!document.msFullscreenElement};var fullscreenToggled=function(){if(!!document.webkitFullscreenElement||!!document.msFullscreenElement){real_viewer_size.width=container.style.width;real_viewer_size.height=container.style.height;container.style.width="100%";container.style.height="100%";fitToContainer()}else if(!!container.webkitRequestFullscreen||!!container.msRequestFullscreen){container.style.width=real_viewer_size.width;container.style.height=real_viewer_size.height;fitToContainer()}triggerAction("fullscreen-mode",isFullscreenEnabled())};var enableFullscreen=function(){if(!!container.requestFullscreen)container.requestFullscreen();else if(!!container.mozRequestFullScreen)container.mozRequestFullScreen();else if(!!container.webkitRequestFullscreen)container.webkitRequestFullscreen();else if(!!container.msRequestFullscreen)container.msRequestFullscreen()};var disableFullscreen=function(){if(!!document.exitFullscreen)document.exitFullscreen();else if(!!document.mozCancelFullScreen)document.mozCancelFullScreen();else if(!!document.webkitExitFullscreen)document.webkitExitFullscreen();else if(!!document.msExitFullscreen)document.msExitFullscreen()};this.toggleFullscreen=function(){if(!isFullscreenEnabled())enableFullscreen();else disableFullscreen()};var showNavbar=function(){if(display_navbar)navbar.show()};var parseAnimationSpeed=function(speed){speed=speed.toString().trim();var speed_value=parseFloat(speed.replace(/^(-?[0-9]+(?:\.[0-9]*)?).*$/,"$1"));var speed_unit=speed.replace(/^-?[0-9]+(?:\.[0-9]*)?(.*)$/,"$1").trim();if(speed_unit.match(/(pm|per minute)$/))speed_value/=60;var rad_per_second=0;switch(speed_unit){case"rpm":case"rev per minute":case"revolutions per minute":case"rps":case"rev per second":case"revolutions per second":rad_per_second=speed_value*2*Math.PI;break;case"dpm":case"deg per minute":case"degrees per minute":case"dps":case"deg per second":case"degrees per second":rad_per_second=speed_value*Math.PI/180;break;case"rad per minute":case"radians per minute":case"rad per second":case"radians per second":rad_per_second=speed_value;break;default:m_anim=false}return rad_per_second*PSV_ANIM_TIMEOUT/1e3};var parseAngle=function(angle){angle=angle.toString().trim();var angle_value=parseFloat(angle.replace(/^(-?[0-9]+(?:\.[0-9]*)?).*$/,"$1"));var angle_unit=angle.replace(/^-?[0-9]+(?:\.[0-9]*)?(.*)$/,"$1").trim();if(angle_unit=="deg")angle_value*=Math.PI/180;return getAngleMeasure(angle_value)};var setNewViewerSize=function(size){for(var dim in size){if(dim=="width"||dim=="height"){var size_str=size[dim].toString().trim();var size_value=parseFloat(size_str.replace(/^([0-9]+(?:\.[0-9]*)?).*$/,"$1"));var size_unit=size_str.replace(/^[0-9]+(?:\.[0-9]*)?(.*)$/,"$1").trim();if(size_unit!="%")size_unit="px";new_viewer_size[dim]={css:size_value+size_unit,unit:size_unit}}}};this.addAction=function(name,f){if(!(name in actions))actions[name]=[];actions[name].push(f)};var triggerAction=function(name,arg){if(name in actions&&!!actions[name].length){for(var i=0,l=actions[name].length;i<l;++i){if(arg!==undefined)actions[name][i](arg);else actions[name][i]()}}};if(args===undefined||args.panorama===undefined||args.container===undefined){console.log("PhotoSphereViewer: no value given for panorama or container");return}var smooth_user_moves=args.smooth_user_moves!==undefined?!!args.smooth_user_moves:true;var PSV_LONG_OFFSET=args.long_offset!==undefined?parseAngle(args.long_offset):Math.PI/360;var PSV_LAT_OFFSET=args.lat_offset!==undefined?parseAngle(args.lat_offset):Math.PI/180;var PSV_KEYBOARD_LONG_OFFSET=args.keyboard_long_offset!==undefined?parseAngle(args.keyboard_long_offset):Math.PI/60;var PSV_KEYBOARD_LAT_OFFSET=args.keyboard_lat_offset!==undefined?parseAngle(args.keyboard_lat_offset):Math.PI/120;var PSV_FOV_MIN=args.min_fov!==undefined?stayBetween(parseFloat(args.min_fov),1,179):30;var PSV_FOV_MAX=args.max_fov!==undefined?stayBetween(parseFloat(args.max_fov),1,179):90;var PSV_TILT_UP_MAX=args.tilt_up_max!==undefined?stayBetween(parseAngle(args.tilt_up_max),0,Math.PI/2):Math.PI/2;var PSV_TILT_DOWN_MAX=args.tilt_down_max!==undefined?-stayBetween(parseAngle(args.tilt_down_max),0,Math.PI/2):-Math.PI/2;var min_long=args.min_longitude!==undefined?parseAngle(args.min_longitude):0;var max_long=args.max_longitude!==undefined?parseAngle(args.max_longitude):0;var whole_circle=min_long==max_long;if(whole_circle){min_long=0;max_long=2*Math.PI}else if(max_long===0)max_long=2*Math.PI;var PSV_MIN_LONGITUDE,PSV_MAX_LONGITUDE;if(min_long<max_long){PSV_MIN_LONGITUDE=min_long;PSV_MAX_LONGITUDE=max_long}else{PSV_MIN_LONGITUDE=max_long;PSV_MAX_LONGITUDE=min_long}var lat=0,long=PSV_MIN_LONGITUDE;if(args.default_position!==undefined){if(args.default_position.lat!==undefined){var lat_angle=parseAngle(args.default_position.lat);if(lat_angle>Math.PI)lat_angle-=2*Math.PI;lat=stayBetween(lat_angle,PSV_TILT_DOWN_MAX,PSV_TILT_UP_MAX)}if(args.default_position.long!==undefined)long=stayBetween(parseAngle(args.default_position.long),PSV_MIN_LONGITUDE,PSV_MAX_LONGITUDE)}var segments=args.segments!==undefined?parseInt(args.segments):100;var rings=args.rings!==undefined?parseInt(args.rings):100;var zoom_lvl=0;if(args.zoom_level!==undefined)zoom_lvl=stayBetween(parseInt(Math.round(args.zoom_level)),0,100);var fov=PSV_FOV_MAX+zoom_lvl/100*(PSV_FOV_MIN-PSV_FOV_MAX);var PSV_FRAMES_PER_SECOND=60;var PSV_ANIM_TIMEOUT=1e3/PSV_FRAMES_PER_SECOND;var anim_delay=2e3;if(args.time_anim!==undefined){if(typeof args.time_anim=="number"&&args.time_anim>=0)anim_delay=args.time_anim;else anim_delay=false}var anim_long_offset=args.anim_speed!==undefined?parseAnimationSpeed(args.anim_speed):parseAnimationSpeed("2rpm");var reverse_anim=true;if(args.reverse_anim!==undefined)reverse_anim=!!args.reverse_anim;var anim_lat_offset=args.vertical_anim_speed!==undefined?parseAnimationSpeed(args.vertical_anim_speed):parseAnimationSpeed("2rpm");var anim_lat_target=0;if(args.vertical_anim_target!==undefined){var lat_target_angle=parseAngle(args.vertical_anim_target);if(lat_target_angle>Math.PI)lat_target_angle-=2*Math.PI;anim_lat_target=stayBetween(lat_target_angle,PSV_TILT_DOWN_MAX,PSV_TILT_UP_MAX)}var navbar=new PSVNavBar(this);var display_navbar=args.navbar!==undefined?!!args.navbar:false;var navbar_style=args.navbar_style!==undefined?args.navbar_style:{};var user_interactions_allowed=args.allow_user_interactions!==undefined?!!args.allow_user_interactions:true;if(!user_interactions_allowed)display_navbar=false;var scroll_to_zoom=args.allow_scroll_to_zoom!==undefined?!!args.allow_scroll_to_zoom:true;var zoom_speed=args.zoom_speed!==undefined?parseFloat(args.zoom_speed):1;var eyes_offset=args.eyes_offset!==undefined?parseFloat(args.eyes_offset):5;var container=typeof args.container=="string"?document.getElementById(args.container):args.container;var viewer_size,new_viewer_size={},real_viewer_size={};if(args.size!==undefined)setNewViewerSize(args.size);var panorama=args.panorama;var root,canvas_container;var renderer=null,scene=null,camera=null,stereo_effect=null;var mousedown=false,mouse_x=0,mouse_y=0;var touchzoom=false,touchzoom_dist=0;var autorotate_timeout=null,anim_timeout=null;var sphoords=new Sphoords;var actions={};var readxmp=args.usexmpdata!==undefined?!!args.usexmpdata:true;var cors_anonymous=args.cors_anonymous!==undefined?!!args.cors_anonymous:true;var pano_size={full_width:null,full_height:null,cropped_width:null,cropped_height:null,cropped_x:null,cropped_y:null};if(args.pano_size!==undefined){for(var attr in pano_size){if(args.pano_size[attr]!==undefined)pano_size[attr]=parseInt(args.pano_size[attr])}readxmp=false}var captured_view={horizontal_fov:360,vertical_fov:180};if(args.captured_view!==undefined){for(var attr in captured_view){if(args.captured_view[attr]!==undefined)captured_view[attr]=parseFloat(args.captured_view[attr])}readxmp=false}var recalculate_coords=false;var loading_msg=args.loading_msg!==undefined?args.loading_msg.toString():"Loading…";var loading_img=args.loading_img!==undefined?args.loading_img.toString():null;var loading_html=args.loading_html!==undefined?args.loading_html:null;var overlay=null;if(args.overlay!==undefined){if(args.overlay.image!==undefined){overlay={image:args.overlay.image,position:{x:"left",y:"bottom"}};if(args.overlay.position!==undefined){if(args.overlay.position.x!==undefined&&(args.overlay.position.x=="left"||args.overlay.position.x=="right"))overlay.position.x=args.overlay.position.x;if(args.overlay.position.y!==undefined&&(args.overlay.position.y=="top"||args.overlay.position.y=="bottom"))overlay.position.y=args.overlay.position.y}if(args.overlay.size!==undefined){overlay.size={width:args.overlay.size.width!==undefined?args.overlay.size.width:"auto",height:args.overlay.size.height!==undefined?args.overlay.size.height:"auto"}}}}var self=this;if(args.onready!==undefined)this.addAction("ready",args.onready);var autoload=args.autoload!==undefined?!!args.autoload:true;if(autoload)this.load()};var PSVNavBar=function(psv){var inArray=function(searched,array){for(var i=0,l=array.length;i<l;++i){if(array[i]==searched)return true}return false};var checkValue=function(property,value){return inArray(property,colors)&&typeof value=="string"&&(value=="transparent"||!!value.match(/^#([0-9A-Fa-f]{3}|[0-9A-Fa-f]{6})$/)||!!value.match(/^rgb\((1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])(,\s*(1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}\)$/)||!!value.match(/^rgba\(((1?[0-9]{1,2}|2[0-4][0-9]|25[0-5]),\s*){3}(0(\.[0-9]*)?|1)\)$/))||inArray(property,numbers)&&!isNaN(parseFloat(value))&&isFinite(value)&&value>=0};this.setStyle=function(new_style){for(var property in new_style){if(property in style&&checkValue(property,new_style[property]))style[property]=new_style[property]}};this.create=function(){container=document.createElement("div");container.style.backgroundColor=style.backgroundColor;container.style.position="absolute";container.style.zIndex=10;container.style.bottom=0;container.style.width="100%";container.style.boxSizing="content-box";container.style.transition="bottom 0.4s ease-out";autorotate=new PSVNavBarButton(psv,"autorotate",style);container.appendChild(autorotate.getButton());zoom=new PSVNavBarButton(psv,"zoom",style);container.appendChild(zoom.getButton());fullscreen=new PSVNavBarButton(psv,"fullscreen",style);container.appendChild(fullscreen.getButton());if(Sphoords.isDeviceOrientationSupported){orientation=new PSVNavBarButton(psv,"orientation",style);container.appendChild(orientation.getButton());vr=new PSVNavBarButton(psv,"virtual-reality",style);container.appendChild(vr.getButton())}};this.getBar=function(){return container};var show=function(){if(!!must_hide_timeout){clearTimeout(must_hide_timeout);if(!hidden&&must_be_hidden)must_hide_timeout=setTimeout(hide,5e3)}if(hidden){container.style.bottom=0;hidden=false;if(must_be_hidden)must_hide_timeout=setTimeout(hide,5e3)}};this.show=function(){show()};var hide=function(){if(!hidden){container.style.bottom=-container.offsetHeight+1+"px";hidden=true}};this.hide=function(){hide()};this.isHidden=function(){return hidden};this.mustBeHidden=function(state){must_be_hidden=state!==undefined?!!state:true;if(must_be_hidden)hide();else show()};var style={backgroundColor:"rgba(61, 61, 61, 0.5)",buttonsColor:"rgba(255, 255, 255, 0.7)",buttonsBackgroundColor:"transparent",activeButtonsBackgroundColor:"rgba(255, 255, 255, 0.1)",buttonsHeight:20,autorotateThickness:1,zoomRangeWidth:50,zoomRangeThickness:1,zoomRangeDisk:7,fullscreenRatio:4/3,fullscreenThickness:2,gyroscopeThickness:1,virtualRealityRatio:4/3,virtualRealityBorderRadius:2};var colors=["backgroundColor","buttonsColor","buttonsBackgroundColor","activeButtonsBackgroundColor"];var numbers=["buttonsHeight","autorotateThickness","zoomRangeWidth","zoomRangeThickness","zoomRangeDisk","fullscreenRatio","fullscreenThickness"];var container;var autorotate,zoom,fullscreen,orientation,vr;var must_hide_timeout=null;var hidden=false,must_be_hidden=false};var PSVNavBarButton=function(psv,type,style){var addEvent=function(elt,evt,f){if(!!elt.addEventListener)elt.addEventListener(evt,f,false);else elt.attachEvent("on"+evt,f)};var create=function(){switch(type){case"autorotate":var autorotate_sphere_width=style.buttonsHeight-style.autorotateThickness*2;var autorotate_equator_height=autorotate_sphere_width/10;button=document.createElement("div");button.style.cssFloat="left";button.style.boxSizing="inherit";button.style.padding="10px";button.style.width=style.buttonsHeight+"px";button.style.height=style.buttonsHeight+"px";button.style.backgroundColor=style.buttonsBackgroundColor;button.style.position="relative";button.style.cursor="pointer";addEvent(button,"click",function(){psv.toggleAutorotate()});var autorotate_sphere=document.createElement("div");autorotate_sphere.style.boxSizing="inherit";autorotate_sphere.style.width=autorotate_sphere_width+"px";autorotate_sphere.style.height=autorotate_sphere_width+"px";autorotate_sphere.style.borderRadius="50%";autorotate_sphere.style.border=style.autorotateThickness+"px solid "+style.buttonsColor;button.appendChild(autorotate_sphere);var autorotate_equator=document.createElement("div");autorotate_equator.style.boxSizing="inherit";autorotate_equator.style.width=autorotate_sphere_width+"px";autorotate_equator.style.height=autorotate_equator_height+"px";autorotate_equator.style.borderRadius="50%";autorotate_equator.style.border=style.autorotateThickness+"px solid "+style.buttonsColor;autorotate_equator.style.position="absolute";autorotate_equator.style.top="50%";autorotate_equator.style.marginTop=-(autorotate_equator_height/2+style.autorotateThickness)+"px";button.appendChild(autorotate_equator);psv.addAction("autorotate",toggleActive);break;case"zoom":button=document.createElement("div");button.style.cssFloat="left";button.style.boxSizing="inherit";var zoom_minus=document.createElement("div");zoom_minus.style.cssFloat="left";zoom_minus.style.boxSizing="inherit";zoom_minus.style.padding="10px";zoom_minus.style.height=style.buttonsHeight+"px";zoom_minus.style.backgroundColor=style.buttonsBackgroundColor;zoom_minus.style.lineHeight=style.buttonsHeight+"px";zoom_minus.style.color=style.buttonsColor;zoom_minus.style.cursor="pointer";zoom_minus.textContent="-";addEvent(zoom_minus,"click",function(){psv.zoomOut()});button.appendChild(zoom_minus);zoom_range_bg=document.createElement("div");zoom_range_bg.style.cssFloat="left";zoom_range_bg.style.boxSizing="inherit";zoom_range_bg.style.padding=10+(style.buttonsHeight-style.zoomRangeThickness)/2+"px 5px";zoom_range_bg.style.backgroundColor=style.buttonsBackgroundColor;zoom_range_bg.style.cursor="pointer";button.appendChild(zoom_range_bg);zoom_range=document.createElement("div");zoom_range.style.boxSizing="inherit";zoom_range.style.width=style.zoomRangeWidth+"px";zoom_range.style.height=style.zoomRangeThickness+"px";zoom_range.style.backgroundColor=style.buttonsColor;zoom_range.style.position="relative";zoom_range_bg.appendChild(zoom_range);zoom_value=document.createElement("div");zoom_value.style.position="absolute";zoom_value.style.top=(style.zoomRangeThickness-style.zoomRangeDisk)/2+"px";zoom_value.style.left=-(style.zoomRangeDisk/2)+"px";zoom_value.style.boxSizing="inherit";zoom_value.style.width=style.zoomRangeDisk+"px";zoom_value.style.height=style.zoomRangeDisk+"px";zoom_value.style.borderRadius="50%";zoom_value.style.backgroundColor=style.buttonsColor;psv.addAction("zoom-updated",moveZoomValue);addEvent(zoom_range_bg,"mousedown",initZoomChangeWithMouse);addEvent(zoom_range_bg,"touchstart",initZoomChangeByTouch);addEvent(document,"mousemove",changeZoomWithMouse);addEvent(document,"touchmove",changeZoomByTouch);addEvent(document,"mouseup",stopZoomChange);addEvent(document,"touchend",stopZoomChange);addEvent(zoom_range_bg,"mousewheel",changeZoomOnMouseWheel);addEvent(zoom_range_bg,"DOMMouseScroll",changeZoomOnMouseWheel);zoom_range.appendChild(zoom_value);var zoom_plus=document.createElement("div");zoom_plus.style.cssFloat="left";zoom_plus.style.boxSizing="inherit";zoom_plus.style.padding="10px";zoom_plus.style.height=style.buttonsHeight+"px";zoom_plus.style.backgroundColor=style.buttonsBackgroundColor;zoom_plus.style.lineHeight=style.buttonsHeight+"px";zoom_plus.style.color=style.buttonsColor;
zoom_plus.style.cursor="pointer";zoom_plus.textContent="+";addEvent(zoom_plus,"click",function(){psv.zoomIn()});button.appendChild(zoom_plus);break;case"fullscreen":var fullscreen_width=style.buttonsHeight*style.fullscreenRatio;var fullscreen_vertical_space=style.buttonsHeight*.3;var fullscreen_vertical_border=(style.buttonsHeight-fullscreen_vertical_space)/2;var fullscreen_horizontal_space=fullscreen_width*.3;var fullscreen_horizontal_border=(fullscreen_width-fullscreen_horizontal_space)/2-style.fullscreenThickness;var fullscreen_vertical_int=style.buttonsHeight-style.fullscreenThickness*2;button=document.createElement("div");button.style.cssFloat="right";button.style.boxSizing="inherit";button.style.padding="10px";button.style.width=fullscreen_width+"px";button.style.height=style.buttonsHeight+"px";button.style.backgroundColor=style.buttonsBackgroundColor;button.style.cursor="pointer";addEvent(button,"click",function(){psv.toggleFullscreen()});var fullscreen_left=document.createElement("div");fullscreen_left.style.cssFloat="left";fullscreen_left.style.boxSizing="inherit";fullscreen_left.style.width=style.fullscreenThickness+"px";fullscreen_left.style.height=fullscreen_vertical_space+"px";fullscreen_left.style.borderStyle="solid";fullscreen_left.style.borderColor=style.buttonsColor+" transparent";fullscreen_left.style.borderWidth=fullscreen_vertical_border+"px 0";button.appendChild(fullscreen_left);var fullscreen_tb_1=document.createElement("div");fullscreen_tb_1.style.cssFloat="left";fullscreen_tb_1.style.boxSizing="inherit";fullscreen_tb_1.style.width=fullscreen_horizontal_border+"px";fullscreen_tb_1.style.height=fullscreen_vertical_int+"px";fullscreen_tb_1.style.borderStyle="solid";fullscreen_tb_1.style.borderColor=style.buttonsColor+" transparent";fullscreen_tb_1.style.borderWidth=style.fullscreenThickness+"px 0";button.appendChild(fullscreen_tb_1);var fullscreen_tb_2=document.createElement("div");fullscreen_tb_2.style.cssFloat="left";fullscreen_tb_2.style.boxSizing="inherit";fullscreen_tb_2.style.marginLeft=fullscreen_horizontal_space+"px";fullscreen_tb_2.style.width=fullscreen_horizontal_border+"px";fullscreen_tb_2.style.height=fullscreen_vertical_int+"px";fullscreen_tb_2.style.borderStyle="solid";fullscreen_tb_2.style.borderColor=style.buttonsColor+" transparent";fullscreen_tb_2.style.borderWidth=style.fullscreenThickness+"px 0";button.appendChild(fullscreen_tb_2);var fullscreen_right=document.createElement("div");fullscreen_right.style.cssFloat="left";fullscreen_right.style.boxSizing="inherit";fullscreen_right.style.width=style.fullscreenThickness+"px";fullscreen_right.style.height=fullscreen_vertical_space+"px";fullscreen_right.style.borderStyle="solid";fullscreen_right.style.borderColor=style.buttonsColor+" transparent";fullscreen_right.style.borderWidth=fullscreen_vertical_border+"px 0";button.appendChild(fullscreen_right);var fullscreen_clearer=document.createElement("div");fullscreen_clearer.style.clear="left";button.appendChild(fullscreen_clearer);psv.addAction("fullscreen-mode",toggleActive);break;case"orientation":var gyroscope_sphere_width=style.buttonsHeight-style.gyroscopeThickness*2;var gyroscope_ellipses_big_axis=gyroscope_sphere_width-style.gyroscopeThickness*4;var gyroscope_ellipses_little_axis=gyroscope_sphere_width/10;button=document.createElement("div");button.style.cssFloat="right";button.style.boxSizing="inherit";button.style.padding="10px";button.style.width=style.buttonsHeight+"px";button.style.height=style.buttonsHeight+"px";button.style.backgroundColor=style.buttonsBackgroundColor;button.style.position="relative";button.style.cursor="pointer";addEvent(button,"click",function(){psv.toggleDeviceOrientation()});var gyroscope_sphere=document.createElement("div");gyroscope_sphere.style.boxSizing="inherit";gyroscope_sphere.style.width=gyroscope_sphere_width+"px";gyroscope_sphere.style.height=gyroscope_sphere_width+"px";gyroscope_sphere.style.borderRadius="50%";gyroscope_sphere.style.border=style.gyroscopeThickness+"px solid "+style.buttonsColor;button.appendChild(gyroscope_sphere);var gyroscope_hor_ellipsis=document.createElement("div");gyroscope_hor_ellipsis.style.boxSizing="inherit";gyroscope_hor_ellipsis.style.width=gyroscope_ellipses_big_axis+"px";gyroscope_hor_ellipsis.style.height=gyroscope_ellipses_little_axis+"px";gyroscope_hor_ellipsis.style.borderRadius="50%";gyroscope_hor_ellipsis.style.border=style.gyroscopeThickness+"px solid "+style.buttonsColor;gyroscope_hor_ellipsis.style.position="absolute";gyroscope_hor_ellipsis.style.top="50%";gyroscope_hor_ellipsis.style.left="50%";gyroscope_hor_ellipsis.style.marginTop=-(gyroscope_ellipses_little_axis/2+style.gyroscopeThickness)+"px";gyroscope_hor_ellipsis.style.marginLeft=-(gyroscope_ellipses_big_axis/2+style.gyroscopeThickness)+"px";button.appendChild(gyroscope_hor_ellipsis);var gyroscope_ver_ellipsis=document.createElement("div");gyroscope_ver_ellipsis.style.boxSizing="inherit";gyroscope_ver_ellipsis.style.width=gyroscope_ellipses_little_axis+"px";gyroscope_ver_ellipsis.style.height=gyroscope_ellipses_big_axis+"px";gyroscope_ver_ellipsis.style.borderRadius="50%";gyroscope_ver_ellipsis.style.border=style.gyroscopeThickness+"px solid "+style.buttonsColor;gyroscope_ver_ellipsis.style.position="absolute";gyroscope_ver_ellipsis.style.top="50%";gyroscope_ver_ellipsis.style.left="50%";gyroscope_ver_ellipsis.style.marginTop=-(gyroscope_ellipses_big_axis/2+style.gyroscopeThickness)+"px";gyroscope_ver_ellipsis.style.marginLeft=-(gyroscope_ellipses_little_axis/2+style.gyroscopeThickness)+"px";button.appendChild(gyroscope_ver_ellipsis);psv.addAction("device-orientation",toggleActive);break;case"virtual-reality":var vr_width=style.buttonsHeight*style.virtualRealityRatio;var vr_eye_diameter=vr_width/4;var vr_eye_offset=vr_eye_diameter/2;button=document.createElement("div");button.style.cssFloat="right";button.style.position="relative";button.style.boxSizing="inherit";button.style.padding="10px";button.style.width=vr_width+"px";button.style.height=style.buttonsHeight+"px";button.style.backgroundColor=style.buttonsBackgroundColor;button.style.cursor="pointer";addEvent(button,"click",function(){psv.toggleStereo()});var vr_rect=document.createElement("div");vr_rect.style.boxSizing="inherit";vr_rect.style.width=vr_width+"px";vr_rect.style.height=style.buttonsHeight+"px";vr_rect.style.borderRadius=style.virtualRealityBorderRadius+"px";vr_rect.style.backgroundColor=style.buttonsColor;button.appendChild(vr_rect);var left_eye=document.createElement("div");left_eye.style.boxSizing="inherit";left_eye.style.width=vr_eye_diameter+"px";left_eye.style.height=vr_eye_diameter+"px";left_eye.style.position="absolute";left_eye.style.top=vr_eye_offset+10+"px";left_eye.style.left=vr_eye_offset+10+"px";left_eye.style.borderRadius="50%";left_eye.style.backgroundColor=style.backgroundColor;button.appendChild(left_eye);var right_eye=document.createElement("div");right_eye.style.boxSizing="inherit";right_eye.style.width=vr_eye_diameter+"px";right_eye.style.height=vr_eye_diameter+"px";right_eye.style.position="absolute";right_eye.style.top=vr_eye_offset+10+"px";right_eye.style.right=vr_eye_offset+10+"px";right_eye.style.borderRadius="50%";right_eye.style.backgroundColor=style.backgroundColor;button.appendChild(right_eye);var nose=document.createElement("div");nose.style.boxSizing="inherit";nose.style.width=vr_eye_diameter+"px";nose.style.height=style.buttonsHeight/2+"px";nose.style.position="absolute";nose.style.left="50%";nose.style.bottom="10px";nose.style.marginLeft=-(vr_eye_diameter/2)+"px";nose.style.borderTopLeftRadius="50% 60%";nose.style.borderTopRightRadius="50% 60%";nose.style.backgroundColor=style.backgroundColor;button.appendChild(nose);psv.addAction("stereo-effect",toggleActive);break}};this.getButton=function(){return button};var toggleActive=function(active){if(active)button.style.backgroundColor=style.activeButtonsBackgroundColor;else button.style.backgroundColor=style.buttonsBackgroundColor};var moveZoomValue=function(level){zoom_value.style.left=level/100*style.zoomRangeWidth-style.zoomRangeDisk/2+"px"};var initZoomChangeWithMouse=function(evt){initZoomChange(parseInt(evt.clientX))};var initZoomChangeByTouch=function(evt){var touch=evt.touches[0];if(touch.target==zoom_range_bg||touch.target==zoom_range||touch.target==zoom_value)initZoomChange(parseInt(touch.clientX))};var initZoomChange=function(x){mousedown=true;changeZoom(x)};var stopZoomChange=function(evt){mousedown=false};var changeZoomWithMouse=function(evt){evt.preventDefault();changeZoom(parseInt(evt.clientX))};var changeZoomByTouch=function(evt){var touch=evt.touches[0];if(touch.target==zoom_range_bg||touch.target==zoom_range||touch.target==zoom_value){evt.preventDefault();changeZoom(parseInt(touch.clientX))}};var changeZoom=function(x){if(mousedown){var user_input=x-zoom_range.getBoundingClientRect().left;var zoom_level=user_input/style.zoomRangeWidth*100;psv.zoom(zoom_level)}};var changeZoomOnMouseWheel=function(evt){psv.mouseWheel(evt)};var zoom_range_bg,zoom_range,zoom_value;var mousedown=false;var button;create()};var Sphoords=function(){var detectBrowserEngine=function(){var ua=navigator.userAgent;if(/Gecko\/[0-9.]+/.test(ua))return"Gecko";if(/Chrome\/[0-9.]+/.test(ua))return"Blink";if(/AppleWebKit\/[0-9.]+/.test(ua))return"WebKit";if(/Trident\/[0-9.]+/.test(ua))return"Trident";if(/Opera\/[0-9.]+/.test(ua))return"Presto";return"Gecko"};var getPrincipalAngle=function(angle){return angle-Math.floor(angle/360)*360};this.start=function(){if(Sphoords.isDeviceOrientationSupported){window.addEventListener("deviceorientation",onDeviceOrientation,false);recording=true;return true}else{console.log("Device Orientation API not supported");return false}};this.stop=function(){if(recording){window.removeEventListener("deviceorientation",onDeviceOrientation,false);recording=false}};this.toggle=function(){if(recording)this.stop();else this.start()};this.isEventAttached=function(){return recording};var onDeviceOrientation=function(evt){orientation=Sphoords.getScreenOrientation();var theta=0,phi=0;switch(orientation){case"portrait-primary":theta=evt.alpha+evt.gamma;phi=evt.beta-90;break;case"landscape-primary":theta=evt.alpha+evt.beta-90;phi=-evt.gamma-90;if(Math.abs(evt.beta)>90){switch(engine){case"Blink":phi+=180;break;case"Gecko":default:phi=-phi;break}}if(engine==="WebKit"&&!!window.orientation){if(phi<0){phi=(phi+180)*-1}if(theta>=180){theta=theta-180}else{theta=theta+180}}break;case"landscape-secondary":theta=evt.alpha-evt.beta+90;phi=evt.gamma-90;if(Math.abs(evt.beta)>90){switch(engine){case"Blink":phi+=180;break;case"Gecko":default:phi=-phi;break}}if(engine==="WebKit"&&!!window.orientation){if(phi<0){phi=(phi+180)*-1}if(theta>=180){theta=theta-180}else{theta=theta+180}}break;case"portrait-secondary":theta=evt.alpha-evt.gamma;phi=180-(evt.beta-90);phi=270-evt.beta;break}phi=getPrincipalAngle(phi);if(phi>=180)phi-=360;long_deg=getPrincipalAngle(theta);lat_deg=Math.max(-90,Math.min(90,phi));long=long_deg*DEG_TO_RAD;lat=lat_deg*DEG_TO_RAD;executeListeners()};this.getCoordinates=function(){return{longitude:long,latitude:lat}};this.getCoordinatesInDegrees=function(){return{longitude:long_deg,latitude:lat_deg}};this.getScreenOrientation=function(){return orientation};this.addListener=function(f){listeners.push(f)};var executeListeners=function(){if(!!listeners.length){for(var i=0,l=listeners.length;i<l;++i){listeners[i]({longitude:long,latitude:lat})}}};var recording=false;var long_deg=0,lat_deg=0;var long=0,lat=0;var DEG_TO_RAD=Math.PI/180;var orientation=Sphoords.getScreenOrientation();var engine=detectBrowserEngine();var listeners=[]};Sphoords.getScreenOrientation=function(){var screen_orientation=null;if(!!screen.orientation)screen_orientation=screen.orientation;else if(!!screen.mozOrientation)screen_orientation=screen.mozOrientation;else if(!!screen.msOrientation)screen_orientation=screen.msOrientation;else if(!!window.orientation||window.orientation===0)switch(window.orientation){case 0:screen_orientation="portrait-primary";break;case 180:screen_orientation="portrait-secondary";break;case-90:screen_orientation="landscape-primary";break;case 90:screen_orientation="landscape-secondary";break}return screen_orientation!==null&&typeof screen_orientation=="object"?screen_orientation.type:screen_orientation};Sphoords.isDeviceOrientationSupported=false;(function(){if(!!window.DeviceOrientationEvent&&Sphoords.getScreenOrientation()!==null){function testDeviceOrientation(evt){if(evt!==null&&evt.alpha!==null){Sphoords.isDeviceOrientationSupported=true;window.removeEventListener("deviceorientation",testDeviceOrientation)}}window.addEventListener("deviceorientation",testDeviceOrientation)}})();