<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once "../src/ellipticcurve.php";

//~ exec('openssl dgst -sha256 -sign privateKey.pem -out signatureDer.txt message.txt');

//~ $publicKeyPem = EllipticCurve\Utils\File::read("publicKey.pem");
//~ $signatureDer = EllipticCurve\Utils\File::read("signatureDer.txt");
//~ $message = EllipticCurve\Utils\File::read("message.txt");

//~ $publicKey = EllipticCurve\PublicKey::fromPem($publicKeyPem);
//~ $signature = EllipticCurve\Signature::fromDer($signatureDer);
//~ echo "\n" . $signature->toBase64();

//~ echo "\n" . EllipticCurve\Ecdsa::verify($message, $signature, $publicKey);

$privateKey = EllipticCurve\PrivateKey::fromPem("
    -----BEGIN EC PRIVATE KEY-----
MHcCAQEEIBOPyNrQXSWoqLvJQ1siPdsK2B7MCc8SBW23SFfdi+3WoAoGCCqGSM49
AwEHoUQDQgAEWed35bE0UZ5tdCpNWF3aZx8KMaxb11XS6G7RvrToRQd9RQ4t98/g
o78GoFEogSZ1wt8mzwjni1J3jymIIiU7Jw==
-----END EC PRIVATE KEY-----
");


# Create message from json
$message = array(
    "transfers" => array(
        array(
            "amount" => 100000000,
            "taxId" => "594.739.480-42",
            "name" => "Daenerys Targaryen Stormborn",
            "bankCode" => "341",
            "branchCode" => "2201",
            "accountNumber" => "76543-8",
            "tags" => array("daenerys", "targaryen", "transfer-1-external-id")
        )
    )
);

$message = json_encode($message, JSON_PRETTY_PRINT);

$signature = EllipticCurve\Ecdsa::sign($message, $privateKey);

# Generate Signature in base64. This result can be sent to Stark Bank in header as Digital-Signature parameter
echo "\n" . $signature->toBase64();

# To double check if message matches the signature
$publicKey = $privateKey->publicKey();

$message1 = array(
    "transfers" => array(
        array(
            "amounts" => 10000000,
            "taxId" => "594.739.480-42",
            "name" => "Daenerys Targaryen Stormborn",
            "bankCode" => "341",
            "branchCode" => "2201",
            "accountNumber" => "76543-8",
            "tags" => array("daenerys", "targaryen", "transfer-1-external-ids")
        )
    )
);
$message1 = json_encode($message1, JSON_PRETTY_PRINT);


echo "\n" . EllipticCurve\Ecdsa::verify($message, $signature, $publicKey);
