<html>
  <head>
    <title>Multiple Waterfall Ads</title>
    <!-- <script src="https://cdn.radiantmediatechs.com/rmp/6.4.11/js/rmp.min.js"></script> -->
	    <!-- <script type="text/javascript" src="https://tv.cinemaxxl.de/radiantmediaplayer_new/js/rmp.min.js"></script> -->
	    <script type="text/javascript" src="https://cdn.radiantmediatechs.com/rmp/6.4.11/js/rmp.min.js"></script>
  </head>
  <style type="text/css">
        html, body{width: 100%; height:100%;}
        /* Video Overlay */
        #rmpMessageContainer, #gameMessageContainer {
            display: none;
            position: absolute;
            z-index: 10000000000;
            width: 100%; height: 100%; top: 0; left: 0;
        }

        .rmpMessageContainerBG, .gameMessageContainerBG {
            background-color: white;
            opacity: 0.8;
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 10000000001;
        }

        .rmpMessageContainerMessage, .gameMessageContainerMessage {
            position: absolute;
            top: 50%;
            margin-top: -50px;
            left: 0;
            width: 100%;
            height: 100px;
            line-height: 100px;
            text-align: center;
            font-size: 30px;
            color: #1E83E1;
            z-index: 10000000002;
        }

        @media (max-width: 768px) {
            .rmpMessageContainerMessage {line-height: 20px;}
        }
    </style>
  <body>
    
<!-- Player container element -->
  <div id="rmpPlayer">
    
  </div>    
  </body>
</html>
<script>


  // 'use strict';

  // our waterfall array 
  // each time a consecutive preroll is requested the player 
  // will try each item of the array until one adTag is filled (or none is available)
  var waterfall = [
    'https://demo.reviveadservermod.com/revive_vastmediation/www/delivery/midrollads.xml',
    'https://dev.djaxbidder.com/viamedia/fc.php?script=rmVideo&zoneid=12&format=vast3',
    'https://www.radiantmediaplayer.com/vast/tags/inline-linear-2.xml',
    'https://demo.reviveadservermod.com/advanced_vast/fc.php?script=rmVideo&zoneid=48&format=vast4',
    'https://dev.djaxbidder.com/demo_advancedvast/fc.php?script=rmVideo&zoneid=25&format=vast2'
  ];

  // here we define the number of wanted prerolls
  var wantedPreroll = 3;

  // debug console logs
  var enableLogs = true;
  // debug console logs
  var debugLog = false;
  if (enableLogs && window.console && window.console.log) {
    debugLog = true;
  }
  var _log = function (data) {
    if (debugLog && data) {
      window.console.log(data);
    }
  };


  // var shuffle array upon an adTag being filled
  var shuffleWaterfallUponFill = true;
  // taken from https://stackoverflow.com/questions/2450954/how-to-randomize-shuffle-a-javascript-array
  var shuffleArray = function (array) {
    var currentIndex = array.length, temporaryValue, randomIndex;
    // While there remain elements to shuffle...
    while (0 !== currentIndex) {
      // Pick a remaining element...
      randomIndex = Math.floor(Math.random() * currentIndex);
      currentIndex -= 1;
      // And swap it with the current element.
      temporaryValue = array[currentIndex];
      array[currentIndex] = array[randomIndex];
      array[randomIndex] = temporaryValue;
    }
    return array;
  };

  // Then we set our player settings
  var src = {
    mp4: 'https://demo.reviveadservermod.com/TitanClocks.mp4'
  };
  var settings = {
    licenseKey: 'Kl8lbz16cz1rN2l2enM9Z2M9NnZvMnllaT9yb201ZGFzaXMzMGRiMEElXyo=',
    src: src,
    delayToFade: 3000,
    width: 640,
    height: 360,
    ads: true,
    autoplay: true,
    muted: true,
    adCountDown: true,
    adVpaidMode: 'enabled',
    //adParser: 'rmp-vast',
    adTagUrl: waterfall[0],
    iframeMode: true,
	sharing: false,
    contentMetadata: {
      poster: ['http://13.234.135.218/468x60-05739dde33af56ed1262d6c672dabbeb.jpg']
    },
    initialVolume: 1,
	hasGa: true,
	skin: 's4',
	pathToRmpFiles: 'radiantmediaplayer/'
  };

  var elementId = 'rmpPlayer';
  var rmpContainer = document.getElementById(elementId);
  var rmp = new RadiantMP(elementId);

  var adstarted = 0;
  var waterfallIndex = 0;
  var onAdFinished = null;
  var onAdError = null;
  var onAdStarted = null;

  // this function is called when the ad-cycle has completed and content is about to resume
  var unWireEvents = function () {
    _log('unWireEvents');
    rmpContainer.removeEventListener('adcontentresumerequested', onAdFinished);
    rmpContainer.removeEventListener('addestroyed', onAdFinished);
    rmpContainer.removeEventListener('aderror', onAdError);
    rmpContainer.removeEventListener('adstarted', onAdStarted);
  };

  onAdFinished = function (e) {
    if (e && e.type) {
      _log(e.type);
    }
    if (adstarted < wantedPreroll && waterfall[waterfallIndex]) {
      rmp.pause();
      rmp.loadAds(waterfall[waterfallIndex]);
    } else {
      unWireEvents();
    }
  };

  onAdStarted = function () {
    _log('successfully loaded tag at: ' + waterfall[waterfallIndex]);
    waterfallIndex = 0;
    adstarted++;
    if (shuffleWaterfallUponFill) {
      waterfall = shuffleArray(waterfall);
      _log('shuffleWaterfallUponFill new array is: ' + waterfall.toString());
    }
    _log('adstarted: ' + adstarted);
  };

  onAdError = function () {
    waterfallIndex++;
    _log('waterfallIndex: ' + waterfallIndex);
  };

  // when player is ready we wire our app logic
  var onReadyWireEvents = function () {
    _log('ready - wire API events');
    rmpContainer.removeEventListener('ready', onReadyWireEvents);

    // we need to determine when we can start loading the next ad in waterfall array
    // for Google IMA 
    rmpContainer.addEventListener('adcontentresumerequested', onAdFinished);
    // for rmp-vast
    rmpContainer.addEventListener('addestroyed', onAdFinished);

    // aderror and adstarted are available with IMA and rmp-vast
    // on aderror we tick waterfallIndex
    rmpContainer.addEventListener('aderror', onAdError);
    // on adstarted === we got a fill, we reset waterfallIndex
    rmpContainer.addEventListener('adstarted', onAdStarted);
  };

  // when ready wire event handlers
  rmpContainer.addEventListener('ready', onReadyWireEvents);

  // init player
  rmp.init(settings);
</script>