<?php
    header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");
    header("Access-Control-Allow-Methods: POST");
    header("Access-Control-Max-Age: 3600");
    header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

      
    ## Required files
    require_once '../../../../init.php';
    require_once MAX_PATH . '/lib/OA/Dal.php';      
    require_once MAX_PATH . '/lib/OA/Admin/Option.php';
    require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
    require_once MAX_PATH . '/www/admin/config.php';
    require_once MAX_PATH . '/lib/max/Plugin/Translation.php';


    ## DB
    if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
        require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
    }else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
        require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
    }else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
        require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
    }

     
    ## INITIALISATIN
    $condition = '';
    $getQuery = '';
    $limit = "";
    $id = "";
    $groupby = "";
    $data_type1 = "";
    //$data_type = " adh.country AS data_type1 ";

    $total_record = 0;


    ## REQUIRED POST VALIES
    $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
    $start_date = $_POST['start_date'];
    $end_date = $_POST['end_date'];
    $line_dimension = $_POST['line_dimension'];
    $rowperpage = $_POST['length']; // Rows display per page
   
    $columnIndex = $_POST['order'][0]['column']; // Column index
    $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
    $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
    $searchValue = $_POST['search']['value']; // Search value
    $period_preset=$_POST['period_preset'];
   
  
    if( $period_preset==1 || $period_preset==2 || $period_preset==6 || $period_preset==7)
    {
		$month = (int)date('m', strtotime($start_date));
		$month=($month==12)?0:$month;
	    $partition="partition (p{$month})";	
			
		
	}
	else if($period_preset==3 || $period_preset==4 || $period_preset==5)
	{
		$start_month = (int)date('m', strtotime($start_date));
		$start_month=($month==12)?0:$month;
		
		$end_month = (int)date('m', strtotime($end_date));
		$end_month=($month==12)?0:$month;
		if($start_month==$end_month )
		{
			$month = (int)date('m', strtotime($start_date));
			$partition="partition (p{$month})";	
		}
		else
		{
			$partition="partition (p{$start_month}),(p{$end_month})";	
		}
	}
	else
	{
		$partition='';
	}
    $condition1 = '';
    $groupby1 = '';

   ## ACCOUNT TYPE
   if(isset($_POST['id']) && !empty($_POST['id'])) {
      $id = explode('=', $_POST['id']);
   }

   if(isset($id[0]) && $id[0] == 'clientid'){
      $condition = 'AND cl.clientid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'pubid'){
      $condition = 'AND a.affiliateid='.$id[1];
   }elseif(isset($id[0]) && $id[0] == 'manager'){
      $condition = 'AND cl.agencyid='.$id[1];
   }

   
    ## RECORD COUNT
    if ($rowperpage == -1) {
        $limit = "";    ## ALL RECORDS
    }else{
        $limit = "limit ".$_POST['start'].",".$_POST['length']; ## LIMITTED RECORDS
    }

    ## LINE DIMENSION
 
    if(!$line_dimension[0]) {
      
     //   $groupby = " GROUP BY adh.country ,";
       // $table_name="statistics_geo";
        $line_dimension=1;

    }else{
      
      $groupby = " GROUP BY adh.country, ";
      
      //$data_type = ',';
      $length  = sizeof($line_dimension);
      $i = 0;
      $j = 1;
         $table_name="statistics_geo";
        foreach ($line_dimension as $key) {
          
          // exit;
            if($key == 1 ){

                $groupby .= "adh.country ";
                $data_type .= " adh.country AS data_type1";
               // $table_name="statistics_geo";
                $data_type .= ',';

            }
            else if($key == 2){

                $groupby .= "adh.region ";
                $data_type .= " adh.region AS data_type2";
               // $table_name="statistics_region";
                $data_type .= ',';

            } 
            else if($key == 3 ){

                $groupby .= "adh.city ";
                $data_type .= " adh.city AS data_type3";
                //$table_name="statistics_city";
			$data_type .= ',';
            }else if($key == 4){

                $groupby .= "cl.clientid ";
                $data_type .= " cl.clientname AS data_type4";
			$data_type .= ',';
            }else if($key == 5){

                $groupby .= "c.campaignid ";
                $data_type .= " c.campaignname AS data_type5";
			$data_type .= ',';
            }else if($key == 6){

                $groupby .= "b.bannerid ";
                $data_type .= " b.description AS data_type6";
			$data_type .= ',';
            }else if($key == 7){

                $groupby .= "p.id ";
                $data_type .= " p.name AS data_type7";
			$data_type .= ',';
            }else if($key == 8){
              
                
                $groupby .= "a.affiliateid ";
                $data_type .= " a.name AS data_type8";
			$data_type .= ',';
			 $extra_joins .= " LEFT JOIN {$table_prefix}zones zo ON zo.zoneid = adh.zone_id  LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = zo.affiliateid";
            }else if($key == 9){

                $groupby .= "z.zonename ";
                $data_type .= " z.zonename AS data_type9";
                $data_type .= ',';
                $extra_joins .= " LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id";

            }
			if($j <=$length-1){
             $groupby .= ',';
             
		}
		$j++;
            }
            $i++;
            $groupby .= null;
            $data_type1 .= "data_type".$key;
            if($i < $length){
              //  $groupby .= ',';
                $final_group .= ',';
              // $data_type .= ',';
                $data_type1 .= ',';
            }
        
    }

    if($start_date)
    {
        $start =  date('Y-m-d 00:00:00',strtotime($start_date));    
        $start_day=new Date($start);
        $start_day->toUTC();
        $start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
    }
    
    if($end_date)
    {
        $end =  date('Y-m-d 23:59:59',strtotime($end_date));    
        $end_day=new Date($end);
        $end_day->toUTC();
        $end_date=$end_day->format('%Y-%m-%d %H:%M:%S'); 
    }
  
  
  $table_name="stats_country";
  $partition="";
  
   
    if( in_array(1, $line_dimension , TRUE))
    {
		//  print_r("SELECT COUNT(adh.impressions)  as count   FROM {$table_prefix}{$table_name} {$partition} adh    WHERE  DATE(adh.date_time) >= '".$start_date."' AND DATE(adh.date_time) <= '". $end_date."' ".$groupby);
	// exit; 
        $total_record = OA_Dal_Delivery_Query("SELECT COUNT(adh.impressions)  as count   FROM {$table_prefix}{$table_name} {$partition} adh    WHERE  DATE(adh.date_time) >= '".$start_date."' AND DATE(adh.date_time) <= '". $end_date."' ".$groupby);  
      
    } 
    else
    {
   // print_r("SELECT COUNT(adh.impressions)  as count   FROM {$table_prefix}{$table_name} {$partition} adh  LEFT JOIN   {$table_prefix}banners b ON b.bannerid = adh.creative_id LEFT JOIN {$table_prefix}campaigns c ON  c.campaignid = b.campaignid LEFT JOIN {$table_prefix}clients cl ON cl.clientid = c.clientid   ".$extra_joins."  WHERE  DATE(adh.date_time) >= '".$start_date."' AND DATE(adh.date_time) <= '". $end_date."' ".$condition." ".$groupby);
  //  exit;
        $total_record = OA_Dal_Delivery_Query("SELECT COUNT(adh.impressions)  as count   FROM {$table_prefix}{$table_name} {$partition} adh  LEFT JOIN   {$table_prefix}banners b ON b.bannerid = adh.creative_id LEFT JOIN {$table_prefix}campaigns c ON  c.campaignid = b.campaignid LEFT JOIN {$table_prefix}clients cl ON cl.clientid = c.clientid   ".$extra_joins."  WHERE  DATE(adh.date_time) >= '".$start_date."' AND DATE(adh.date_time) <= '". $end_date."' ".$condition." ".$groupby);   
        
    }
        
    $total_record = OA_Dal_Delivery_numRows($total_record);
	
	 
     $getQuery = "SELECT {$data_type} adh.country as data_type1,  c.revenue_type, c.revenue, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, c.revenue as revenue,c.revenue_type  
    FROM {$table_prefix}{$table_name} {$partition} adh  
    LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id
    LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid
    LEFT JOIN   {$table_prefix}banners b ON b.bannerid = adh.creative_id LEFT JOIN {$table_prefix}campaigns c ON  c.campaignid = b.campaignid LEFT JOIN {$table_prefix}clients cl ON cl.clientid = c.clientid  WHERE  DATE(adh.date_time) >= '".$start_date."' AND DATE(adh.date_time) <= '". $end_date."' ".$condition." ".$condition1." ".$groupby." ".$limit;
 


    $data = array();
    $getQuery = OA_Dal_Delivery_Query($getQuery);

    $country_array = array( "AF" => "Afghanistan","AL" => "Albania","DZ" => "Algeria","AS" => "American Samoa","AD" => "Andorra","AO" => "Angola","AI" => "Anguilla","AQ" => "Antarctica","AG" => "Antigua and Barbuda","AR" => "Argentina","AM" => "Armenia","AW" => "Aruba","AU" => "Australia","AT" => "Austria", "AZ" => "Azerbaijan","BS" => "Bahamas","BH" => "Bahrain","BD" => "Bangladesh","BB" => "Barbados","BY" => "Belarus","BE" => "Belgium","BZ" => "Belize","BJ" => "Benin","BM" => "Bermuda","BT" => "Bhutan","BO" => "Bolivia","BA" => "Bosnia and Herzegovina","BW" => "Botswana", "BV" => "Bouvet Island","BR" => "Brazil","BQ" => "British Antarctic Territory","IO" => "British Indian Ocean Territory","VG" => "British Virgin Islands","BN" => "Brunei","BG" => "Bulgaria","BF" => "Burkina Faso","BI" => "Burundi","KH" => "Cambodia","CM" => "Cameroon","CA" => "Canada", "CT" => "Canton and Enderbury Islands","CV" => "Cape Verde","KY" => "Cayman Islands","CF" => "Central African Republic","TD" => "Chad","CL" => "Chile","CN" => "China","CX" => "Christmas Island","CC" => "Cocos [Keeling] Islands","CO" => "Colombia","KM" => "Comoros", "CG" => "Congo - Brazzaville","CD" => "Congo - Kinshasa","CK" => "Cook Islands","CR" => "Costa Rica","HR" => "Croatia","CU" => "Cuba","CY" => "Cyprus","CZ" => "Czech Republic","CI" => "Côte d’Ivoire","DK" => "Denmark","DJ" => "Djibouti","DM" => "Dominica","DO" => "Dominican Republic","NQ" => "Dronning Maud Land", "DD" => "East Germany","EC" => "Ecuador","EG" => "Egypt","SV" => "El Salvador","GQ" => "Equatorial Guinea","ER" => "Eritrea","EE" => "Estonia","ET" => "Ethiopia","FK" => "Falkland Islands","FO" => "Faroe Islands","FJ" => "Fiji","FI" => "Finland", "FR" => "France","GF" => "French Guiana","PF" => "French Polynesia","TF" => "French Southern Territories","FQ" => "French Southern and Antarctic Territories","GA" => "Gabon","GM" => "Gambia","GE" => "Georgia","DE" => "Germany","GH" => "Ghana","GI" => "Gibraltar","GR" => "Greece","GL" => "Greenland", "GD" => "Grenada","GP" => "Guadeloupe","GU" => "Guam","GT" => "Guatemala","GG" => "Guernsey","GN" => "Guinea","GW" => "Guinea-Bissau","GY" => "Guyana","HT" => "Haiti","HM" => "Heard Island and McDonald Islands","HN" => "Honduras","HK" => "Hong Kong SAR China", "HU" => "Hungary","IS" => "Iceland","IN" => "India","ID" => "Indonesia","IR" => "Iran","IQ" => "Iraq","IE" => "Ireland","IM" => "Isle of Man","IL" => "Israel","IT" => "Italy","JM" => "Jamaica","JP" => "Japan","JE" => "Jersey","JT" => "Johnston Island", "JO" => "Jordan","KZ" => "Kazakhstan","KE" => "Kenya","KI" => "Kiribati","KW" => "Kuwait","KG" => "Kyrgyzstan","LA" => "Laos","LV" => "Latvia", "LB" => "Lebanon","LS" => "Lesotho","LR" => "Liberia","LY" => "Libya","LI" => "Liechtenstein","LT" => "Lithuania","LU" => "Luxembourg", "MO" => "Macau SAR China","MK" => "Macedonia","MG" => "Madagascar","MW" => "Malawi","MY" => "Malaysia","MV" => "Maldives","ML" => "Mali","MT" => "Malta","MH" => "Marshall Islands","MQ" => "Martinique","MR" => "Mauritania","MU" => "Mauritius","YT" => "Mayotte","FX" => "Metropolitan France", "MX" => "Mexico","FM" => "Micronesia","MI" => "Midway Islands","MD" => "Moldova","MC" => "Monaco","MN" => "Mongolia","ME" => "Montenegro", "MS" => "Montserrat","MA" => "Morocco","MZ" => "Mozambique","MM" => "Myanmar [Burma]","NA" => "Namibia","NR" => "Nauru","NP" => "Nepal","NL" => "Netherlands","AN" => "Netherlands Antilles","NT" => "Neutral Zone","NC" => "New Caledonia","NZ" => "New Zealand", "NI" => "Nicaragua","NE" => "Niger","NG" => "Nigeria","NU" => "Niue","NF" => "Norfolk Island","KP" => "North Korea","VD" => "North Vietnam","MP" => "Northern Mariana Islands","NO" => "Norway","OM" => "Oman", "PC" => "Pacific Islands Trust Territory","PK" => "Pakistan","PW" => "Palau","PS" => "Palestinian Territories","PA" => "Panama","PZ" => "Panama Canal Zone", "PG" => "Papua New Guinea","PY" => "Paraguay","YD" => "People's Democratic Republic of Yemen","PE" => "Peru","PH" => "Philippines", "PN" => "Pitcairn Islands","PL" => "Poland","PT" => "Portugal","PR" => "Puerto Rico","QA" => "Qatar","RO" => "Romania","RU" => "Russia", "RW" => "Rwanda","RE" => "Réunion","BL" => "Saint Barthélemy","SH" => "Saint Helena","KN" => "Saint Kitts and Nevis","LC" => "Saint Lucia", "MF" => "Saint Martin","PM" => "Saint Pierre and Miquelon","VC" => "Saint Vincent and the Grenadines","WS" => "Samoa","SM" => "San Marino", "SA" => "Saudi Arabia","SN" => "Senegal","RS" => "Serbia","CS" => "Serbia and Montenegro","SC" => "Seychelles","SL" => "Sierra Leone", "SG" => "Singapore","SK" => "Slovakia","SI" => "Slovenia","SB" => "Solomon Islands","SO" => "Somalia","ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands","KR" => "South Korea","ES" => "Spain","LK" => "Sri Lanka","SD" => "Sudan", "SR" => "Suriname","SJ" => "Svalbard and Jan Mayen","SZ" => "Swaziland","SE" => "Sweden","CH" => "Switzerland","SY" => "Syria", "ST" => "São Tomé and Príncipe","TW" => "Taiwan","TJ" => "Tajikistan","TZ" => "Tanzania","TH" => "Thailand","TL" => "Timor-Leste", "TG" => "Togo","TK" => "Tokelau","TO" => "Tonga","TT" => "Trinidad and Tobago","TN" => "Tunisia","TR" => "Turkey", "TM" => "Turkmenistan","TC" => "Turks and Caicos Islands","TV" => "Tuvalu","UM" => "U.S. Minor Outlying Islands","PU" => "U.S. Miscellaneous Pacific Islands", "VI" => "U.S. Virgin Islands","UG" => "Uganda","UA" => "Ukraine","SU" => "Union of Soviet Socialist Republics","AE" => "United Arab Emirates", "GB" => "United Kingdom","US" => "United States","ZZ" => "Unknown or Invalid Region","UY" => "Uruguay","UZ" => "Uzbekistan","VU" => "Vanuatu", "VA" => "Vatican City","VE" => "Venezuela","VN" => "Vietnam","WK" => "Wake Island","WF" => "Wallis and Futuna","EH" => "Western Sahara", "YE" => "Yemen","ZM" => "Zambia","ZW" => "Zimbabwe","AX" => "Åland Islands" );

    if (isset($getQuery) && !empty($getQuery)) {

        while ($row = OA_Dal_Delivery_fetchAssoc($getQuery)) {

            $pub_income = 0;
            $total_revenue = 0;

            if($row['revenue_type'] == 1){
                    
                $pub_income = $row['impressions'] * $row['pub_cpm'] / 1000;
                $total_revenue = $row['impressions'] * $row['revenue'] / 1000;

            } else if($row['revenue_type'] == 2){

                $pub_income = $row['clicks'] * $row['pub_cpm'];
                $total_revenue = $row['clicks'] * $row['revenue'];

            } else if($row['revenue_type'] == 3){

                $pub_income = $row['conversions'] * $row['pub_cpm'];
                $total_revenue = $row['conversions'] * $row['revenue'];
            }
            
            $row['total_revenue'] = $row['total_revenue'];

            if($row['total_revenue'] == '' || $row['total_revenue'] == 0){
                
                $row['total_revenue'] = $total_revenue;
            }
            
            if($row['data_type2'])
		   {
			   $code=$row['data_type1'].'-'.$row['data_type2'];
			   $region_query = OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_Query("select subdivision_name as region from rv_region where country_code='".$row['data_type1']."' AND code='".$code."'"));
			    $row['data_type2']=$region_query['region'];
			  
			  
		   }

           if( $row['data_type1']!="-")
           {
			   $row['data_type1'] = $country_array[$row['data_type1']];
		   }
		   else
		   {
			   $row['data_type1'] ="Others";
		   }
		   
            
            $data[] = array(

                "data_type1"=>($row['data_type1'] ? $row['data_type1'] : '-'),
                "data_type2"=>($row['data_type2']) ? $row['data_type2'] : '-',
                "data_type3"=>($row['data_type3']) ? $row['data_type3'] : '-',
                "data_type4"=>($row['data_type4']) ? $row['data_type4'] : '-',
                "data_type5"=>($row['data_type5']) ? $row['data_type5'] : '-',
                "data_type6"=>($row['data_type6']) ? $row['data_type6'] : '-',
                "data_type7"=>($row['data_type7']) ? $row['data_type7'] : '-',
                "data_type8"=>($row['data_type8']) ? $row['data_type8'] : '-',
                "data_type9"=>($row['data_type9']) ? $row['data_type9'] : '-',
                "data_type10"=>($row['data_type10']) ? $row['data_type10'] : '-',
                "data_type11"=>($row['data_type11']) ? $row['data_type11'] : '-',
                "data_type12"=>($row['data_type12']) ? $row['data_type12'] : '-',
                "data_type13"=>($row['data_type13']) ? $row['data_type13'] : '-',

                "request"=>$row['requests'],
                "impressions"=> ($row['impressions']) ? $row['impressions'] : 0,
               
                "passback"=> ($row['passback']) ? $row['passback'] : 0 ,
                
                "clicks"=>$row['clicks'],
                "conversions"=>$row['conversions'],

                "ctr" => ($row['impressions'] > 0)? round($row['clicks']/$row['impressions']*100, 2) : 0.00,
                "vctr" => ($row['views'] > 0) ? round($row['clicks']/$row['views'] *100, 2) : 0.00,
                "ecpm" => ($row['impressions'] > 0) ? round(($row['total_revenue'] / $row['impressions']) * 1000, 2) : 0.00,
                "vecpm" => ($row['views'] > 0) ? round(($row['total_revenue'] / $row['views']) * 1000, 2) : 0.00,
                "pub_income" => $pub_income,
                "total_revenue" => ($total_revenue > 0)? $total_revenue : 0.00,
                "ad_fill" => ($row['requests'] > 0) ? round(($row['impressions'] / $row['requests'] ) * 100, 2):0,
           );
        }
    }
    
    ## Response
    $response = array(
      "draw" => intval($draw),
      "iTotalRecords" => $total_record,
      "iTotalDisplayRecords" => $total_record,
      "aaData" => $data
    );

    echo json_encode($response);
    exit();
?> 
        
