package djregs_target

import (
	"djextrafunc"
	"djgetad"
	"djlogger"
	openrtb3 "openrtb/openrtb3"
	"reflect"
	"strconv"
	"strings"

	openrtb "openrtb/openrtb2.5"
)

type Command struct {
	Name string
	Args []string
}

type Commander struct{}

var (
	regsobj   *openrtb3.Regulations
	regsobj25 *openrtb.Regulations
)

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "-", "", count), "-")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for checking overall regs targeting criteria
func CheckRegsCriteria(regsChannel chan []djgetad.GetAd, regs *openrtb3.Regulations, regs25 *openrtb.Regulations, ads []djgetad.GetAd) {
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			regsChannel <- filterads
		}
	}()
	if regs != nil {
		regsobj = regs
	} else if regs25 != nil {
		regsobj25 = regs25
	}
	
			validate_campaign := make(map[int]int)

	for _, ad := range ads {
		
		
				if validate_campaign[ad.Placement_id] == 1 {
			
			filterads = append(filterads, ad)
			continue
		}
		
		if validate_campaign[ad.Placement_id] == 2 {
			continue
		} 
		
		validate_campaign[ad.Placement_id] = 2 // by default not match 
		
		
		var ex bool
		var funcarr []string
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			s := strings.Split(ad.Compiledlimitation, " and ")
			for _, element := range s {
				if element != "" {
					for _, e := range strings.Split(element, " or ") {
						if e != "" {
							funcarr = append(funcarr, e)
						}
					}
				}
			}
			for _, funcName := range funcarr {
				if funcName != "" {
					command := StringCommandParser(funcName)
					c := &Commander{}
					f := reflect.ValueOf(c).MethodByName(command.Name)
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fu := f.Call(inputs)
						if fu[0].Interface().(bool) == false {
							ex = false
							break
						} else {
							ex = true
						}
					} else {
						ex = true
					}
				}
			}
			if ex != false {
				filterads = append(filterads, ad)
												validate_campaign[ad.Placement_id] = 1 // match

			}
		} else {
			filterads = append(filterads, ad)
											validate_campaign[ad.Placement_id] = 1 // match

		}
	}
	regsChannel <- filterads
}

/* -----------------------------------------------------------------------------------
					Regs Targetting Start(06-04-20)
--------------------------------------------------------------------------------------*/

// Coppa start
func (c Commander) MAX_checkClient_Regcoppa(cmd Command) bool {
	var reqCoppa int
	var argCoppa []int
	if regsobj != nil {
		reqCoppa = regsobj.Coppa
	} else if regsobj25 != nil {
		reqCoppa = regsobj25.Coppa
	}
	for _, val := range strings.Split(cmd.Args[0], ",") {
		ac, _ := strconv.Atoi(strings.ToLower(strings.Replace(val, "'", "", -1)))
		argCoppa = append(argCoppa, ac)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if op == "=~" || op == "==" {
		return djextrafunc.In_array(reqCoppa, argCoppa)
	} else if op == "!=" || op == "!~" {
		return !djextrafunc.In_array(reqCoppa, argCoppa)
	} else {
		return false
	}
}

// Coppa end

/* -----------------------------------------------------------------------------------
					Regs Targetting End(06-04-20)
--------------------------------------------------------------------------------------*/
