// This is the main function where which pass two ref parameters of Parent element & Child element
// export const scrollIntoView = (parent, child, prevChild) => {
//     const parentBounding = parent.getBoundingClientRect(),
//         clientBounding = child.getBoundingClientRect();
//
//     const parentRight = parentBounding.right,
//         parentLeft = parentBounding.left,
//         clientRight = clientBounding.right,
//         clientLeft = clientBounding.left,
//         prevRight = prevChild.right,
//         prevLeft = prevChild.left;
//
//     if (parentRight >= clientRight) {
//         scrollTo(parent, -(parentLeft - clientLeft), 300);
//         scrollTo(parent, -700, 300)
//     } else if (clientRight > parentRight) {
//         scrollTo(parent, 700, 300)
//         // scrollTo(parent, clientRight - parentRight, 300);
//     }
//
// };

export const scrollIntoView = (parent, scrollElements, forward = true) => {
  const parentBounding = parent.getBoundingClientRect();

  const parentRight = parentBounding.right;
  const parentLeft = parentBounding.left;

  console.log(parentLeft, parentRight);
  if (forward) {
    scrollTo(parent, 350 * scrollElements, 300);
  } else {
    scrollTo(parent, -350 * scrollElements, 300);
  }
};

function scrollTo(element, to, duration) {
  var start = element.scrollLeft,
    currentTime = 0,
    increment = 20;

  var animateScroll = function () {
    currentTime += increment;

    var val = easeInOutQuad(currentTime, start, to, duration);
    element.scrollLeft = val;

    if (currentTime < duration) {
      setTimeout(animateScroll, increment);
    }
  };

  animateScroll();
} // Function for smooth scroll animation with the time duration
function easeInOutQuad(time, startPos, endPos, duration) {
  time /= duration / 2;

  if (time < 1) return (endPos / 2) * time * time + startPos;
  time--;
  return (-endPos / 2) * (time * (time - 2) - 1) + startPos;
}
