/**
 * File to hold reusable functions and patterns
 */

export default {
    stateAdd: (state_data, payload) => {
        return [...state_data, ...payload]
    },
    stateDelete: (state_data, index) => {
        return [...state_data.slice(0, index), ...state_data.slice(index + 1)]
    },
    stateUpdate: (state_data, index, update) => {
        return state_data.map((item, item_index) => {
            if (item_index !== index) {
                return item
            }
            // return Object.assign({}, item, update)
            return update
        })
    }
}