import {action, thunk} from 'easy-peasy';
import utils from "./utils";

const model = {
    data: {
        categoryOpen: null,
        isMenuOpen: false,
        isCategoryMenuOpen: false,
        locale: "en",
        videoLoading: true,
        video: null,
        livestream: null,
    },
    setLoading: action((state, payload) => {
        state.data = Object.assign({}, state.data, {
            videoLoading: false,
        })
    }),
    setVideo: action((state, payload) => {
        state.data = Object.assign({}, state.data, {
            videoLoading: false,
            video: payload
        })
    }),
    setLivestream: action((state, payload) => {
        state.data = Object.assign({}, state.data, {
            videoLoading: false,
            livestream: payload
        })
    }),
    setLocale: action((state, payload) => {
        state.data = Object.assign({}, state.data, {
            locale: payload
        })
    }),
    openCategory: action((state, payload) => {
        state.data = Object.assign({}, state.data, {
            categoryOpen: payload,
            isCategoryMenuOpen: true
        })
    }),
    closeCategory: action((state, payload) => {
        state.data = Object.assign({}, state.data, {
            categoryOpen: null,
            isCategoryMenuOpen: false
        })
    }),
    menuOpened: action((state, payload) => {
        state.data = Object.assign({}, state.data, {
            isMenuOpen: true
        })
    }),
    menuClosed: action((state, payload) => {
        state.data = Object.assign({}, state.data, {
            isMenuOpen: false
        })
    }),
    categoryMenuOpened: action((state, payload) => {
        state.data = Object.assign({}, state.data, {
            isCategoryMenuOpen: true
        })
    }),
    categoryMenuClosed: action((state, payload) => {
        state.data = Object.assign({}, state.data, {
            isCategoryMenuOpen: false
        })
    }),

}

export default model;
