//import liraries
import React, { useEffect, useState, useRef, useContext } from "react";

import Video from "../Components/Video";
import Categories from "../Components/Categories";
import CategoryOverlay from "../Components/CategoryOverlay";
import KeyHandler from "../Components/KeyHandler";
import VodIndicator from "../Components/VodIndicator";
import { DashVideo, ImageUrl } from "../../utils";

import { useStoreActions, useStoreState } from "easy-peasy";
import KeyCodes from "../Components/KeyHandler/KeyCodes";

var debug_key_pressed = "";
const Home = () => {
  const [showKey, setShowKey] = useState(false);
  const [firstLoad, setFirstLoad] = useState(true);

  const [categoryStack, setCategoryStack] = useState([]);
  const [categoryItemStack, setCategoryItemStack] = useState([]);
  const categoryRef = useRef(null);

  const platform = useStoreState((state) => state.platform);
  const controller = useStoreState((state) => state.controller);
  const openCategory = useStoreActions(
    (actions) => actions.controller.openCategory
  );
  const closeCategory = useStoreActions(
    (actions) => actions.controller.closeCategory
  );

  const menuOpened = useStoreActions(
    (actions) => actions.controller.menuOpened
  );
  const menuClosed = useStoreActions(
    (actions) => actions.controller.menuClosed
  );
  const categoryMenuOpened = useStoreActions(
    (actions) => actions.controller.categoryMenuOpened
  );
  const categoryMenuClosed = useStoreActions(
    (actions) => actions.controller.categoryMenuClosed
  );

  const setVideoLoading = useStoreActions(
    (actions) => actions.controller.setLoading
  );
  const openVideo = useStoreActions((actions) => actions.controller.setVideo);
  const openVodLivestream = useStoreActions(
    (actions) => actions.controller.setLivestream
  );

  useEffect(() => {
    // console.log("Platform", platform)
    if (platform) {
      setVideoLoading(false);
    }
  }, [platform]);

  // useEffect(() => {
  //     console.log("STACK", categoryItemStack)
  // }, [categoryItemStack])

  const onKeyDown = (keyCode) => {
    // console.log("Key Down", keyCode);
    setShowKey(true);
    debug_key_pressed = keyCode;
    if (
      [
        KeyCodes.VK_BACK,
        KeyCodes.H_BACK,
        KeyCodes.VK_BLUE,
        KeyCodes.H_BLUE,
        8,
      ].includes(keyCode)
    ) {
      if (
        (controller.data.video || controller.data.livestream) &&
        controller.data.categoryOpen === null
      ) {
        // openVideo(null)
        if (categoryStack.length > 0) {
          openCategory(categoryStack[0]);
        } else {
          openVideo(null);
          openVodLivestream(null);
        }
      }
    }

    if ([KeyCodes.VK_YELLOW].includes(keyCode)) {
      try {
        window.oipf_manager.stopApp();
      } catch (e) {
        console.log("Stop APp not found", window.oipf_manager);
      }
    }

    // if([KeyCodes.VK_BLUE, KeyCodes.H_BLUE].includes((keyCode))) {
    //     if (controller.data.video && controller.data.categoryOpen === null) {
    //         openVideo(null)
    //     }
    // }
  };

  return (
    <>
      <Video
        platform={platform.data}
        livestream={!(controller.data.video && controller.data.livestream)}
        video={
          controller.data.video
            ? DashVideo(platform.data, controller.data.video)
            : controller.data.livestream
            ? controller.data.livestream.dash_url
            : platform.livestream
        }
        vodLivestream={!!controller.data.livestream}
        loading={controller.data.videoLoading}
        onLoadEvent={() => {
          if (firstLoad) {
             categoryRef.current.show()
            //setFirstLoad(false);
          }
        }}
      />
      
      <Categories
        ref={categoryRef}
        logo={ImageUrl(platform.data.logo_image)}
        listenToKeys={controller.data.categoryOpen === null}
        openSelected={(selected) => {
          setCategoryStack([platform.categories[selected]]);
          setCategoryItemStack([null]);
          openCategory(selected);
        }}
        onOpen={() => menuOpened()}
        onClose={() => menuClosed()}
        categoryItems={platform.categories}
      />
      <CategoryOverlay
        logo={ImageUrl(platform.data.logo_image)}
        controller={controller}
        category={controller.data?.categoryOpen}
        selectedItem={
          categoryItemStack.length > 0 ? categoryItemStack[0] : null
        }
        vodOpen={controller.data.video}
        categoryDetails={
          categoryStack.length > 0
            ? categoryStack[0]
            : platform.categories[controller.data?.categoryOpen]
        }
        closeOverlay={() => {
          // Handle Back Pressed here
          if (categoryStack.length > 1) {
            openCategory(categoryStack[1]);
            setCategoryStack((oc) => oc.slice(1));
            setCategoryItemStack((oc) => oc.slice(1));
          } else {
            closeCategory();
            setCategoryStack([]);
            setCategoryItemStack([]);

            if (controller.data.video) {
              openVideo(null);
            }

            if (controller.data.livestream) {
              openVodLivestream(null);
            }
          }
        }}
        openLivestream={(l, i) => {
          var found_ls = platform.all_livestreams.find(
            (ls) => ls.id === l.live_stream_id
          );
          closeCategory();
          openVodLivestream(found_ls);
        }}
        openVideo={(v) => {
          closeCategory();
          openVideo(v);
        }}
        openCategory={(c, i) => {
          console.log("OPENING", c, i);
          setCategoryItemStack((oi) => [null, i, ...oi.slice(1)]);
          setCategoryStack((oc) => [c, ...oc]);
          openCategory(i);
        }}
        // onOpen={() => {
        //     console.log("On Category Open")
        //     categoryMenuOpened()
        // }}
        // onClose={() => {
        //     console.log("On Category C;psed")
        //     categoryMenuClosed()
        // }}
      />
      <KeyHandler onKeyDown={onKeyDown} />
      {window.premio_config.key_debug && (
        <div
          className={`key-debugger ${
            showKey ? "key-debugger-show" : "key-debugger-hide"
          }`}
          onTransitionEnd={() => setShowKey(false)}
        >
          <h1>{debug_key_pressed}</h1>
        </div>
      )}


      {!firstLoad && (
        <VodIndicator id="vodindicator"
          inVod={!!controller.data.video || !!controller.data.livestream}
        />
      )}
    </>
  );
};

export default Home;
