import React, { useEffect, useState } from "react";
import "./style.css";

const VodIndicator = ({ inVod = false, free = false, reverse = false }) => {
  const [show, setShow] = useState(false);

  const setShowTimer = (timerFinish = () => {}) => {
    setTimeout(() => {
      setShow(true);
      timerFinish();
    }, window.premio_config.red_button_show_time * 1000);
  };

  const setHideTimer = (timerFinish = () => {}) => {
    setTimeout(() => {
      setShow(false);
      timerFinish();
    }, window.premio_config.red_button_hide_time * 1000);
  };

  useEffect(() => {
    setShowTimer(setHideTimer);
  }, []);

  return (
    <div className={free ? "vod-indicator-free" : "vod-indicator"}>
      {!inVod && show ? (
        <>
          {!reverse && <div className="red-dot " />}
          <p style={{ color: "#FFFFFF" }}>
            <strong style={{ color: "#FFFFFF" }}>ON DEMAND - FRECCIA SU</strong>
          </p>
          {reverse && <div className="red-dot reverse" />}
        </>
      ) : (
        <>
          {/* {!reverse && <div className="blue-dot" />}
          <p style={{ color: "#FFFFFF" }}>
            <strong style={{ color: "#FFFFFF" }}>BACK</strong>
          </p>
          {reverse && <div className="blue-dot reverse" />} */}
        </>
      )}
    </div>
  );
};

export default VodIndicator;
