import ObjectVideo from "./ObjectVideo";
import ReplayVideo from "./ReplayVideo";
import NativeVideo from "./NativeVideo";
import NoVideo from "./NoVideo";
import LoadingIndicator from "../LoadingIndicator";

const Video = (props) => {
  if (props.loading) {
    return (
      <div
        style={{
          display: "flex",
          background: "#000000",
          justifyContent: "center",
          alignItems: "center",
          height: 720,
          width: 1280,
        }}
      >
        <LoadingIndicator />
      </div>
    );
  } else {
    if (window.premio_config.video_player === "object")
      return <ObjectVideo {...props} />;
    else if (window.premio_config.video_player === "replay")
      return <ReplayVideo {...props} />;
    else if (window.premio_config.video_player === "native")
      return <NativeVideo {...props} />;
    else if (window.premio_config.video_player === "none")
      return <NoVideo {...props} />;
    else return <p style={{ color: "red" }}>No player selected!</p>;
  }
};

export default Video;
