import React, { useRef, useEffect, useState } from "react";
import "./style.css";
import KeyHandler from "../KeyHandler";
import KeyCodes from "../KeyHandler/KeyCodes";
import { useStoreState } from "easy-peasy";

const Video = ({
  video,
  vodLivestream = false,
  livestream = false,
  onLoadEvent = () => {},
}) => {
  const [initialized, setInitialized] = useState(false);
  const videoRef = useRef(null);

  const [totalTime, setTotalTime] = useState(0);
  const [currentTime, setCurrentTime] = useState({ timeToEnd: 0, time: 0 });
  const [showControls, setShowControls] = useState(true);

  const timer = useRef(null);
  const player = useRef(null);

  const [videoReload, setVideoReload] = useState(false);
  const [playing, setPlaying] = useState(true);

  const controller = useStoreState((state) => state.controller);

  useEffect(() => {
    if (videoReload) {
      setTimeout(() => {
        setVideoReload(false);
      }, 100);
    } else {
      setVideoReload(true);
      setTimeout(() => {
        setVideoReload(false);
      }, 200);
    }
  }, [video]);

  useEffect(() => {
    if (controller.data.categoryOpen !== null) {
      setVideoReload(true);
    } else {
      if (videoReload) {
        setVideoReload(false);
      }
    }
  }, [controller.data.categoryOpen]);

  useEffect(() => {
    if (!videoReload) {
      _initPlayer();
    }
  }, [videoReload]);

  const onStartEvent = () => {
    onLoadEvent();
  };

  const _initPlayer = () => {
    if (videoReload) {
      setVideoReload(false);
      return;
    }
    console.log("Initializing", video);
    setInitialized(true);

    var vid = _getVideoElement();
    vid.setAttribute("data", video);

    onStartEvent();
    try {
      videoControls.play();
      return true;
    } catch (ex) {
      console.log("VIDEO PLAY UNDEFINED", ex);
    }

    if (!livestream && !vodLivestream) {
      // videoRef.current.addEventListener('timeupdate', _onProgress);
      if (!showControls) {
        setShowControls(true);
        startHide();
      }
    }
  };

  const startHide = () => {
    if (timer.current !== null) {
      clearTimeout(timer.current);
      timer.current = null;
    }
    timer.current = setTimeout(() => {
      setShowControls(false);
      timer.current = null;
    }, 4000);
  };

  const _getVideoElement = () => {
    return document.getElementById("video_object");
    // var objects = document.getElementsByTagName("object");
    // if (objects.length) {
    //   for (var i = 0; i < objects.length; i++) {
    //     var type = objects[i].type;
    //     if (type.indexOf("video") > -1 || type.indexOf("dash") > -1) {
    //       // this.unifyVideoObjectsAPI(objects[i], "object");
    //       return objects[i];
    //     }
    //   }
    // }

    // return null;

    // return document.getElementsByTagName('video')[0]
  };

  const videoControls = {
    play: () => {
      try {
        const vid = _getVideoElement();
        setPlaying(true);
        vid.play(1);
      } catch (e) {
        console.log("Video play failed", e);
      }
    },
    stop: () => {
      try {
        const vid = _getVideoElement();
        setPlaying(false);
        vid.play(0);
      } catch (e) {
        console.log("Video stop failed", e);
      }
    },
    pause: () => {
      console.log("Trying pause");
      try {
        const vid = _getVideoElement();
        setPlaying(false);
        vid.play(0);
      } catch (e) {
        console.log("Video pause failed", e);
      }
    },
    forward: () => {
      console.log("Trying forward");
    },
    rewind: () => {
      console.log("Trying rewind");
    },
  };

  const doForward = () => {
    videoControls.forward();
  };

  const doRewind = () => {
    videoControls.rewind();
  };

  const togglePlay = () => {
    if (playing) {
      videoControls.play();
      setPlaying(true);
    } else {
      videoControls.pause();
      setPlaying(false);
    }
  };

  const onKeyDown = (keyCode) => {
    if (!livestream && !vodLivestream) {
      if ([KeyCodes.VK_PLAY_PAUSE, KeyCodes.VK_SPACE].includes(keyCode)) {
        togglePlay();
      } else if ([KeyCodes.VK_PLAY].includes(keyCode)) {
        videoControls.play();
        setPlaying(true);
      } else if ([KeyCodes.VK_PAUSE].includes(keyCode)) {
        videoControls.pause();
        setPlaying(false);
      } else if ([KeyCodes.VK_STOP, KeyCodes.VK_DEBUG_S].includes(keyCode)) {
        if (videoRef.current.currentTime > 0) {
          setShowControls(true);
          startHide();
          setPlaying(false);
          videoControls.pause();
          videoRef.current.currentTime = 0;
        }
      } else if (
        [KeyCodes.VK_DEBUG_F, KeyCodes.VK_FAST_FWD].includes(keyCode)
      ) {
        doForward();
      } else if ([KeyCodes.VK_DEBUG_D, KeyCodes.VK_REWIND].includes(keyCode)) {
        doRewind();
      } else if (
        !controller.data.isMenuOpen &&
        [KeyCodes.VK_RIGHT].includes(keyCode)
      ) {
        doForward();
      } else if (
        !controller.data.isMenuOpen &&
        [KeyCodes.VK_LEFT].includes(keyCode)
      ) {
        doRewind();
      }
      if (
        !controller.data.isMenuOpen &&
        [KeyCodes.VK_ENTER].includes(keyCode)
      ) {
        togglePlay();
      }
    }
  };

  if (videoReload) {
    return <div style={{ height: 720, width: 1280, background: "#000000" }} />;
  } else {
    return (
      <>
        <div className="video">
          <div
            id="video_container"
            style={{ width: 1280, height: 720, background: "#000000" }}
          >
            <object
              ref={videoRef}
              width="1280"
              height="720"
              id="video_object"
              type="application/dash+xml"
              // type="video/broadcast"
              data={video}
            >
              {/*<param name="controller" value="false"></param>*/}
            </object>
          </div>
        </div>
        {!playing && (
          <div className={"video-indicator-overlay"}>
            <img src={"img/play-button-2.png"} alt={"play"} />
          </div>
        )}
        {/*{(!livestream && !vodLivestream && showControls) &&*/}
        {/*<div className={"video-controls"}>*/}
        {/*    <p>{new Date(currentTime.time * 1000).toISOString().substr(11, 8)}</p>*/}
        {/*    <div className={"progress"}>*/}
        {/*        <div*/}
        {/*            className={"bar"}*/}
        {/*            style={{width: ((currentTime.time / totalTime)*100)+"%", background: window.premio_config.background[0]}}*/}
        {/*        />*/}
        {/*    </div>*/}
        {/*    <p>{new Date(currentTime.timeToEnd * 1000).toISOString().substr(11, 8)}</p>*/}
        {/*</div>*/}
        {/*}*/}
        <KeyHandler onKeyDown={onKeyDown} />
      </>
    );
  }
};

export default Video;
