//import liraries
import React, { useEffect, useRef } from "react";

const Home = ({ onKeyDown }) => {
  const handlerDiv = useRef(null);

  useEffect(() => {
    document.addEventListener("keydown", keyHandler, true);
    return () => {
      document.removeEventListener("keydown", keyHandler, true);
    }
  });

  const keyHandler = (event) => {
    onKeyDown(event.keyCode);
    return true
  }

  return <div ref={handlerDiv} className="keyhandler" />;
};

Home.defaultProps = {
  onKeyDown: () => {},
};

export default Home;
