import React, { useEffect, useState, useRef } from "react";
import "./style.css";

import Carousel from "react-multi-carousel";
import "react-multi-carousel/lib/styles.css";

import KeyHandler from "../KeyHandler";
import KeyCodes from "../KeyHandler/KeyCodes";
import LoadingIndicator from "../LoadingIndicator";
import { ImageUrl } from "../../../utils";
import API from "../../API";

import { scrollIntoView } from "../../Utils/ScrollIntoView";
import VodIndicator from "../VodIndicator";
import { reducer } from "easy-peasy";

const CategoryItem = ({ image = "", selected = false }) => {
  return (
    <div className={selected ? "category-item selected" : "category-item"}>
      <img src={image} />
    </div>
  );
};

const VodComponent = ({
  name,
  text,
  cover,
  selected,
  isVideo = false,
  isLivestream = false,
}) => {
  return (
    <div className={"vod-container " + (selected && "selected")}>
      <img
        src={cover}
        loading={"lazy"}
        className={selected ? "vod-cover selected" : "vod-cover"}
      />
      {isVideo && <img src={"/img/play.png"} className={"play-icon"} />}
      {isLivestream && (
        <div
          className={"live-stream-badge"}
          style={{ background: window.premio_config.background[0] }}
        >
          Diretta
        </div>
      )}
      <div className={selected ? "vod-content selected" : "vod-content"}>
        <h3 className={"vod-title"}>
          {name.length > 120 ? name.substring(0, 120) + "..." : name}
        </h3>
        <p>{text.length > 120 ? text.substring(0, 120) + "..." : text}</p>
      </div>
    </div>
  );
};

const getLocalizedContent = (contents, locale) => {
  var content = null;
  if (contents) {
    content = contents[0].content;
    const cindex = contents.findIndex((c) => c.language === locale);
    if (cindex >= 0) {
      content = contents[cindex].content;
    }
  }

  return content;
};

const Categories = ({
  category,
  controller,
  selectedItem = null,
  vodOpen = false,
  logo = null,
  categoryDetails = null,
  openVideo = () => {},
  openCategory = () => {},
  openLivestream = () => {},
  closeOverlay = () => {},
  onOpen = () => {},
  onClose = () => {},
}) => {
  const [selected, setSelected] = useState(0);
  const [visible, setVisible] = useState({ min: 0, max: 2 });
  const [loading, setLoading] = useState(true);
  const [categoryData, setCategoryData] = useState({});
  const carousel = useRef(null);

  const [showLeftArrow, setShowLeftArrow] = useState(false);
  const [showRightArrow, setShowRightArrow] = useState(false);

  useEffect(() => {
    if (categoryDetails) {
      setLoading(true);
      API.load_category(categoryDetails.id)
        .then((response) => {
          // setLoading(false)
          console.log(">>>>>>>>", selected);
          setCategoryData(response.data);
        })
        .catch((err) => console.log(err));
    }
  }, [categoryDetails]);

  useEffect(() => {
    if (loading && categoryData.success) {
      setLoading(false);
    }
  }, [categoryData]);

  useEffect(() => {
    if (!loading) {
      if (selectedItem && selectedItem >= visible.max) {
        var length =
          categoryData.livestreams.length +
          categoryData.vod.length +
          categoryData.categories.length;
        scrollIntoView(
          document.getElementsByClassName("category-overlay-programs")[0],
          selectedItem - visible.max,
          true
        );
        // scrollIntoView(document.getElementsByClassName("category-overlay-programs")[0], document.getElementsByClassName("vod-container")[selectedItem], document.getElementsByClassName("vod-container")[2])
        // document.getElementsByClassName("vod-container")[selectedItem].scrollIntoView({behaviour: "smooth", block: "nearest", inline: "center"})
        setVisible((oldVis) => {
          return {
            min: selectedItem - 2,
            max: selectedItem,
          };
        });
      } else {
        scrollIntoView(
          document.getElementsByClassName("category-overlay-programs")[0],
          0,
          false
        );
        // scrollIntoView(document.getElementsByClassName("category-overlay-programs")[0], document.getElementsByClassName("vod-container")[0], document.getElementsByClassName("vod-container")[1])
        // document.getElementsByClassName("vod-container")[0]?.scrollIntoView({behaviour: "smooth", block: "nearest", inline: "center"})
        setVisible({
          min: 0,
          max: 2,
        });
      }
    }
  }, [loading]);

  useEffect(() => {
    if (selectedItem !== null && selectedItem !== selected) {
      setSelected(selectedItem);
    } else if (selected !== 0) {
      setSelected(0);
    }
  }, [selectedItem]);

  useEffect(() => {
    var length =
      (categoryData.livestreams?.length || 0) +
      (categoryData.vod?.length || 0) +
      (categoryData.categories?.length || 0);

    if (length > 3 && visible.max < length - 1) {
      setShowRightArrow(true);
    } else {
      setShowRightArrow(false);
    }

    if (visible.min > 0) {
      setShowLeftArrow(true);
    } else {
      setShowLeftArrow(false);
    }
  }, [visible, categoryData, showLeftArrow, showRightArrow]);

  const move_slide = (forward = true) => {
    if (document.getElementsByClassName("vod-container").length === 0) return;
    if (forward) {
      var length =
        categoryData.livestreams.length +
        categoryData.vod.length +
        categoryData.categories.length;
      if (selected === visible.max) {
        // carousel.current.next()
        scrollIntoView(
          document.getElementsByClassName("category-overlay-programs")[0],
          1,
          true
        );
        // scrollIntoView(document.getElementsByClassName("category-overlay-programs")[0], document.getElementsByClassName("vod-container")[selected], document.getElementsByClassName("vod-container")[selected-1])
        // document.getElementsByClassName("vod-container")[selected].scrollIntoView({behaviour: "smooth", block: "nearest", inline: "center"})
        setVisible((oldVis) => {
          return {
            min: oldVis.max < length - 1 ? oldVis.min + 1 : oldVis.min,
            max: oldVis.max < length - 1 ? oldVis.max + 1 : oldVis.max,
          };
        });
      }

      if (selected < length - 1) {
        console.log("SETTING SELECTED", selected + 1);
        setSelected((s) => s + 1);
        // carousel.current.next()
      }
    } else {
      if (selected === visible.min) {
        // carousel.current.previous()
        scrollIntoView(
          document.getElementsByClassName("category-overlay-programs")[0],
          1,
          false
        );
        // scrollIntoView(document.getElementsByClassName("category-overlay-programs")[0], document.getElementsByClassName("vod-container")[selected], document.getElementsByClassName("vod-container")[selected + 1])
        // document.getElementsByClassName("vod-container")[selected].scrollIntoView({behaviour: "smooth", block: "nearest", inline: "center"})
        setVisible((oldVis) => {
          return {
            min: oldVis.min > 0 ? oldVis.min - 1 : 0,
            max: oldVis.min > 0 ? oldVis.max - 1 : oldVis.max,
          };
        });
      }
      if (selected > 0) {
        setSelected((s) => s - 1);
        // carousel.current.previous()
      }
    }
  };

  const onKeyDown = (keyCode) => {
    if ([KeyCodes.VK_ENTER].includes(keyCode)) {
      if (selected < categoryData.livestreams.length) {
        openLivestream(categoryData.livestreams[selected], selected);
        setSelected(0);
      } else if (
        selected <
        categoryData.livestreams.length + categoryData.categories.length
      ) {
        openCategory(
          categoryData.categories[selected - categoryData.livestreams.length],
          selected
        );
        setSelected(0);
      } else {
        openVideo(
          categoryData.vod[
            selected -
              (categoryData.livestreams.length + categoryData.categories.length)
          ]
        );
        // setSelected(0)
      }
    } else if ([KeyCodes.VK_RIGHT].includes(keyCode)) {
      move_slide();
    } else if ([KeyCodes.VK_LEFT].includes(keyCode)) {
      move_slide(false);
    } else if (
      [
        KeyCodes.VK_BACK,
        KeyCodes.H_BACK,
        KeyCodes.VK_BLUE,
        KeyCodes.H_BLUE,
        8,
      ].includes(keyCode)
    ) {
      closeOverlay(false);
    } else if (
      vodOpen &&
      [KeyCodes.VK_BLUE, KeyCodes.H_BLUE].includes(keyCode)
    ) {
      closeOverlay(false);
    }
  };

  const content = getLocalizedContent(
    categoryDetails?.content,
    controller.data.locale
  );

  const _getTitleSize = (title) => {
    if (title.length <= 17) return { fontSize: "64pt" };
    else if (title.length <= 20) return { fontSize: "58pt" };
    else if (title.length <= 22) return { fontSize: "52pt" };
    else return { fontSize: "42pt" };
  };

  if (category === null) {
    return <></>;
  } else {
    return (
      <>
        {logo !== null && <img src={logo} className={"logo"} alt={"Brand"} />}
        <div
          className={"category-overlay"}
          style={{
            background:
              "linear-gradient(90deg, " +
              (window.premio_config.background[0] || "#000000") +
              " 0%, " +
              (window.premio_config.background[1] || "#222222") +
              " 100%)",
          }}
        >
          <div className={"category-overlay-header"}>
            <img
              src={ImageUrl(categoryDetails.cover_image)}
              className={"category-overlay-cover"}
            />
            <div>
              <p
                className={"category-overlay-title"}
                style={_getTitleSize(content.name)}
              >
                {content.name}
              </p>
              <p className={"category-overlay-description"}>
                {content.description}
              </p>
            </div>
          </div>
          <div
            style={{
              display: "flex",
              justifyContent: "space-between",
              marginLeft: 30,
            }}
          >
            <h2 className={"h2"}>Programmi </h2>
            {/* <VodIndicator inVod={true} free={true} reverse={true} /> */}
          </div>
          <div className={"category-overlay-divider"} />
          {loading ? (
            <div className={"vod-loader"}>
              <LoadingIndicator />
            </div>
          ) : (
            <>
              <div className="category-overlay-programs">
                {/*{categoryData.categories.map(())}*/}
                {categoryData.livestreams.map((cat, index) => {
                  const vcontent = getLocalizedContent(
                    cat.content,
                    controller.data.locale
                  );
                  return (
                    <VodComponent
                      key={"LS-" + index}
                      name={vcontent.name}
                      text={vcontent.description}
                      cover={ImageUrl(cat.cover_image)}
                      selected={selected === index}
                      isLivestream={true}
                    />
                  );
                })}
                {categoryData.categories.map((cat, index) => {
                  const vcontent = getLocalizedContent(
                    cat.content,
                    controller.data.locale
                  );
                  return (
                    <VodComponent
                      key={"CATEGORY-" + index}
                      name={vcontent.name}
                      text={vcontent.description}
                      cover={ImageUrl(cat.cover_image)}
                      selected={
                        selected === categoryData.livestreams.length + index
                      }
                      isVideo={false}
                    />
                  );
                })}
                {categoryData.vod.map((vod, index) => {
                  const vcontent = getLocalizedContent(
                    vod.content,
                    controller.data.locale
                  );
                  return (
                    <VodComponent
                      key={"VOD-" + index}
                      name={vcontent.title}
                      text={vcontent.subtitle}
                      cover={ImageUrl(vod.cover_image)}
                      selected={
                        selected === categoryData.categories.length + index
                      }
                      isVideo={true}
                    />
                  );
                })}
              </div>
              {showLeftArrow && (
                <img
                  src="img/chevron-left.png"
                  alt="left-arrow"
                  className="arrow-left"
                />
              )}
              {showRightArrow && (
                <img
                  src="img/chevron-right.png"
                  alt="right-arrow"
                  className="arrow-right"
                />
              )}
            </>
          )}
        </div>
        <KeyHandler onKeyDown={onKeyDown} />
      </>
    );
  }
};

export default Categories;
