import React, {
  useEffect,
  useState,
  useRef,
  useImperativeHandle,
  forwardRef,
} from "react";
// import "./style.css";

import KeyHandler from "../KeyHandler";
import KeyCodes from "../KeyHandler/KeyCodes";
import { isElement } from "react-dom/test-utils";
import { ImageUrl } from "../../../utils";

import BFCCategoryWrapper from "./Wrappers/Bfc";
import BikeCategoryWrapper from "./Wrappers/Bike";

// var timer = null;
console.log(window.premio_config);
const CategoryWrapper =
  window.premio_config.category_style === "bfc"
    ? BFCCategoryWrapper
    : BikeCategoryWrapper;

const Categories = forwardRef(
  (
    {
      listenToKeys,
      logo = null,
    //  categoryItems = [],
      openSelected = () => {},
      onOpen = () => {},
      onClose = () => {},
    },
    ref
  ) => {
    const [closed, setClosed] = useState(true);
    const [selected, setSelected] = useState(0);

    const timer = useRef(null);
 
  //const categoryItems = [{"cover_image":"http://dev.djaxbidder.com/InAriaMedia_video/www/images/7758b6cc1678229601cd4dcf0d6e2942.jpg"}];

  const categoryItems = [{
    "id": 46,
    "cover_image": window.premio_config.imageurl,
    "status": "published",
    "name": "Cosmo",
    "content_id": 104,
    "platform_id": 1,
    "parent_id": null,
    "display_order": 31,
    "created_date": "2021-06-24T14:09:01.000Z",
    "last_modified": "2021-06-24T14:09:01.000Z",
    "is_deleted": 0,
    "content": [
        {
            "language": "en",
            "content": {
                "name": "",
                "description": ""
            }
        },
        {
            "language": "it",
            "content": {
                "name": "Cosmo",
                "description": "Lo Spazio osservato a 360° con scienziati, aziende aerospaziali, strumenti, astrofili. Ricerca e scienza, ma anche economia, passione e tecnologia."
            }
        }
    ]
}]
//  console.log(categoryItems);
    // const categoryItems = [
    //     "/data/categories/borsa.png",
    //     "/data/categories/FORBES.jpg",
    //     "/data/categories/BIKESPORT.jpg",
    //     "/data/categories/COSMO.jpg",
    //     "/data/categories/EQUOS.jpg",
    // ];

    useEffect(() => {
      if (!closed && !timer.current) {
        startHide();
      }

      if (closed) onClose();
      else onOpen();
    }, [closed]);

    useImperativeHandle(ref, () => ({
      show() {
        setClosed(false);
        startHide();
      },
      hide() {
        setClosed(true);
      },
    }));

    useEffect(() => {
      setClosed(false);
      startHide();
    }, []);

    const onKeyDown = (keyCode) => {
      if ([KeyCodes.VK_ENTER].includes(keyCode)) {
        if (!closed && !window.premio_config.static_categories) {
          openSelected(selected);
          setClosed(true);
        }
      } else if ([KeyCodes.VK_RIGHT].includes(keyCode)) {
        if (closed) return;
        if (selected < categoryItems.length - 1) {
          setSelected((s) => s + 1);
        }
      } else if ([KeyCodes.VK_LEFT].includes(keyCode)) {
        if (closed) return;
        if (selected > 0) {
          setSelected((s) => s - 1);
        }
      } else if ([KeyCodes.VK_RED, KeyCodes.H_RED].includes(keyCode)) {
        if (closed) {
          setClosed(false);
          startHide();
        } else {
          setClosed(true);
          clearTimeout(timer.current);
        }
      } else if ([KeyCodes.VK_UP].includes(keyCode)) {
        if (closed) {
          setClosed(false);
        }
      } else if ([KeyCodes.VK_DOWN].includes(keyCode)) {
        if (!closed) {
          setClosed(true);
        }
      }

      if (!closed) startHide();

      return false;
    };

    const startHide = () => {
      if (timer.current !== null) {
        clearTimeout(timer.current);
        timer.current = null;
      }
      timer.current = setTimeout(() => {
        setClosed(true);
        timer.current = null;
      }, window.premio_config.menu_hide_time * 1000);
    };

    // useEffect(() => {
    //     setTimeout(() => {
    //         setClosed(false)
    //         startHide()
    //     }, 2000)
    // }, [])

    return (
      <>
        <CategoryWrapper
          closed={closed}
          categoryItems={
            window.premio_config.static_categories || categoryItems
          }
          selected={selected}
          logo={logo}
          isStatic={!!window.premio_config.static_categories}
        />
        {/*<div className={closed ? "category-wrapper closed" : "category-wrapper"}>*/}
        {/*    {categoryItems.map((cat, index) => {*/}
        {/*        return (*/}
        {/*            <CategoryItem*/}
        {/*                key={index}*/}
        {/*                selected={selected === index}*/}
        {/*                image={ImageUrl(cat.cover_image)}*/}
        {/*            />*/}
        {/*        );*/}
        {/*    })}*/}
        {/*</div>*/}
        {listenToKeys && <KeyHandler onKeyDown={onKeyDown} />}
      </>
    );
  }
);

export default Categories;
