import React from "react";
import "./style.css";

import {ImageUrl} from "../../../../../utils";

const CategoryItem = ({data, logo, image = "", selected = false}) => {
    return (
        <div className={selected ? "bike-category-item selected" : "bike-category-item"}>

            <img className={"bike-category-img"} src={image}/>
            <div className={"bike-category-item-content"}>
                <div className={"bike-category-item-logo"}>
                    <img src={logo}  />
                </div>
                <div className={"bike-category-item-divider"}/>
                <div className={"bike-category-item-title"}>{data.name.toUpperCase()}</div>
            </div>
        </div>
    );
};

const CategoryWrapper = ({closed, categoryItems, selected, logo, isStatic=false}) => {
    return (
        <div className={closed ? "bike-category-wrapper closed" : "bike-category-wrapper"}>
            {categoryItems.map((cat, index) => {
                return (
                    <CategoryItem
                        key={index}
                        data={cat}
                        logo={logo}
                        selected={selected === index}
                        image={ImageUrl(cat.cover_image, isStatic)}
                    />
                );
            })}
        </div>
    )
}

export default CategoryWrapper