import React from "react";
import "./style.css";
import $ from 'jquery'; 

import {ImageUrl} from "../../../../../utils";

const CategoryItem = ({image = "", selected = false}) => {
    return (
        <div id="Advertisment" className={selected ? "category-item selected" : "category-item"}>
			<a id="imgclick" target="_blank"><img src={image}/></a>
			<button type="submit" className="show_btn" id="close_btn" onClick={closeoverlay}>
                <span>&times;</span>
            </button>
        </div>
    );
};

function closeoverlay () { 
    $('#category-wrapper').removeClass('category-wrapper-showad');
    $('#category-wrapper').addClass('category-wrapper');
};

const CategoryWrapper = ({closed, categoryItems, selected, isStatic=false}) => {
    //className={closed ? "category-wrapper closed" : "category-wrapper"}
    return (
        <div id="category-wrapper" className="category-wrapper">
            {categoryItems.map((cat, index) => {
                return (
                    <CategoryItem
                        key={index}
                        selected={selected === index}
                        image={ImageUrl(cat.cover_image, isStatic)}
                       // image={cat.cover_image, isStatic}
                    />
                );
            })}
        </div>
    )
}

export default CategoryWrapper
