import URL from "./endpoints";
import { call, METHOD } from "./engine";

import axios from "axios";
import * as https from "https";

const controller = {};

controller.init = () => {
  const agent = new https.Agent({
    rejectUnauthorized: false,
  });

  return axios.get(URL.init, {
    headers: {
      platformauth: "Api-Key " + window.premio_config.api_key,
      "content-type": "application/json",
    },
    httpsAgent: agent,
  });
};

controller.load_category = (id) => {
  const agent = new https.Agent({
    rejectUnauthorized: false,
  });

  return axios.get(URL.videos + "/" + id, {
    headers: {
      platformauth: "Api-Key " + window.premio_config.api_key,
      "content-type": "application/json",
    },
    httpsAgent: agent,
  });
};

export default controller;
