import endpoints from "./endpoints";
const config = window.premio_config;

export const STATUS_OK = 200;
export const STATUS_UNAUTH = 401;
export const STATUS_FORBIDDEN = 403;
export const STATUS_NO_CONTENT = 404;
export const STATUS_INTERNAL_ERROR = 500;

export const METHOD = {
  GET: "GET",
  POST: "POST",
  DELETE: "DELETE",
  PUT: "PUT",
  PATCH: "PATCH",
};

export const GENERIC_ERROR = "GENERIC_ERROR";
export const SERVER_ERROR = "SERVER_ERROR";
export const JSON_ERROR = "JSON_ERROR";
export const UNATUH_ERROR = "UNAUTHORIZED_ERROR";

export function headers() {
  var myHeaders = new Headers();
  myHeaders.append("Content-Type", "application/json");
  return myHeaders;
}

export const API_DEBUG = {
  getServerErrorBody(response, print = false) {
    if (print) {
      console.log(response._bodyText);
    } else {
      return response._bodyText;
    }
  },

  warn(error) {
    console.warn("SERVER ERROR", error.data._bodyText);
  },
};

export function formData(obj) {
  var form_data = new FormData();

  for (var key in obj) {
    form_data.append(key, obj[key]);
  }

  return form_data;
}

export function call(
  url,
  method = METHOD.GET,
  body = null,
  headers = {},
  redirect = null,
  debug = false
) {
  var otherParams = {
    method: method,
    headers: {
      platformauth: "Api-Key " + config.api_key,
      ...headers,
    },
  };

  if (body !== null) {
    otherParams.body = body;
  }

  if (redirect !== null) {
    otherParams.redirect = redirect;
  }

  console.log(url, otherParams);

  return new Promise((resolve, reject) => {
    fetch(url, otherParams)
      .then((response) => {
        if (debug) console.log(response);
        if (response.status === STATUS_OK) {
          //console.log(response);
          try {
            var parse = response.json();
            return { error: false, data: parse };
          } catch (e) {
            reject({ error: JSON_ERROR, data: response });
          }
        } else {
          try {
            var parse = response.json();
            return { error: response.status, data: parse };
          } catch (e) {
            reject({ error: JSON_ERROR, data: response });
          }
        }
      })
      .then((resp) => {
        //console.log(responseJson)
        if (!resp.error && resp.data) {
          resolve(resp.data);
        } else if (resp.error === STATUS_NO_CONTENT) {
          resolve(resp.data);
        } else if (resp.error === STATUS_INTERNAL_ERROR) {
          reject({ error: SERVER_ERROR, data: resp.data });
          //return false;
        } else if (resp.error === STATUS_UNAUTH) {
          reject({ error: UNATUH_ERROR, data: resp.data });
        } else {
          reject({ error: GENERIC_ERROR, data: resp.data });
        }
      })
      .catch((error) => {
        //console.error(error);
        reject({ error: GENERIC_ERROR, data: error });
      });
  });
}
