import { useState, useEffect, useRef } from "react";

import "./App.css";

import { BrowserRouter as Router, Switch, Route, Link } from "react-router-dom";

import { ImageUrl } from "./utils";

import Home from "./App/Screens/Home";
import API from "./App/API";
import LoadingIndicator from "./App/Components/LoadingIndicator";
import { useStoreActions, useStoreState } from "easy-peasy";

import { enableES5 } from "immer";
enableES5();

const defaultAppContext = {
  categoryOverlayOpen: false,
};

function App() {
  const [loading, setLoading] = useState(true);
  const platform = useStoreState((state) => state.platform);
  const platformInit = useStoreActions((actions) => actions.platform.init);
  const setLocale = useStoreActions((actions) => actions.controller.setLocale);

  const [err, setErr] = useState(null);

  const appRef = useRef(null);

  useEffect(() => {
    // axios
    //   .get("http://shibe.online/api/shibes?count=5&urls=false]&httpsUrls=false")
    //   .then((response) => {
    //     setErr(JSON.stringify(response, null, 2));
    //   })
    //   .catch((err) => {
    //     setErr(JSON.stringify(err, null, 2));
    //   });

    // var xhr = new XMLHttpRequest();
    // xhr.withCredentials = true;

    // xhr.addEventListener("readystatechange", function () {
    //   if (this.readyState === 4) {
    //     var res = JSON.parse(this.responseText);
    //     console.log("HERE", res);
    //     platformInit(res);
    //     setLocale(res.platform.default_language || "en");
    //     setLoading(false);
    //   } else {
    //     // setErr(JSON.stringify(err, null, 2));
    //     // setLoading(false);
    //     console.log(this.statusText);
    //   }
    // });

    // xhr.onerror = function (e) {
    //   console.log("Errror xhr", e);
    // };

    // try {
    //   xhr.open("GET", "https://apiserver.premio.live/api/v1/client/init");
    //   xhr.setRequestHeader(
    //     "platformauth",
    //     "Api-Key " + window.premio_config.api_key
    //   );
    //   xhr.setRequestHeader("Content-Type", "application/json");

    //   xhr.send();
    // } catch (err) {
    //   alert(err);
    // }
    API.init()
      .then((res) => {
        platformInit(res.data);
        setLocale(res.data.platform.default_language || "en");
        setLoading(false);
      })
      .catch((err) => {
        console.log(err);
        setErr(JSON.stringify(err, null, 2));
      });
  }, []);

  useEffect(() => {
    setTimeout(() => {
      // appRef.current.scrollTop = 0;
      window.scrollTo(0, 0);
    }, 2000);
  }, []);

  // if (err) {
  //   return (
  //     <div
  //       style={{
  //         height: 720,
  //         width: 1280,
  //         background: "red",
  //         color: "white",
  //       }}
  //     >
  //       <pre>{err}</pre>
  //     </div>
  //   );
  // }
 // console.log(appRef);
  return (
    <div className="App" ref={appRef}>
      {loading ? (
        <div
          style={{
            display: "flex",
            flex: 1,
            justifyContent: "center",
            alignItems: "center",
            height: 720,
            width: 1280,
            background: "#000000",
          }}
        >
          <LoadingIndicator />
        </div>
      ) : (
        <>
          {/*<img src="img/logo.png" className="logo"/>*/}
          <Router>
            <Switch>
              <Route path="/" component={Home} />
            </Switch>
          </Router>
        </>
      )}
    </div>
  );
}

export default App;
