// From mit-xperts
function _initApp() {
  console.log("Showing app");
  try {
    var app = document.getElementById("appmgr").getOwnerApplication(document);
    app.show();
    app.activate(); // this is for HbbTV 0.5 backwards-compliance. It will throw an ignored exception on HbbTV 1.x devices, which is fine
  } catch (e) {
    // ignore
    // console.log("Error in app showing", e)
  }
  _setKeyset(0x1 + 0x2 + 0x4 + 0x8 + 0x10 + 0x20);
  // _setKeyset(0x1+0x2+0x4+0x8+0x20+0x100);
}

function _setKeyset(mask) {
  var elemcfg, app;
  // for HbbTV 0.5:
  try {
    elemcfg = document.getElementById("oipfcfg");
    elemcfg.keyset.value = mask;
  } catch (e) {
    // ignore
  }
  try {
    elemcfg = document.getElementById("oipfcfg");
    elemcfg.keyset.setValue(mask);
  } catch (e) {
    // ignore
  }
  // for HbbTV 1.0:
  try {
    app = document.getElementById("appmgr").getOwnerApplication(document);
    app.privateData.keyset.setValue(mask);
  } catch (e) {
    // ignore
  }
}

function _hideApp() {
  try {
    var app = document.getElementById("appmgr").getOwnerApplication(document);
    app.hide();
  } catch (e) {
    // ignore
  }

  _setKeyset(0x1);
}

const OIPF_mit_xperts = {
  startApp: () => {
    _initApp();
  },
  stopApp: () => {
    _hideApp();
  },
};
