var application = null;
var keyset = null;
var keysetHidden = null;
var keysetVisible = null;

function _initialize() {
    console.log("Initializing Manager")
    try {
        if (application) return;
        var manager = null;
        var objects = document.getElementsByTagName("object");
        for (var i=0; i<objects.length; i++) {
            var sType = objects.item(i).getAttribute("type");
            if (sType == "application/oipfApplicationManager") {
                manager = objects.item(i);
            }
        }
        if (manager && typeof(manager.getOwnerApplication) != "undefined") {
            application = manager.getOwnerApplication(document);
            try {	// HbbTV 1.1.1
                keyset = application.privateData.keyset;
            } catch (e) {// HbbTV 0.5
                try {
                    var config = null;
                    var objects = document.getElementsByTagName("object");
                    for (var i=0; i<objects.length; i++) {
                        var sType = objects.item(i).getAttribute("type");
                        if (sType == "application/oipfConfiguration") {
                            config = objects.item(i);
                        }
                    }
                    keyset = config.keyset;
                    keyset.setValue = function (val) {this.value = val;};
                } catch (e) { keyset = null; }
            }
            if (keyset) {
                if (!keysetHidden) keysetHidden  = keyset.RED;
                if (!keysetVisible) keysetVisible =  0x33F; // color + nav + vcr + numeric + alpha
            }
        }
    } catch (e) {
        console.log("Initializing Fail", e)
        application = null;
        return false;
    }
};

function _show() {
    console.log("Showing Manager")
    try {
        application.show();
        if (typeof application.activate != "undefined") application.activate();
        if (typeof application.activateInput != "undefined") application.activateInput();
        keyset.setValue(0x33F);
        // registerKeys(1)
        return true;
    } catch (e) {
        console.log("Showing Fail", e)
        return false;
    }
}

function _hide() {
    keyset.setValue(keysetHidden);
    try {
        application.hide();
        return true;
    } catch (e) {
        return false;
    }
}

const OIPF_autostart = {
    startApp: () => {
        _initialize()
        _show()
    },
    stopApp: () => {
        _hide()
    }
}