/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
let beforeUnloadFixAdded = false;
export const onHidden = (cb, once) => {
    // Adding a `beforeunload` listener is needed to fix this bug:
    // https://bugs.chromium.org/p/chromium/issues/detail?id=987409
    if (!beforeUnloadFixAdded &&
        // Avoid adding this in Firefox as it'll break bfcache:
        // https://stackoverflow.com/questions/9847580/how-to-detect-safari-chrome-ie-firefox-and-opera-browser
        // @ts-ignore
        typeof InstallTrigger === 'undefined') {
        // eslint-disable-next-line @typescript-eslint/no-empty-function
        addEventListener('beforeunload', () => { });
        beforeUnloadFixAdded = true;
    }
    const onVisibilityChange = (event) => {
        if (document.visibilityState === 'hidden') {
            cb(event);
            if (once) {
                removeEventListener('visibilitychange', onVisibilityChange, true);
            }
        }
    };
    addEventListener('visibilitychange', onVisibilityChange, true);
};
