(window.webpackJsonp=window.webpackJsonp||[]).push([[41],{"./src/replay/default-player/Replay.js":function(e,A,a){"use strict";var o=a("./src/replay/default-player/baseConfiguration.js"),n=a("./src/replay/playerComposer.js"),t=a("./src/replay/default-player/default-skin/graphics.js"),s=a("./src/replay/default-player/strings.js");const g=Object(n.a)({name:"Replay",graphics:t.a,strings:s.a,configuration:o.a});A.a=g},"./src/replay/docs/using-replay/controlling-playback.mdx":function(e,A,a){"use strict";a.r(A),a.d(A,"default",(function(){return B}));var o=a("./node_modules/react/index.js"),n=a.n(o),t=a("./node_modules/@mdx-js/tag/dist/index.js"),s=a("./node_modules/docz/dist/index.m.js"),g=a("./src/replay/default-player/Replay.js");a("./src/replay/replay-default.css");function i(e,A){if(null==e)return{};var a,o,n=function(e,A){if(null==e)return{};var a,o,n={},t=Object.keys(e);for(o=0;o<t.length;o++)a=t[o],A.indexOf(a)>=0||(n[a]=e[a]);return n}(e,A);if(Object.getOwnPropertySymbols){var t=Object.getOwnPropertySymbols(e);for(o=0;o<t.length;o++)a=t[o],A.indexOf(a)>=0||Object.prototype.propertyIsEnumerable.call(e,a)&&(n[a]=e[a])}return n}class B extends n.a.Component{constructor(e){super(e),this.layout=null}render(){const e=this.props,A=e.components,a=i(e,["components"]);return n.a.createElement(t.MDXTag,{name:"wrapper",components:A},n.a.createElement(t.MDXTag,{name:"h1",components:A,props:{id:"controlling-the-playback-programmatically"}},"Controlling the playback programmatically"),n.a.createElement(t.MDXTag,{name:"h2",components:A,props:{id:"prerequisites"}},"Prerequisites"),n.a.createElement(t.MDXTag,{name:"p",components:A},"This chapters describe the API parts of the Replay component available for controlling the playback, or for observing all sides of the playback progress and state."),n.a.createElement(t.MDXTag,{name:"p",components:A},"For the following examples, the same prerequisites apply as in the ",n.a.createElement(t.MDXTag,{name:"a",components:A,parentName:"p",props:{href:"/replay/insert#prerequisites"}},"Inserting Replay")," chapter."),n.a.createElement(t.MDXTag,{name:"h2",components:A,props:{id:"api-design"}},"API design"),n.a.createElement(t.MDXTag,{name:"p",components:A},"Replay APIs are designed to optimally align with the React mindset where the UI is rendered and updated based on properties and their changes. Properties are preferred in favour of methods and events."),n.a.createElement(t.MDXTag,{name:"h3",components:A,props:{id:"property-updates-in-favour-of-eventsdistinct-callbacks"}},"Property updates in favour of events/distinct callbacks"),n.a.createElement(t.MDXTag,{name:"p",components:A},"Specifically, all aspects of the ongoing playback's state, are expressed as properties and changes to these properties. While the ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"HTMLVideoElement")," typically emits events like ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"timeupdate"),", ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"ended"),", or ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"paused"),", Replay funnels all events and updates through a single callback prop, ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"onStreamStateChange"),". The callback method assigned to this prop, will be invoked with a property containing an updated value. "),n.a.createElement(t.MDXTag,{name:"p",components:A},"For the mentioned examples of events, it means Replay instead expresses the same through changes to properties named ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"position")," (with the new position as its value), ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"playState")," (with the value ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"inactive")," when playback has ended), or ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"isPaused")," (with a value of ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"true")," when playback is paused)."),n.a.createElement(t.MDXTag,{name:"p",components:A},"Replay provides a special overlay illustrating the playback state properties and their updates as the playback goes by. Press play below and observe the properties getting updated:"),n.a.createElement(g.a,{source:"public/example-media/progressive.mp4",initialPlaybackProps:{isPaused:!0},options:{playbackMonitor:{visibleAtStart:!0}}}),n.a.createElement(t.MDXTag,{name:"p",components:A},"The same playback monitor overlay can be revealed in any Replay player instance by pressing Ctrl+Alt+M."),n.a.createElement(t.MDXTag,{name:"h3",components:A,props:{id:"settable-properties-or-callable-methods"}},"Settable properties or callable methods"),n.a.createElement(t.MDXTag,{name:"p",components:A},"Similarly, all operations on the playback or player can be expressed by setting properties. However, these can't be regular React props passed down to the Replay component. The reason for this, is that the prop values can get out of sync with the actual Replay playback state. "),n.a.createElement(t.MDXTag,{name:"p",components:A},'A specific example: A component prop value for pausing can\'t be the "source of truth" for the actual pause state of the playback, because playback can be paused or resumed from within the Replay component for several reasons. If a component prop ',n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"isPaused")," was already set to ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"true"),", and the playback is in fact no longer paused, setting the same prop to ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"true")," will have no effect in React, since there was no value change to the prop."),n.a.createElement(t.MDXTag,{name:"p",components:A},"Instead, pausing a video can be performed by invoking a method, ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"setProperties({ isPaused: true })"),". This bypasses the React prop diff-ing, and will pause the video anyhow."),n.a.createElement(t.MDXTag,{name:"p",components:A},"Besides the ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"setProperties()")," approach, Replay exposes sugar methods in a more familiar style. Examples of such methods are ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"play()"),", ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"pause()"),", ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"setVolume()"),", ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"mute()"),", ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"setPosition()"),", ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"setSelectedTextTrack()"),", and more. These sugar methods simply call ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"setProperties()")," with different keys and values."),n.a.createElement(t.MDXTag,{name:"h2",components:A,props:{id:"how-to-perform-operations-on-the-playback"}},"How to perform operations on the playback"),n.a.createElement(t.MDXTag,{name:"p",components:A},n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"setProperties()")," and the sugar playback methods are exposed to Replay component consumers through a callback prop ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"onPlaybackActionsReady"),". Pass a callback to ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"onPlaybackActionsReady")," to get hold of these methods. The callback will receive all methods in an object passed as the first argument."),n.a.createElement(t.MDXTag,{name:"p",components:A},"See the ",n.a.createElement(t.MDXTag,{name:"a",components:A,parentName:"p",props:{href:"/replay/api#methods-available-through-onplaybackactionsready"}},"Replay API methods")," for a full reference of sugar playback methods."),n.a.createElement(t.MDXTag,{name:"p",components:A},"See ",n.a.createElement(t.MDXTag,{name:"a",components:A,parentName:"p",props:{href:"/reference/settable-properties"}},"Settable properties")," for a full reference of playback properties that can be used with ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"setProperties()"),". This method takes an argument with an object containing the properties and their values to be set. More than one property can be passed in one call to ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"setProperties()"),"."),n.a.createElement(t.MDXTag,{name:"p",components:A},"There is another special method returned as part of the object argument to the ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"onPlaybackActionsReady")," callback. This method is ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"inspect()"),". It returns an object with a snapshot of the current playback state, containing properties also exposed through the ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"onStreamStateChange")," callback. "),n.a.createElement(t.MDXTag,{name:"p",components:A},"Observing the playback state properties is discussed thoroughly in the next chapter. It is recommended to keep track of the state reactively, through an ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"onStreamStateChange")," callback instead of using ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"inspect()"),". The properties returned by this method will not update and must be considered out-of-date in any subsequent async code."),n.a.createElement(t.MDXTag,{name:"p",components:A},"The next chapter contains a full code example for controlling and observing the playback outside the Replay player."),n.a.createElement(t.MDXTag,{name:"pre",components:A},n.a.createElement(t.MDXTag,{name:"code",components:A,parentName:"pre",props:{className:"language-javascript"}},"const playbackActionsReady = ({ play, setPosition, setProperties }) => {\n  this.playVideo = play;\n  this.setPlaybackPosition = setPosition;\n  this.setPlaybackProperties = setProperties;\n}\n\n/// In e.g. click handlers for buttons outside the Replay player.\n\nthis.handleRestartClick = () => {\n  if (this.setPlaybackPosition) {\n    this.setPlaybackPosition(0);\n  }\n};\n\nthis.handleStartClick = () => {\n  if (this.playVideo) {\n    this.playVideo();\n  }\n};\n\n// The alternative way, setting properties instead of calling a dedicated method, e.g. unmute().\n\nthis.handleUnmuteClick = () => {\n  if (this.setPlaybackProperties) {\n    this.setPlaybackProperties({ isMuted: false });\n  }\n}; \n")),n.a.createElement(t.MDXTag,{name:"h2",components:A,props:{id:"how-to-observe-the-stream-playback-state"}},"How to observe the stream playback state"),n.a.createElement(t.MDXTag,{name:"p",components:A},"Playback state consists of playback position, duration, stream mode, pause, seek, and buffering state, available text and audio tracks, bitrate (if adaptive streaming is used)."),n.a.createElement(t.MDXTag,{name:"p",components:A},"The ",n.a.createElement(t.MDXTag,{name:"inlineCode",components:A,parentName:"p"},"onStreamStateChange")," callback prop is invoked when any of these playback state properties changes. The callback is invoked with an object containing the changes as keys/values."),n.a.createElement(t.MDXTag,{name:"pre",components:A},n.a.createElement(t.MDXTag,{name:"code",components:A,parentName:"pre",props:{className:"language-javascript"}},"this.handleStreamStateChange = stateProperties => {\n  if ('position' in stateProperties) {\n    console.log('Playback position is', stateProperties.position);\n  }\n  if ('volume' in stateProperties) {\n    console.log('The volume is changed into', stateProperties.volume);\n  }\n  if (stateProperties.isPaused) {\n    console.log('The playback was paused.');\n  }\n};\n")),n.a.createElement(t.MDXTag,{name:"p",components:A},"See the ",n.a.createElement(t.MDXTag,{name:"a",components:A,parentName:"p",props:{href:"/reference/observable-stream-state"}},"full reference of state properties")," for all keys/value types passed in this callback."),n.a.createElement(t.MDXTag,{name:"h2",components:A,props:{id:"full-example-showing-operations-on-playback-and-observations-of-the-playback-state"}},"Full example showing operations on playback, and observations of the playback state"),n.a.createElement(s.Playground,{__codesandbox:"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",__position:1,__code:"() => {\n  let playVideo, setPlaybackPosition, setPlaybackProperties\n\n  const playbackActionsReady = ({ play, setPosition, setProperties }) => {\n    playVideo = play\n    setPlaybackPosition = setPosition\n    setPlaybackProperties = setProperties\n  }\n  const handleRestartClick = () => {\n    if (setPlaybackPosition) {\n      setPlaybackPosition(0)\n    }\n  }\n\n  const handleStartClick = () => {\n    if (playVideo) {\n      playVideo()\n    }\n  }\n\n  // The alternative way, setting properties instead of calling a dedicated method, e.g. unmute().\n  const handleMuteClick = () => {\n    if (setPlaybackProperties) {\n      setPlaybackProperties({ isMuted: true })\n    }\n  }\n\n  const handleUnmuteClick = () => {\n    if (setPlaybackProperties) {\n      setPlaybackProperties({ isMuted: false })\n    }\n  }\n\n  // Check the Dev tools console for the log output from this handler:\n  const handleStreamStateChange = stateProperties => {\n    if (stateProperties) {\n      if ('position' in stateProperties) {\n        console.log(\n          'Stream observation example: Playback position is ' +\n            stateProperties.position.toFixed(1),\n        )\n      }\n      if ('volume' in stateProperties) {\n        console.log(\n          'Stream observation example: Playback position is ' +\n            Math.round(stateProperties.volume * 100),\n        )\n      }\n      if (stateProperties.isPaused) {\n        console.log('Stream observation example: The playback was paused.')\n      }\n      if (stateProperties.isPaused === false) {\n        console.log('Stream observation example: The playback was resumed.')\n      }\n      if (stateProperties.playState === 'inactive') {\n        console.log('Stream observation example: The playback has ended.')\n      }\n    }\n  }\n\n  return (\n    <div>\n      <Replay\n        source={{\n          streamUrl: 'public/example-media/progressive.mp4',\n          startPosition: 13,\n        }}\n        initialPlaybackProps={{ isPaused: true, isMuted: true }}\n        onStreamStateChange={handleStreamStateChange}\n        onPlaybackActionsReady={playbackActionsReady}\n      />\n      <p>\n        <button onClick={handleStartClick}>Start</button>\n        <button onClick={handleRestartClick}>Restart</button>\n        <button onClick={handleMuteClick}>Mute</button>\n        <button onClick={handleUnmuteClick}>Unmute</button>\n      </p>\n    </div>\n  )\n}",__scope:{props:this?this.props:a,Replay:g.a}},()=>{let e,A,a;return n.a.createElement("div",null,n.a.createElement(g.a,{source:{streamUrl:"public/example-media/progressive.mp4",startPosition:13},initialPlaybackProps:{isPaused:!0,isMuted:!0},onStreamStateChange:e=>{e&&("position"in e&&console.log("Stream observation example: Playback position is "+e.position.toFixed(1)),"volume"in e&&console.log("Stream observation example: Playback position is "+Math.round(100*e.volume)),e.isPaused&&console.log("Stream observation example: The playback was paused."),!1===e.isPaused&&console.log("Stream observation example: The playback was resumed."),"inactive"===e.playState&&console.log("Stream observation example: The playback has ended."))},onPlaybackActionsReady:({play:o,setPosition:n,setProperties:t})=>{e=o,A=n,a=t}}),n.a.createElement("p",null,n.a.createElement("button",{onClick:()=>{e&&e()}},"Start"),n.a.createElement("button",{onClick:()=>{A&&A(0)}},"Restart"),n.a.createElement("button",{onClick:()=>{a&&a({isMuted:!0})}},"Mute"),n.a.createElement("button",{onClick:()=>{a&&a({isMuted:!1})}},"Unmute")))}))}}B.__docgenInfo={description:"",methods:[],displayName:"MDXContent"}}}]);
//# sourceMappingURL=docs-using-replay-controlling-playback.37d2082b81987473d2f9.js.map