(window.webpackJsonp=window.webpackJsonp||[]).push([[38],{"./src/replay/docs/reference/observable-stream-state.mdx":function(e,a,t){"use strict";t.r(a),t.d(a,"default",(function(){return l}));var n=t("./node_modules/react/index.js"),r=t.n(n),o=t("./node_modules/@mdx-js/tag/dist/index.js");function m(e,a){if(null==e)return{};var t,n,r=function(e,a){if(null==e)return{};var t,n,r={},o=Object.keys(e);for(n=0;n<o.length;n++)t=o[n],a.indexOf(t)>=0||(r[t]=e[t]);return r}(e,a);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);for(n=0;n<o.length;n++)t=o[n],a.indexOf(t)>=0||Object.prototype.propertyIsEnumerable.call(e,t)&&(r[t]=e[t])}return r}class l extends r.a.Component{constructor(e){super(e),this.layout=null}render(){const e=this.props,a=e.components;m(e,["components"]);return r.a.createElement(o.MDXTag,{name:"wrapper",components:a},r.a.createElement(o.MDXTag,{name:"h1",components:a,props:{id:"stream-state-properties-reference"}},"Stream state properties reference"),r.a.createElement(o.MDXTag,{name:"p",components:a},"The set of video stream state properties is a React-friendly way of expressing anything happening during playback, and the current state of all aspects of the playback or open stream."),r.a.createElement(o.MDXTag,{name:"p",components:a},"Programmatically, state changes for any individual property can be observed. The current state for all properties can further be retrieved."),r.a.createElement(o.MDXTag,{name:"p",components:a},"State updates are reported only one property at a time. When getting the current state, a few or most of the properties will be present in the returned object. It is not guaranteed that a property is ever updated with a value during playback of a video source."),r.a.createElement(o.MDXTag,{name:"p",components:a},"When writing React code consuming properties of the current playback, working reactively with the stream state is most convenient. This means being notified of state changes outside Replay (or in a custom Replay user interface)."),r.a.createElement(o.MDXTag,{name:"p",components:a},"In some other cases, when reacting on other events (like button presses), it might be better retrieving the current state of a property."),r.a.createElement(o.MDXTag,{name:"p",components:a},"For Replay component users, the current state can be fetched through the ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"p"},"inspect()")," ",r.a.createElement(o.MDXTag,{name:"a",components:a,parentName:"p",props:{href:"/replay/api#methods-available-through-onplaybackactionsready"}},"method"),". Observing stream state changes is done through a ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"p"},"onStreamStateChange")," ",r.a.createElement(o.MDXTag,{name:"a",components:a,parentName:"p",props:{href:"/replay/api#callback-props"}},"callback prop"),"."),r.a.createElement(o.MDXTag,{name:"p",components:a},"The set of state properties are defined with these types:"),r.a.createElement(o.MDXTag,{name:"pre",components:a},r.a.createElement(o.MDXTag,{name:"code",components:a,parentName:"pre",props:{}},"type VideoStreamState = {\n  isPaused?: boolean,\n  isBuffering?: boolean,\n  isSeeking?: boolean,\n  position?: number,\n  duration?: number,\n  absolutePosition?: Date,\n  absoluteStartPosition?: Date,\n  isAtLiveEdge?: boolean,\n  playState?: 'inactive' | 'starting' | 'playing' | 'paused' | 'seeking' | 'buffering',\n  playMode?: 'ondemand' | 'live' | 'livedvr',\n  volume?: number,\n  isMuted?: boolean,\n  isPipAvailable?: boolean,\n  isPipActive?: boolean,\n  isAirPlayAvailable?: boolean,\n  isAirPlayActive?: boolean,\n  bufferedAhead?: number,\n  currentBitrate?: number,\n  bitrateFix?: ?number,\n  bitrateCap?: ?number,\n  bitrates?: Array<number>,\n  currentTextTrack?: ?AvailableTrack,\n  textTracks?: Array<AvailableTrack>,\n  currentAudioTrack?: ?AvailableTrack,\n  audioTracks?: Array<AvailableTrack>,\n  error?: any\n};\n")),r.a.createElement(o.MDXTag,{name:"table",components:a},r.a.createElement(o.MDXTag,{name:"thead",components:a,parentName:"table"},r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"thead"},r.a.createElement(o.MDXTag,{name:"th",components:a,parentName:"tr",props:{align:null}},"Property"),r.a.createElement(o.MDXTag,{name:"th",components:a,parentName:"tr",props:{align:null}},"Description"))),r.a.createElement(o.MDXTag,{name:"tbody",components:a,parentName:"table"},r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"isPaused"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"true")," if playback is paused, otherwise ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"false"),".")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"isBuffering"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"true")," if playback is stalled or starting, and buffering video data is ongoing. Otherwise ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"false"),".")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"isSeeking"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"true")," if a seeking (position change) operation is ongoing, otherwise ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"false"),".")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"position"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"The current playback position, reported as a number offset from the earliest stream position. This also applies to live DVR streams, where a position \u2248 duration means playing at the live edge.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"duration"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"The duration of a stream. Also applies to live DVR streams, expressing the length of the timeshift window.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"absolutePosition"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"A timestamp (clock time) for the current playback position. Relevant for live streams.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"absoluteStartPosition"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"A timestamp for the earliest available playback position in a live DVR stream. When playing at the live edge, absouteStartPosition + duration \u2248 absolutePosition.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"isAtLiveEdge"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"false")," if playback is timeshifted, otherwise true. Only relevant for live streams.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"playState"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"A one-dimensional way of expressing the different states of playback. One-dimensional means that it doesn't cover more than one state concurrently being active. For instance can ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"'buffering'")," and ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"'seeking'")," overlap. For full control over individual buffering, seeking, and paused states, see the corresponding boolean properties above.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"playMode"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"Indicates if the stream is on demand, live, or live with a DVR window.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"volume"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"A value between 0 and 1 representing the current volume setting.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"isMuted"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"true")," if playback audio is muted, otherwise ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"false"),".")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"isPipAvailable"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"true")," if there is a picture-in-picture feature available for the video playback, otherwise ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"false"),".")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"isPipActive"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"true")," if the browser's picture-in-picture mode is activated for the video, otherwise ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"false"),".")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"isAirPlayAvailable"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"true")," if Apple's AirPlay feature available for the video playback, otherwise ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"false"),".")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"isAirPlayActive"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"true")," if the video is playing on an AirPlay device, otherwise ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"false"),". AirPlay is only available in Apple Safari.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"bufferedAhead"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"The number of seconds ahead of the playback position being present in the video buffer.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"currentBitrate"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"Only relevant for adaptive streams. Expresses the currently selected bitrate in kpbs.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"bitrateFix"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"A currently fixed bitrate in kbps, if set. This means adaptive bitrate switching is deactivated.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"bitrateCap"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"A currently set cap on adpative bitrate selection, if set.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"currentTextTrack"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"If null, no text tracks are selected for display. Otherwise reports the currently displaying subtitles track. This object will be identical to one of the object in the ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"textTracks")," array. The object shape is described as ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"AvailableTrack")," underneath.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"textTracks"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"An array of subtitle tracks available for display. The object shape is described as ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"AvailableTrack")," underneath. Items in this array can represent both side-loaded subtitle files, and text tracks embedded in the stream.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"currentAudioTrack"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"Reports the currently audible track, if more than one audio track is available. This object will be identical to one of the object in the ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"audioTracks")," array. The object shape is described as ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"AvailableTrack")," underneath.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"audioTracks"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"An array of audio tracks available for selection. Typically corresponds to different language options. If only one audio track is available, this array might be empty. The object shape is described as ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"AvailableTrack")," underneath.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"error"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"An error object exposed by the underlying video streamer technology, if any errors have occurred.")))),r.a.createElement(o.MDXTag,{name:"p",components:a},"The ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"p"},"AvailableTrack")," objects are found in the state property arrays for audio tracks and text tracks. Note that it is different compared to the ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"p"},"SourceTrack")," type used when specifying side-loaded subtitle files."),r.a.createElement(o.MDXTag,{name:"pre",components:a},r.a.createElement(o.MDXTag,{name:"code",components:a,parentName:"pre",props:{}},"type AvailableTrack = {\n  kind?: string,\n  label?: string,\n  language?: string,\n  origin?: 'side-loaded' | 'in-stream',\n  id?: string | number\n};\n")),r.a.createElement(o.MDXTag,{name:"table",components:a},r.a.createElement(o.MDXTag,{name:"thead",components:a,parentName:"table"},r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"thead"},r.a.createElement(o.MDXTag,{name:"th",components:a,parentName:"tr",props:{align:null}},"Property"),r.a.createElement(o.MDXTag,{name:"th",components:a,parentName:"tr",props:{align:null}},"Description"))),r.a.createElement(o.MDXTag,{name:"tbody",components:a,parentName:"table"},r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"kind"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"Corresponds to the HTML text track kind property, and is commonly either ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"'captions'")," or ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"'subtitles'"),".")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"label"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"A human friendly description of the subtitle track, if available.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"language"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"The language code of the subtitle file content.")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"origin"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"'in-stream'")," if the track is embedded in the stream, otherwise ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"'side-loaded'"),".")),r.a.createElement(o.MDXTag,{name:"tr",components:a,parentName:"tbody"},r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"id"),r.a.createElement(o.MDXTag,{name:"td",components:a,parentName:"tr",props:{align:null}},"An unique identifier, if available. Note that referring tracks uniquely should be done by referring the track objects reported in ",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"textTracks"),"/",r.a.createElement(o.MDXTag,{name:"inlineCode",components:a,parentName:"td"},"audioTracks"),".")))))}}l.__docgenInfo={description:"",methods:[],displayName:"MDXContent"}}}]);
//# sourceMappingURL=docs-reference-observable-stream-state.37d2082b81987473d2f9.js.map