(window.webpackJsonp=window.webpackJsonp||[]).push([[25],{"./src/replay/docs/advanced-playback/drm.mdx":function(e,t,n){"use strict";n.r(t),n.d(t,"default",(function(){return c}));var a=n("./node_modules/react/index.js"),o=n.n(a),r=n("./node_modules/@mdx-js/tag/dist/index.js");function s(e,t){if(null==e)return{};var n,a,o=function(e,t){if(null==e)return{};var n,a,o={},r=Object.keys(e);for(a=0;a<r.length;a++)n=r[a],t.indexOf(n)>=0||(o[n]=e[n]);return o}(e,t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);for(a=0;a<r.length;a++)n=r[a],t.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(e,n)&&(o[n]=e[n])}return o}class c extends o.a.Component{constructor(e){super(e),this.layout=null}render(){const e=this.props,t=e.components;s(e,["components"]);return o.a.createElement(r.MDXTag,{name:"wrapper",components:t},o.a.createElement(r.MDXTag,{name:"h1",components:t,props:{id:"drm"}},"DRM"),o.a.createElement(r.MDXTag,{name:"p",components:t},"Every browser only supports one DRM technology. Because of the closed/black-box security model of DRM, browsers' DRM support cannot be extended. There are three relevant technologies for the modern browsers: "),o.a.createElement(r.MDXTag,{name:"ul",components:t},o.a.createElement(r.MDXTag,{name:"li",components:t,parentName:"ul"},"FairPlay: Only in Safari and with HLS streams"),o.a.createElement(r.MDXTag,{name:"li",components:t,parentName:"ul"},"PlayReady: MS Edge on Windows and Internet Explorer"),o.a.createElement(r.MDXTag,{name:"li",components:t,parentName:"ul"},"Widevine: Chrome on all platforms, Firefox, Chromium-based Microsoft Edge on both Windows and MacOS")),o.a.createElement(r.MDXTag,{name:"p",components:t},"PlayReady and Widevine can typically be used with Shaka Player, and typically with MPEG-DASH, even if also HLS can be combined with these two DRM techs in Shaka Player."),o.a.createElement(r.MDXTag,{name:"p",components:t},"This means that for covering all modern browsers with DRM encrypted playback, the following DRM services and stream formats must be available for one single content title:"),o.a.createElement(r.MDXTag,{name:"ul",components:t},o.a.createElement(r.MDXTag,{name:"li",components:t,parentName:"ul"},"Acquisition URL for FairPlay license service, to be used with HLS streams encrypted for FairPlay."),o.a.createElement(r.MDXTag,{name:"li",components:t,parentName:"ul"},"Acquisition URLs for a Widevine license service and a PlayReady license service, to be used with MPEG-DASH streams with common encryption (CENC).")),o.a.createElement(r.MDXTag,{name:"p",components:t},"According to the current browser, Replay must receive a source object specifying at least a license acquisition URL for the compatible DRM service, along with an URL to a stream encrypted for this DRM technology."),o.a.createElement(r.MDXTag,{name:"p",components:t},"For the same content title, the source object could then look like this in the following browsers:"),o.a.createElement(r.MDXTag,{name:"p",components:t},"Firefox, Chrome, Chromium-based Microsoft Edge:"),o.a.createElement(r.MDXTag,{name:"pre",components:t},o.a.createElement(r.MDXTag,{name:"code",components:t,parentName:"pre",props:{className:"language-javascript"}},"const source = {\n  streamUrl: 'https://my-stream-cdn.net/my-content-title/stream.mpd',\n  contentType: 'application/dash+xml',\n  licenseUrl: 'https://my-license-service.com/widevine/license/my-content-title',\n  drmType: 'com.widevine.alpha'\n};\n")),o.a.createElement(r.MDXTag,{name:"p",components:t},"Microsoft Edge Legacy and Chromium-based Microsoft Edge (Windows):"),o.a.createElement(r.MDXTag,{name:"pre",components:t},o.a.createElement(r.MDXTag,{name:"code",components:t,parentName:"pre",props:{className:"language-javascript"}},"const source = {\n  streamUrl: 'https://my-stream-cdn.net/my-content-title/stream.mpd',\n  contentType: 'application/dash+xml',\n  licenseUrl: 'https://my-license-service.com/playready/license/my-content-title',\n  drmType: 'com.microsoft.playready'\n};\n")),o.a.createElement(r.MDXTag,{name:"p",components:t},"Since the Chromium-based Microsoft Edge browser supports both Widevine and PlayReady (in Windows), it is important to specify the ",o.a.createElement(r.MDXTag,{name:"inlineCode",components:t,parentName:"p"},"drmType")," of the license acquisition URL, unless the same can be used for both technologies."),o.a.createElement(r.MDXTag,{name:"p",components:t},"Currently, Replay doesn't support specifying license URLs for both DRM technologies in the same source object, so a browser detection must be performed in order to select the correct alternative to be included in the source object."),o.a.createElement(r.MDXTag,{name:"p",components:t},"Safari:"),o.a.createElement(r.MDXTag,{name:"pre",components:t},o.a.createElement(r.MDXTag,{name:"code",components:t,parentName:"pre",props:{className:"language-javascript"}},"const source = {\n  streamUrl: 'https://my-stream-cdn.net/my-content-title/stream.m3u8',\n  contentType: 'application/x-mpegurl',\n  licenseUrl: 'https://my-license-service.com/fairplay/license/my-content-title',\n  drmType: 'com.apple.fps.1_0',\n  licenseAcquisitionDetails: {\n    fairPlayCertificateUrl: 'https://my-license-service.com/fairplay/certificate'    \n  }\n};\n")),o.a.createElement(r.MDXTag,{name:"p",components:t},"Typically the ",o.a.createElement(r.MDXTag,{name:"inlineCode",components:t,parentName:"p"},"licenseAcquisitionDetails")," source object needs more details specified in order to complete the license acquisition, most commonly authorization headers or token headers to be passed in the license request."),o.a.createElement(r.MDXTag,{name:"h2",components:t,props:{id:"video-streamer-selection-with-drm-encrypted-streams"}},"Video streamer selection with DRM encrypted streams"),o.a.createElement(r.MDXTag,{name:"p",components:t},"The compound video streamer or Replay does not cover matching of DRM technology with browser and stream technology."),o.a.createElement(r.MDXTag,{name:"p",components:t},"When using Replay for DRM playback, the app inserting the player have the responsibility to pass the correct stream and DRM details as the source object to the Replay component. This typically involves detecting the browser, and then look up stream and DRM details from e.g. a REST API."),o.a.createElement(r.MDXTag,{name:"p",components:t},"When the stream content type is specified, as in the examples above, the CompoundVideoStreamer can be used for selecting the correct video streamer and third party library supporting the stream."),o.a.createElement(r.MDXTag,{name:"h2",components:t,props:{id:"specifying-further-license-acquisition-or-drm-details"}},"Specifying further license acquisition or DRM details"),o.a.createElement(r.MDXTag,{name:"h3",components:t,props:{id:"headers"}},"Headers"),o.a.createElement(r.MDXTag,{name:"p",components:t},"Headers can be added to the license acqusition request, if required. They are specified with header names/values as keys/values, like in this example:"),o.a.createElement(r.MDXTag,{name:"pre",components:t},o.a.createElement(r.MDXTag,{name:"code",components:t,parentName:"pre",props:{className:"language-javascript"}},"const source = {\n  streamUrl: 'https://my-stream-cdn.net/my-content-title/stream.mpd',\n  contentType: 'application/dash+xml',\n  licenseUrl: 'https://my-license-service.com/playready/license/my-content-title',\n  drmType: 'com.microsoft.playready',\n  licenseAcquisitionDetails: {\n    licenseRequestHeaders: {\n      Authorization: 'some-user-token',\n      'x-some-custom-header': 'some-value'\n    }    \n  }\n};\n")),o.a.createElement(r.MDXTag,{name:"h3",components:t,props:{id:"certificates"}},"Certificates"),o.a.createElement(r.MDXTag,{name:"p",components:t},"In order to complete a FairPlay license acquisition, a certificate URL must always be specified. For Widevine, a similar URL might be passed but is often not required. See the Safari example above for FairPlay, and the following for Widevine:"),o.a.createElement(r.MDXTag,{name:"pre",components:t},o.a.createElement(r.MDXTag,{name:"code",components:t,parentName:"pre",props:{className:"language-javascript"}},"const source = {\n  streamUrl: 'https://my-stream-cdn.net/my-content-title/stream.mpd',\n  contentType: 'application/dash+xml',\n  licenseUrl: 'https://my-license-service.com/widevine/license/my-content-title',\n  drmType: 'com.widevine.alpha',\n  licenseAcquisitionDetails: {\n    widevineServiceCertificateUrl: 'https://my-license-service.com/widevine/certificate'      \n  }\n};\n")),o.a.createElement(r.MDXTag,{name:"p",components:t},"If no ",o.a.createElement(r.MDXTag,{name:"inlineCode",components:t,parentName:"p"},"widevineServiceCertificateUrl")," is specified, the Widevine CDM reuses the license acquisition URL for fetching the service certificate."),o.a.createElement(r.MDXTag,{name:"p",components:t},"The certificate URLs can also be specified as part of Replay's configuration."),o.a.createElement(r.MDXTag,{name:"h3",components:t,props:{id:"fairplay-request-formats-and-content-ids"}},"FairPlay request formats and content IDs"),o.a.createElement(r.MDXTag,{name:"p",components:t},"The FairPlay license acquisition client in the ",o.a.createElement(r.MDXTag,{name:"inlineCode",components:t,parentName:"p"},"HtmlVideoStreamer")," supports three request formats: ",o.a.createElement(r.MDXTag,{name:"inlineCode",components:t,parentName:"p"},"'base64'")," (legacy), ",o.a.createElement(r.MDXTag,{name:"inlineCode",components:t,parentName:"p"},"'binary'"),", and ",o.a.createElement(r.MDXTag,{name:"inlineCode",components:t,parentName:"p"},"'formdata'")," (default). Different services expect different data and formats, and these three types adapt to some tested real-world services."),o.a.createElement(r.MDXTag,{name:"p",components:t},"FairPlay's concept of content ID or asset ID can either be specified directly in the ",o.a.createElement(r.MDXTag,{name:"inlineCode",components:t,parentName:"p"},"contentId")," property, or be extracted from the ",o.a.createElement(r.MDXTag,{name:"inlineCode",components:t,parentName:"p"},"skd://")," url. "),o.a.createElement(r.MDXTag,{name:"p",components:t},"If ",o.a.createElement(r.MDXTag,{name:"inlineCode",components:t,parentName:"p"},"contentIdExtractMatch")," contains a regex (either regex object or string), what's matching in the skd url will be passed as the content ID in the license request. The commented out example underneath passes the full URL."),o.a.createElement(r.MDXTag,{name:"pre",components:t},o.a.createElement(r.MDXTag,{name:"code",components:t,parentName:"pre",props:{className:"language-javascript"}},"const source = {\n  streamUrl: 'https://my-stream-cdn.net/my-content-title/stream.m3u8',\n  contentType: 'application/x-mpegurl',\n  licenseUrl: 'https://my-license-service.com/fairplay/license/my-content-title',\n  drmType: 'com.apple.fps.1_0',\n  licenseAcquisitionDetails: {\n    fairPlayCertificateUrl: 'https://my-license-service.com/fairplay/certificate',\n    contentId: 'my-content-id', // Either specify the content ID, or how to extract it:\n    // contentIdExtractMatch: /(.*)/\n    fairPlayRequestFormat: 'base64' \n  }\n};\n")),o.a.createElement(r.MDXTag,{name:"p",components:t},"The ",o.a.createElement(r.MDXTag,{name:"inlineCode",components:t,parentName:"p"},"contentIdExtractMatch")," rule and FairPlay request format can also be specified as part of Replay's configuration."))}}c.__docgenInfo={description:"",methods:[],displayName:"MDXContent"}}}]);
//# sourceMappingURL=docs-advanced-playback-drm.37d2082b81987473d2f9.js.map