"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFullscreenElement = getFullscreenElement;
exports.enterFullscreen = enterFullscreen;
exports.exitFullscreen = exitFullscreen;
exports.notifyFullscreenChange = notifyFullscreenChange;

function getFullscreenElement() {
  // Ridiculous camel casing confusion ruling the Interwebs.
  return document.fullScreenElement || document.fullscreenElement || document.webkitFullscreenElement || document.webkitFullScreenElement || document.mozFullScreenElement || document.msFullscreenElement;
}

function enterFullscreen(element) {
  if (element.requestFullscreen) {
    element.requestFullscreen();
    return true;
  } else if (element.mozRequestFullScreen) {
    element.mozRequestFullScreen();
    return true;
  } else if (element.msRequestFullscreen) {
    element.msRequestFullscreen();
    return true;
  } else if (element.webkitRequestFullscreen) {
    element.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
    return true;
  } else if (element.webkitRequestFullScreen) {
    element.webkitRequestFullScreen(); // ALLOW_KEY_BOARD_INPUT makes this function not work in older Safari versions.

    return true;
  } else {
    // Try native fullscreen for video element in Safari on iPhone and older iOS in general.
    if (navigator.userAgent.match(/(iPad|iPhone|iPod)/i)) {
      element = element.getElementsByTagName('video')[0];

      if (element) {
        element.webkitEnterFullscreen();
        return true;
      }
    }
  }

  return false;
}

function exitFullscreen() {
  if (document.exitFullscreen) {
    document.exitFullscreen();
  } else if (document.mozCancelFullScreen) {
    document.mozCancelFullScreen();
  } else if (document.webkitExitFullscreen) {
    document.webkitExitFullscreen();
  } else if (document.webkitExitFullScreen) {
    document.webkitExitFullScreen();
  } else if (document.msExitFullscreen) {
    document.msExitFullscreen();
  }
}

function notifyFullscreenChange(handler) {
  const fullscreenEventNames = ['fullscreenchange', 'mozfullscreenchange', 'webkitfullscreenchange', 'MSFullscreenChange'];
  fullscreenEventNames.forEach(function (eventName) {
    document.addEventListener(eventName, handler);
  });
  return function () {
    fullscreenEventNames.forEach(function (eventName) {
      document.removeEventListener(eventName, handler);
    });
  };
}
//# sourceMappingURL=crossBrowserFullscreen.js.map