"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var React = _interopRequireWildcard(require("react"));

var _common = require("../../common");

var _memoizeOne = _interopRequireDefault(require("memoize-one"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const outerStyle = {
  position: 'relative',
  maxHeight: '100vh'
};
const helperStyle = {
  display: 'block',
  width: '100%',
  paddingTop: '56.25%',
  pointerEvents: 'none'
};
const getHelperStyle = (0, _memoizeOne.default)(aspectRatio => aspectRatio ? _objectSpread({}, helperStyle, {
  paddingTop: (aspectRatio.vertical * 100 / aspectRatio.horizontal).toFixed(2) + '%'
}) : helperStyle);

const AspectRatio = ({
  aspectRatio,
  render,
  rootClassName = '',
  aspectFixClassName,
  classNamePrefix = _common.defaultClassNamePrefix
}) => {
  if (aspectFixClassName) {
    return /*#__PURE__*/React.createElement("div", {
      className: "".concat(rootClassName, " ").concat((0, _common.prefixClassNames)(classNamePrefix, aspectFixClassName))
    }, render());
  } else {
    const beforeStyle = getHelperStyle(aspectRatio);
    return /*#__PURE__*/React.createElement("div", {
      className: rootClassName,
      style: outerStyle
    }, /*#__PURE__*/React.createElement("div", {
      style: beforeStyle
    }), render());
  }
};

var _default = AspectRatio;
exports.default = _default;
//# sourceMappingURL=AspectRatio.js.map