'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _FactoryMaker=require('../../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _Debug=require('../../core/Debug');var _Debug2=_interopRequireDefault(_Debug);var _Constants=require('../constants/Constants');var _Constants2=_interopRequireDefault(_Constants);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}function CapabilitiesFilter(){var context=this.context;var instance=void 0,adapter=void 0,capabilities=void 0,settings=void 0,logger=void 0,customCapabilitiesFilters=void 0;function setup(){logger=(0,_Debug2.default)(context).getInstance().getLogger(instance);}function setConfig(config){if(!config){return;}if(config.adapter){adapter=config.adapter;}if(config.capabilities){capabilities=config.capabilities;}if(config.settings){settings=config.settings;}}function filterUnsupportedFeaturesOfPeriod(streamInfo){_filterUnsupportedCodecs(_Constants2.default.VIDEO,streamInfo);_filterUnsupportedCodecs(_Constants2.default.AUDIO,streamInfo);if(settings.get().streaming.filterUnsupportedEssentialProperties){_filterUnsupportedEssentialProperties(streamInfo);}_applyCustomFilters(streamInfo);}function _filterUnsupportedCodecs(type,streamInfo){var realPeriod=adapter.getRealPeriodByIndex(streamInfo?streamInfo.index:null);if(!realPeriod||!realPeriod.AdaptationSet_asArray||realPeriod.AdaptationSet_asArray.length===0){return;}realPeriod.AdaptationSet_asArray=realPeriod.AdaptationSet_asArray.filter(function(as){if(!as.Representation_asArray||as.Representation_asArray.length===0||!adapter.getIsTypeOf(as,type)){return true;}as.Representation_asArray=as.Representation_asArray.filter(function(_,i){var codec=adapter.getCodec(as,i,true);if(!capabilities.supportsCodec(codec)){logger.error('[Stream] codec not supported: '+codec);return false;}return true;});return as.Representation_asArray&&as.Representation_asArray.length>0;});}function _filterUnsupportedEssentialProperties(streamInfo){var realPeriod=adapter.getRealPeriodByIndex(streamInfo?streamInfo.index:null);if(!realPeriod||!realPeriod.AdaptationSet_asArray||realPeriod.AdaptationSet_asArray.length===0){return;}realPeriod.AdaptationSet_asArray=realPeriod.AdaptationSet_asArray.filter(function(as){if(!as.Representation_asArray||as.Representation_asArray.length===0){return true;}as.Representation_asArray=as.Representation_asArray.filter(function(rep){var essentialProperties=adapter.getEssentialPropertiesForRepresentation(rep);if(essentialProperties&&essentialProperties.length>0){var i=0;while(i<essentialProperties.length){if(!capabilities.supportsEssentialProperty(essentialProperties[i])){logger.debug('[Stream] EssentialProperty not supported: '+essentialProperties[i].schemeIdUri);return false;}i+=1;}}return true;});return as.Representation_asArray&&as.Representation_asArray.length>0;});}function _applyCustomFilters(streamInfo){if(!customCapabilitiesFilters||customCapabilitiesFilters.length===0)return;var realPeriod=adapter.getRealPeriodByIndex(streamInfo?streamInfo.index:null);if(!realPeriod||!realPeriod.AdaptationSet_asArray||realPeriod.AdaptationSet_asArray.length===0){return;}realPeriod.AdaptationSet_asArray=realPeriod.AdaptationSet_asArray.filter(function(as){if(!as.Representation_asArray||as.Representation_asArray.length===0){return true;}as.Representation_asArray=as.Representation_asArray.filter(function(representation){return!customCapabilitiesFilters.some(function(customFilter){return!customFilter(representation);});});return as.Representation_asArray&&as.Representation_asArray.length>0;});}function setCustomCapabilitiesFilters(customFilters){customCapabilitiesFilters=customFilters;}instance={setConfig:setConfig,filterUnsupportedFeaturesOfPeriod:filterUnsupportedFeaturesOfPeriod,setCustomCapabilitiesFilters:setCustomCapabilitiesFilters};setup();return instance;}CapabilitiesFilter.__dashjs_factory_name='CapabilitiesFilter';exports.default=_FactoryMaker2.default.getSingletonFactory(CapabilitiesFilter);
//# sourceMappingURL=CapabilitiesFilter.js.map
