'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _ThroughputRule=require('./ThroughputRule');var _ThroughputRule2=_interopRequireDefault(_ThroughputRule);var _InsufficientBufferRule=require('./InsufficientBufferRule');var _InsufficientBufferRule2=_interopRequireDefault(_InsufficientBufferRule);var _AbandonRequestsRule=require('./AbandonRequestsRule');var _AbandonRequestsRule2=_interopRequireDefault(_AbandonRequestsRule);var _DroppedFramesRule=require('./DroppedFramesRule');var _DroppedFramesRule2=_interopRequireDefault(_DroppedFramesRule);var _SwitchHistoryRule=require('./SwitchHistoryRule');var _SwitchHistoryRule2=_interopRequireDefault(_SwitchHistoryRule);var _BolaRule=require('./BolaRule');var _BolaRule2=_interopRequireDefault(_BolaRule);var _L2ARule=require('./L2ARule.js');var _L2ARule2=_interopRequireDefault(_L2ARule);var _LoLpRule=require('./lolp/LoLpRule.js');var _LoLpRule2=_interopRequireDefault(_LoLpRule);var _FactoryMaker=require('../../../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _SwitchRequest=require('../SwitchRequest');var _SwitchRequest2=_interopRequireDefault(_SwitchRequest);var _Constants=require('../../constants/Constants');var _Constants2=_interopRequireDefault(_Constants);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}var QUALITY_SWITCH_RULES='qualitySwitchRules';/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */var ABANDON_FRAGMENT_RULES='abandonFragmentRules';function ABRRulesCollection(config){config=config||{};var context=this.context;var mediaPlayerModel=config.mediaPlayerModel;var dashMetrics=config.dashMetrics;var settings=config.settings;var instance=void 0,qualitySwitchRules=void 0,abandonFragmentRules=void 0;function initialize(){qualitySwitchRules=[];abandonFragmentRules=[];if(settings.get().streaming.abr.useDefaultABRRules){// If L2A is used we only need this one rule
if(settings.get().streaming.abr.ABRStrategy===_Constants2.default.ABR_STRATEGY_L2A){qualitySwitchRules.push((0,_L2ARule2.default)(context).create({dashMetrics:dashMetrics,mediaPlayerModel:mediaPlayerModel,settings:settings}));}// If LoLP is used we only need this one rule
else if(settings.get().streaming.abr.ABRStrategy===_Constants2.default.ABR_STRATEGY_LoLP){qualitySwitchRules.push((0,_LoLpRule2.default)(context).create({dashMetrics:dashMetrics}));}else{// Only one of BolaRule and ThroughputRule will give a switchRequest.quality !== SwitchRequest.NO_CHANGE.
// This is controlled by useBufferOccupancyABR mechanism in AbrController.
qualitySwitchRules.push((0,_BolaRule2.default)(context).create({dashMetrics:dashMetrics,mediaPlayerModel:mediaPlayerModel,settings:settings}));qualitySwitchRules.push((0,_ThroughputRule2.default)(context).create({dashMetrics:dashMetrics}));qualitySwitchRules.push((0,_InsufficientBufferRule2.default)(context).create({dashMetrics:dashMetrics}));qualitySwitchRules.push((0,_SwitchHistoryRule2.default)(context).create());qualitySwitchRules.push((0,_DroppedFramesRule2.default)(context).create());abandonFragmentRules.push((0,_AbandonRequestsRule2.default)(context).create({dashMetrics:dashMetrics,mediaPlayerModel:mediaPlayerModel,settings:settings}));}}// add custom ABR rules if any
var customRules=mediaPlayerModel.getABRCustomRules();customRules.forEach(function(rule){if(rule.type===QUALITY_SWITCH_RULES){qualitySwitchRules.push(rule.rule(context).create());}if(rule.type===ABANDON_FRAGMENT_RULES){abandonFragmentRules.push(rule.rule(context).create());}});}function getActiveRules(srArray){return srArray.filter(function(sr){return sr.quality>_SwitchRequest2.default.NO_CHANGE;});}/**
     *
     * @param {array} srArray
     * @return {object} SwitchRequest
     */function getMinSwitchRequest(srArray){var values={};var newSwitchReq=null;var i=void 0,len=void 0,req=void 0,quality=void 0,reason=void 0;if(srArray.length===0){return;}values[_SwitchRequest2.default.PRIORITY.STRONG]={quality:_SwitchRequest2.default.NO_CHANGE,reason:null};values[_SwitchRequest2.default.PRIORITY.WEAK]={quality:_SwitchRequest2.default.NO_CHANGE,reason:null};values[_SwitchRequest2.default.PRIORITY.DEFAULT]={quality:_SwitchRequest2.default.NO_CHANGE,reason:null};for(i=0,len=srArray.length;i<len;i+=1){req=srArray[i];if(req.quality!==_SwitchRequest2.default.NO_CHANGE){// We only use the new quality in case it is lower than the already saved one or if no new quality has been selected for the respective priority
if(values[req.priority].quality===_SwitchRequest2.default.NO_CHANGE||values[req.priority].quality>req.quality){values[req.priority].quality=req.quality;values[req.priority].reason=req.reason||null;}}}if(values[_SwitchRequest2.default.PRIORITY.WEAK].quality!==_SwitchRequest2.default.NO_CHANGE){newSwitchReq=values[_SwitchRequest2.default.PRIORITY.WEAK];}if(values[_SwitchRequest2.default.PRIORITY.DEFAULT].quality!==_SwitchRequest2.default.NO_CHANGE){newSwitchReq=values[_SwitchRequest2.default.PRIORITY.DEFAULT];}if(values[_SwitchRequest2.default.PRIORITY.STRONG].quality!==_SwitchRequest2.default.NO_CHANGE){newSwitchReq=values[_SwitchRequest2.default.PRIORITY.STRONG];}if(newSwitchReq){quality=newSwitchReq.quality;reason=newSwitchReq.reason;}return(0,_SwitchRequest2.default)(context).create(quality,reason);}function getMaxQuality(rulesContext){var switchRequestArray=qualitySwitchRules.map(function(rule){return rule.getMaxIndex(rulesContext);});var activeRules=getActiveRules(switchRequestArray);var maxQuality=getMinSwitchRequest(activeRules);return maxQuality||(0,_SwitchRequest2.default)(context).create();}function shouldAbandonFragment(rulesContext){var abandonRequestArray=abandonFragmentRules.map(function(rule){return rule.shouldAbandon(rulesContext);});var activeRules=getActiveRules(abandonRequestArray);var shouldAbandon=getMinSwitchRequest(activeRules);return shouldAbandon||(0,_SwitchRequest2.default)(context).create();}function reset(){[qualitySwitchRules,abandonFragmentRules].forEach(function(rules){if(rules&&rules.length){rules.forEach(function(rule){return rule.reset&&rule.reset();});}});qualitySwitchRules=[];abandonFragmentRules=[];}function getQualitySwitchRules(){return qualitySwitchRules;}instance={initialize:initialize,reset:reset,getMaxQuality:getMaxQuality,getMinSwitchRequest:getMinSwitchRequest,shouldAbandonFragment:shouldAbandonFragment,getQualitySwitchRules:getQualitySwitchRules};return instance;}ABRRulesCollection.__dashjs_factory_name='ABRRulesCollection';var factory=_FactoryMaker2.default.getClassFactory(ABRRulesCollection);factory.QUALITY_SWITCH_RULES=QUALITY_SWITCH_RULES;factory.ABANDON_FRAGMENT_RULES=ABANDON_FRAGMENT_RULES;_FactoryMaker2.default.updateSingletonFactory(ABRRulesCollection.__dashjs_factory_name,factory);exports.default=factory;
//# sourceMappingURL=ABRRulesCollection.js.map
