'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _XHRLoader=require('./XHRLoader');var _XHRLoader2=_interopRequireDefault(_XHRLoader);var _FetchLoader=require('./FetchLoader');var _FetchLoader2=_interopRequireDefault(_FetchLoader);var _HTTPRequest=require('../vo/metrics/HTTPRequest');var _FactoryMaker=require('../../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _DashJSError=require('../vo/DashJSError');var _DashJSError2=_interopRequireDefault(_DashJSError);var _CmcdModel=require('../models/CmcdModel');var _CmcdModel2=_interopRequireDefault(_CmcdModel);var _Utils=require('../../core/Utils');var _Utils2=_interopRequireDefault(_Utils);var _Debug=require('../../core/Debug');var _Debug2=_interopRequireDefault(_Debug);var _EventBus=require('../../core/EventBus');var _EventBus2=_interopRequireDefault(_EventBus);var _Events=require('../../core/events/Events');var _Events2=_interopRequireDefault(_Events);var _Settings=require('../../core/Settings');var _Settings2=_interopRequireDefault(_Settings);var _Constants=require('../constants/Constants');var _Constants2=_interopRequireDefault(_Constants);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true});}else{obj[key]=value;}return obj;}/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *//**
 * @module HTTPLoader
 * @ignore
 * @description Manages download of resources via HTTP.
 * @param {Object} cfg - dependancies from parent
 */function HTTPLoader(cfg){cfg=cfg||{};var context=this.context;var errHandler=cfg.errHandler;var dashMetrics=cfg.dashMetrics;var mediaPlayerModel=cfg.mediaPlayerModel;var requestModifier=cfg.requestModifier;var boxParser=cfg.boxParser;var useFetch=cfg.useFetch||false;var errors=cfg.errors;var requestTimeout=cfg.requestTimeout||0;var eventBus=(0,_EventBus2.default)(context).getInstance();var settings=(0,_Settings2.default)(context).getInstance();var instance=void 0,requests=void 0,delayedRequests=void 0,retryRequests=void 0,downloadErrorToRequestTypeMap=void 0,cmcdModel=void 0,logger=void 0;function setup(){var _downloadErrorToReque;logger=(0,_Debug2.default)(context).getInstance().getLogger(instance);requests=[];delayedRequests=[];retryRequests=[];cmcdModel=(0,_CmcdModel2.default)(context).getInstance();downloadErrorToRequestTypeMap=(_downloadErrorToReque={},_defineProperty(_downloadErrorToReque,_HTTPRequest.HTTPRequest.MPD_TYPE,errors.DOWNLOAD_ERROR_ID_MANIFEST_CODE),_defineProperty(_downloadErrorToReque,_HTTPRequest.HTTPRequest.XLINK_EXPANSION_TYPE,errors.DOWNLOAD_ERROR_ID_XLINK_CODE),_defineProperty(_downloadErrorToReque,_HTTPRequest.HTTPRequest.INIT_SEGMENT_TYPE,errors.DOWNLOAD_ERROR_ID_INITIALIZATION_CODE),_defineProperty(_downloadErrorToReque,_HTTPRequest.HTTPRequest.MEDIA_SEGMENT_TYPE,errors.DOWNLOAD_ERROR_ID_CONTENT_CODE),_defineProperty(_downloadErrorToReque,_HTTPRequest.HTTPRequest.INDEX_SEGMENT_TYPE,errors.DOWNLOAD_ERROR_ID_CONTENT_CODE),_defineProperty(_downloadErrorToReque,_HTTPRequest.HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE,errors.DOWNLOAD_ERROR_ID_CONTENT_CODE),_defineProperty(_downloadErrorToReque,_HTTPRequest.HTTPRequest.OTHER_TYPE,errors.DOWNLOAD_ERROR_ID_CONTENT_CODE),_downloadErrorToReque);}function internalLoad(config,remainingAttempts){var request=config.request;var traces=[];var firstProgress=true;var needFailureReport=true;var requestStartTime=new Date();var lastTraceTime=requestStartTime;var lastTraceReceivedCount=0;var httpRequest=void 0;if(!requestModifier||!dashMetrics||!errHandler){throw new Error('config object is not correct or missing');}var handleLoaded=function handleLoaded(success){needFailureReport=false;request.requestStartDate=requestStartTime;request.requestEndDate=new Date();request.firstByteDate=request.firstByteDate||requestStartTime;if(!request.checkExistenceOnly){dashMetrics.addHttpRequest(request,httpRequest.response?httpRequest.response.responseURL:null,httpRequest.response?httpRequest.response.status:null,httpRequest.response&&httpRequest.response.getAllResponseHeaders?httpRequest.response.getAllResponseHeaders():httpRequest.response?httpRequest.response.responseHeaders:[],success?traces:null);if(request.type===_HTTPRequest.HTTPRequest.MPD_TYPE){dashMetrics.addManifestUpdate(request);}}};var onloadend=function onloadend(){if(requests.indexOf(httpRequest)===-1){return;}else{requests.splice(requests.indexOf(httpRequest),1);}if(needFailureReport){handleLoaded(false);if(remainingAttempts>0){// If we get a 404 to a media segment we should check the client clock again and perform a UTC sync in the background.
try{if(settings.get().streaming.utcSynchronization.enableBackgroundSyncAfterSegmentDownloadError&&request.type===_HTTPRequest.HTTPRequest.MEDIA_SEGMENT_TYPE){// Only trigger a sync if the loading failed for the first time
var initialNumberOfAttempts=mediaPlayerModel.getRetryAttemptsForType(_HTTPRequest.HTTPRequest.MEDIA_SEGMENT_TYPE);if(initialNumberOfAttempts===remainingAttempts){eventBus.trigger(_Events2.default.ATTEMPT_BACKGROUND_SYNC);}}}catch(e){}remainingAttempts--;var retryRequest={config:config};retryRequests.push(retryRequest);retryRequest.timeout=setTimeout(function(){if(retryRequests.indexOf(retryRequest)===-1){return;}else{retryRequests.splice(retryRequests.indexOf(retryRequest),1);}internalLoad(config,remainingAttempts);},mediaPlayerModel.getRetryIntervalsForType(request.type));}else{if(request.type===_HTTPRequest.HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE){return;}errHandler.error(new _DashJSError2.default(downloadErrorToRequestTypeMap[request.type],request.url+' is not available',{request:request,response:httpRequest.response}));if(config.error){config.error(request,'error',httpRequest.response.statusText);}if(config.complete){config.complete(request,httpRequest.response.statusText);}}}};var progress=function progress(event){var currentTime=new Date();if(firstProgress){firstProgress=false;if(!event.lengthComputable||event.lengthComputable&&event.total!==event.loaded){request.firstByteDate=currentTime;}}if(event.lengthComputable){request.bytesLoaded=event.loaded;request.bytesTotal=event.total;}if(!event.noTrace){traces.push({s:lastTraceTime,d:event.time?event.time:currentTime.getTime()-lastTraceTime.getTime(),b:[event.loaded?event.loaded-lastTraceReceivedCount:0]});lastTraceTime=currentTime;lastTraceReceivedCount=event.loaded;}if(config.progress&&event){config.progress(event);}};var onload=function onload(){if(httpRequest.response.status>=200&&httpRequest.response.status<=299){handleLoaded(true);if(config.success){config.success(httpRequest.response.response,httpRequest.response.statusText,httpRequest.response.responseURL);}if(config.complete){config.complete(request,httpRequest.response.statusText);}}};var onabort=function onabort(){if(config.abort){config.abort(request);}};var ontimeout=function ontimeout(event){var timeoutMessage=void 0;if(event.lengthComputable){var percentageComplete=event.loaded/event.total*100;timeoutMessage='Request timeout: loaded: '+event.loaded+', out of: '+event.total+' : '+percentageComplete.toFixed(3)+'% Completed';}else{timeoutMessage='Request timeout: non-computable download size';}logger.warn(timeoutMessage);};var loader=void 0;if(useFetch&&window.fetch&&request.responseType==='arraybuffer'&&request.type===_HTTPRequest.HTTPRequest.MEDIA_SEGMENT_TYPE){loader=(0,_FetchLoader2.default)(context).create({requestModifier:requestModifier,boxParser:boxParser});}else{loader=(0,_XHRLoader2.default)(context).create({requestModifier:requestModifier});}var headers=null;var modifiedUrl=requestModifier.modifyRequestURL(request.url);if(settings.get().streaming.cmcd&&settings.get().streaming.cmcd.enabled){var cmcdMode=settings.get().streaming.cmcd.mode;if(cmcdMode===_Constants2.default.CMCD_MODE_QUERY){var additionalQueryParameter=_getAdditionalQueryParameter(request);modifiedUrl=_Utils2.default.addAditionalQueryParameterToUrl(modifiedUrl,additionalQueryParameter);}else if(cmcdMode===_Constants2.default.CMCD_MODE_HEADER){headers=cmcdModel.getHeaderParameters(request);}}var verb=request.checkExistenceOnly?_HTTPRequest.HTTPRequest.HEAD:_HTTPRequest.HTTPRequest.GET;var withCredentials=mediaPlayerModel.getXHRWithCredentialsForType(request.type);httpRequest={url:modifiedUrl,method:verb,withCredentials:withCredentials,request:request,onload:onload,onend:onloadend,onerror:onloadend,progress:progress,onabort:onabort,ontimeout:ontimeout,loader:loader,timeout:requestTimeout,headers:headers};// Adds the ability to delay single fragment loading time to control buffer.
var now=new Date().getTime();if(isNaN(request.delayLoadingTime)||now>=request.delayLoadingTime){// no delay - just send
requests.push(httpRequest);loader.load(httpRequest);}else{// delay
var delayedRequest={httpRequest:httpRequest};delayedRequests.push(delayedRequest);delayedRequest.delayTimeout=setTimeout(function(){if(delayedRequests.indexOf(delayedRequest)===-1){return;}else{delayedRequests.splice(delayedRequests.indexOf(delayedRequest),1);}try{requestStartTime=new Date();lastTraceTime=requestStartTime;requests.push(delayedRequest.httpRequest);loader.load(delayedRequest.httpRequest);}catch(e){delayedRequest.httpRequest.onerror();}},request.delayLoadingTime-now);}}function _getAdditionalQueryParameter(request){try{var additionalQueryParameter=[];var cmcdQueryParameter=cmcdModel.getQueryParameter(request);if(cmcdQueryParameter){additionalQueryParameter.push(cmcdQueryParameter);}return additionalQueryParameter;}catch(e){return[];}}/**
     * Initiates a download of the resource described by config.request
     * @param {Object} config - contains request (FragmentRequest or derived type), and callbacks
     * @memberof module:HTTPLoader
     * @instance
     */function load(config){if(config.request){internalLoad(config,mediaPlayerModel.getRetryAttemptsForType(config.request.type));}else{if(config.error){config.error(config.request,'error');}}}/**
     * Aborts any inflight downloads
     * @memberof module:HTTPLoader
     * @instance
     */function abort(){retryRequests.forEach(function(t){clearTimeout(t.timeout);// abort request in order to trigger LOADING_ABANDONED event
if(t.config.request&&t.config.abort){t.config.abort(t.config.request);}});retryRequests=[];delayedRequests.forEach(function(x){return clearTimeout(x.delayTimeout);});delayedRequests=[];requests.forEach(function(x){// MSS patch: ignore FragmentInfo requests
if(x.request.type===_HTTPRequest.HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE){return;}// abort will trigger onloadend which we don't want
// when deliberately aborting inflight requests -
// set them to undefined so they are not called
x.onloadend=x.onerror=x.onprogress=undefined;x.loader.abort(x);});requests=[];}instance={load:load,abort:abort};setup();return instance;}HTTPLoader.__dashjs_factory_name='HTTPLoader';var factory=_FactoryMaker2.default.getClassFactory(HTTPLoader);exports.default=factory;
//# sourceMappingURL=HTTPLoader.js.map
