'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _FactoryMaker=require('../../core/FactoryMaker');var _FactoryMaker2=_interopRequireDefault(_FactoryMaker);var _Debug=require('../../core/Debug');var _Debug2=_interopRequireDefault(_Debug);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */function MediaSourceController(){var instance=void 0,logger=void 0;var context=this.context;function setup(){logger=(0,_Debug2.default)(context).getInstance().getLogger(instance);}function createMediaSource(){var hasWebKit='WebKitMediaSource'in window;var hasMediaSource='MediaSource'in window;if(hasMediaSource){return new MediaSource();}else if(hasWebKit){return new WebKitMediaSource();}return null;}function attachMediaSource(source,videoModel){var objectURL=window.URL.createObjectURL(source);videoModel.setSource(objectURL);return objectURL;}function detachMediaSource(videoModel){videoModel.setSource(null);}function setDuration(source,value){if(!source||source.readyState!=='open')return;if(value===null&&isNaN(value))return;if(source.duration===value)return;if(!isBufferUpdating(source)){logger.info('Set MediaSource duration:'+value);source.duration=value;}else{setTimeout(setDuration.bind(null,source,value),50);}}function setSeekable(source,start,end){if(source&&typeof source.setLiveSeekableRange==='function'&&typeof source.clearLiveSeekableRange==='function'&&source.readyState==='open'&&start>=0&&start<end){source.clearLiveSeekableRange();source.setLiveSeekableRange(start,end);}}function signalEndOfStream(source){if(!source||source.readyState!=='open'){return;}var buffers=source.sourceBuffers;for(var i=0;i<buffers.length;i++){if(buffers[i].updating){return;}if(buffers[i].buffered.length===0){return;}}logger.info('call to mediaSource endOfStream');source.endOfStream();}function isBufferUpdating(source){var buffers=source.sourceBuffers;for(var i=0;i<buffers.length;i++){if(buffers[i].updating){return true;}}return false;}instance={createMediaSource:createMediaSource,attachMediaSource:attachMediaSource,detachMediaSource:detachMediaSource,setDuration:setDuration,setSeekable:setSeekable,signalEndOfStream:signalEndOfStream};setup();return instance;}MediaSourceController.__dashjs_factory_name='MediaSourceController';exports.default=_FactoryMaker2.default.getSingletonFactory(MediaSourceController);
//# sourceMappingURL=MediaSourceController.js.map
