'use strict';Object.defineProperty(exports,"__esModule",{value:true});var _DataChunk=require('../streaming/vo/DataChunk');var _DataChunk2=_interopRequireDefault(_DataChunk);var _FragmentRequest=require('../streaming/vo/FragmentRequest');var _FragmentRequest2=_interopRequireDefault(_FragmentRequest);var _MssFragmentInfoController=require('./MssFragmentInfoController');var _MssFragmentInfoController2=_interopRequireDefault(_MssFragmentInfoController);var _MssFragmentProcessor=require('./MssFragmentProcessor');var _MssFragmentProcessor2=_interopRequireDefault(_MssFragmentProcessor);var _MssParser=require('./parser/MssParser');var _MssParser2=_interopRequireDefault(_MssParser);var _MssErrors=require('./errors/MssErrors');var _MssErrors2=_interopRequireDefault(_MssErrors);var _DashJSError=require('../streaming/vo/DashJSError');var _DashJSError2=_interopRequireDefault(_DashJSError);var _InitCache=require('../streaming/utils/InitCache');var _InitCache2=_interopRequireDefault(_InitCache);var _HTTPRequest=require('../streaming/vo/metrics/HTTPRequest');function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}function MssHandler(config){config=config||{};var context=this.context;var eventBus=config.eventBus;var events=config.events;var constants=config.constants;var initSegmentType=config.initSegmentType;var dashMetrics=config.dashMetrics;var playbackController=config.playbackController;var streamController=config.streamController;var protectionController=config.protectionController;var mssFragmentProcessor=(0,_MssFragmentProcessor2.default)(context).create({dashMetrics:dashMetrics,playbackController:playbackController,protectionController:protectionController,streamController:streamController,eventBus:eventBus,constants:constants,ISOBoxer:config.ISOBoxer,debug:config.debug,errHandler:config.errHandler});var mssParser=void 0,fragmentInfoControllers=void 0,initCache=void 0,instance=void 0;function setup(){fragmentInfoControllers=[];initCache=(0,_InitCache2.default)(context).getInstance();}function getStreamProcessor(type){return streamController.getActiveStreamProcessors().filter(function(processor){return processor.getType()===type;})[0];}function getFragmentInfoController(type){return fragmentInfoControllers.filter(function(controller){return controller.getType()===type;})[0];}function createDataChunk(request,streamId,endFragment){var chunk=new _DataChunk2.default();chunk.streamId=streamId;chunk.mediaInfo=request.mediaInfo;chunk.segmentType=request.type;chunk.start=request.startTime;chunk.duration=request.duration;chunk.end=chunk.start+chunk.duration;chunk.index=request.index;chunk.quality=request.quality;chunk.representationId=request.representationId;chunk.endFragment=endFragment;return chunk;}function startFragmentInfoControllers(){// Create MssFragmentInfoControllers for each StreamProcessor of active stream (only for audio, video or fragmentedText)
var processors=streamController.getActiveStreamProcessors();processors.forEach(function(processor){if(processor.getType()===constants.VIDEO||processor.getType()===constants.AUDIO||processor.getType()===constants.FRAGMENTED_TEXT){var fragmentInfoController=getFragmentInfoController(processor.getType());if(!fragmentInfoController){fragmentInfoController=(0,_MssFragmentInfoController2.default)(context).create({streamProcessor:processor,baseURLController:config.baseURLController,debug:config.debug});fragmentInfoController.initialize();fragmentInfoControllers.push(fragmentInfoController);}fragmentInfoController.start();}});}function stopFragmentInfoControllers(){fragmentInfoControllers.forEach(function(c){c.reset();});fragmentInfoControllers=[];}function onInitFragmentNeeded(e){var streamProcessor=getStreamProcessor(e.mediaType);if(!streamProcessor)return;// Create init segment request
var representationController=streamProcessor.getRepresentationController();var representation=representationController.getCurrentRepresentation();var mediaInfo=streamProcessor.getMediaInfo();var request=new _FragmentRequest2.default();request.mediaType=representation.adaptation.type;request.type=initSegmentType;request.range=representation.range;request.quality=representation.index;request.mediaInfo=mediaInfo;request.representationId=representation.id;var chunk=createDataChunk(request,mediaInfo.streamInfo.id,e.type!==events.FRAGMENT_LOADING_PROGRESS);try{// Generate init segment (moov)
chunk.bytes=mssFragmentProcessor.generateMoov(representation);// Notify init segment has been loaded
eventBus.trigger(events.INIT_FRAGMENT_LOADED,{chunk:chunk},{streamId:mediaInfo.streamInfo.id,mediaType:representation.adaptation.type});}catch(e){config.errHandler.error(new _DashJSError2.default(e.code,e.message,e.data));}// Change the sender value to stop event to be propagated
e.sender=null;}function onSegmentMediaLoaded(e){if(e.error)return;var streamProcessor=getStreamProcessor(e.request.mediaType);if(!streamProcessor)return;// Process moof to transcode it from MSS to DASH (or to update segment timeline for SegmentInfo fragments)
mssFragmentProcessor.processFragment(e,streamProcessor);if(e.request.type===_HTTPRequest.HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE){// If FragmentInfo loaded, then notify corresponding MssFragmentInfoController
var fragmentInfoController=getFragmentInfoController(e.request.mediaType);if(fragmentInfoController){fragmentInfoController.fragmentInfoLoaded(e);}}// Start MssFragmentInfoControllers in case of start-over streams
var manifestInfo=e.request.mediaInfo.streamInfo.manifestInfo;if(!manifestInfo.isDynamic&&manifestInfo.DVRWindowSize!==Infinity){startFragmentInfoControllers();}}function onPlaybackPaused(){if(playbackController.getIsDynamic()&&playbackController.getTime()!==0){startFragmentInfoControllers();}}function onPlaybackSeekAsked(){if(playbackController.getIsDynamic()&&playbackController.getTime()!==0){startFragmentInfoControllers();}}function onTTMLPreProcess(ttmlSubtitles){if(!ttmlSubtitles||!ttmlSubtitles.data){return;}ttmlSubtitles.data=ttmlSubtitles.data.replace(/http:\/\/www.w3.org\/2006\/10\/ttaf1/gi,'http://www.w3.org/ns/ttml');}function registerEvents(){eventBus.on(events.INIT_FRAGMENT_NEEDED,onInitFragmentNeeded,instance,{priority:dashjs.FactoryMaker.getSingletonFactoryByName(eventBus.getClassName()).EVENT_PRIORITY_HIGH});/* jshint ignore:line */eventBus.on(events.PLAYBACK_PAUSED,onPlaybackPaused,instance,{priority:dashjs.FactoryMaker.getSingletonFactoryByName(eventBus.getClassName()).EVENT_PRIORITY_HIGH});/* jshint ignore:line */eventBus.on(events.PLAYBACK_SEEK_ASKED,onPlaybackSeekAsked,instance,{priority:dashjs.FactoryMaker.getSingletonFactoryByName(eventBus.getClassName()).EVENT_PRIORITY_HIGH});/* jshint ignore:line */eventBus.on(events.FRAGMENT_LOADING_COMPLETED,onSegmentMediaLoaded,instance,{priority:dashjs.FactoryMaker.getSingletonFactoryByName(eventBus.getClassName()).EVENT_PRIORITY_HIGH});/* jshint ignore:line */eventBus.on(events.TTML_TO_PARSE,onTTMLPreProcess,instance);}function reset(){if(mssParser){mssParser.reset();mssParser=undefined;}eventBus.off(events.INIT_FRAGMENT_NEEDED,onInitFragmentNeeded,this);eventBus.off(events.PLAYBACK_PAUSED,onPlaybackPaused,this);eventBus.off(events.PLAYBACK_SEEK_ASKED,onPlaybackSeekAsked,this);eventBus.off(events.FRAGMENT_LOADING_COMPLETED,onSegmentMediaLoaded,this);eventBus.off(events.TTML_TO_PARSE,onTTMLPreProcess,this);// Reset FragmentInfoControllers
stopFragmentInfoControllers();}function createMssParser(){mssParser=(0,_MssParser2.default)(context).create(config);return mssParser;}instance={reset:reset,createMssParser:createMssParser,registerEvents:registerEvents};setup();return instance;}/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */MssHandler.__dashjs_factory_name='MssHandler';var factory=dashjs.FactoryMaker.getClassFactory(MssHandler);/* jshint ignore:line */factory.errors=_MssErrors2.default;dashjs.FactoryMaker.updateClassFactory(MssHandler.__dashjs_factory_name,factory);/* jshint ignore:line */exports.default=factory;/* jshint ignore:line */
//# sourceMappingURL=MssHandler.js.map
