<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

require_once MAX_PATH . '/lib/OA/Admin/Menu/IChecker.php';

class Plugins_admin_HbInvocation_HBMenuChecker implements OA_Admin_Menu_IChecker
{
    /**
     * @param OA_Admin_Menu_Section $oSection
     */
    public function check($oSection) 
    {
        // this checker is called 6 times, not sure why, but we cache the lookup in a static variable
        static $cache = array();
        if(isset($cache[$oSection->getId()])) {
            return $cache[$oSection->getId()];
        }
        $enabled = false;
        require_once MAX_PATH . '/www/admin/plugins/HbInvocation/hb-invocation-settings.php';
        $vast = new HbInvocation;
        
        phpAds_registerGlobal( 'clientid', 'campaignid', 'bannerid', 'affiliateid', 'zoneid' );
        global $clientid, $campaignid, $bannerid, $zoneid, $affiliateid;
        
        switch($oSection->getId()) {
            
            case 'Hb-Invocation':
                if($vast->isAppWebsite((int)$affiliateid))
                {
                    $enabled = $vast->isZoneVast((int)$zoneid);
                }
                break;
            case 'Hb-BidderList':
                if($vast->isAppWebsite((int)$affiliateid))
                {
                    $enabled = $vast->isZoneVast((int)$zoneid);
                }
                break;
            case 'affiliate-headerbid':
                $enabled = $vast->isAppWebsite((int)$affiliateid);
                break;
           
        }
        $cache[$oSection->getId()] = $enabled;
        return $enabled;
    }
}