<?php
/*
+--------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/RV/Admin/Languages.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';
require_once MAX_PATH . '/lib/OA/Dll/Publisher.php';
require_once MAX_PATH . '/lib/OA/Session.php';
require_once MAX_PATH . '/lib/OA/Admin/Menu.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/OA/Auth.php';
require_once MAX_PATH . '/lib/OA/Admin/UI/UserAccess.php';

if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}elseif ($GLOBALS['_MAX']['CONF']['database']['type'] == 'pgsql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}elseif ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysqli') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER, OA_ACCOUNT_TRAFFICKER);
OA_Permission::enforceAccountPermission(OA_ACCOUNT_TRAFFICKER, OA_PERM_SUPER_ACCOUNT);
OA_Permission::enforceAccessToObject('affiliates', $affiliateid);


/*-------------------------------------------------------*/
/* Store preferences									 */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['affiliateid'] = $affiliateid;
phpAds_SessionDataStore();

/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/
$oHeaderModel = MAX_displayWebsiteBreadcrumbs($affiliateid);

phpAds_PageHeader("affiliate-headerbid", $oHeaderModel);
  

/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/
// Prepare an array for storing error messages
$aErrormessage = array();
$a='http://'.$GLOBALS['conf']['webpath']['admin'].'/';

$aConf = $GLOBALS['_MAX']['CONF'];	

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

?>
<html>
	<head>
		<script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
		<script src="//code.jquery.com/ui/1.11.1/jquery-ui.min.js"></script>

		<link rel="stylesheet" href="//code.jquery.com/ui/1.11.1/themes/smoothness/jquery-ui.css" />
        <style type="text/css">
			.navi {
			width: 500px;
			margin: 5px;
			padding:2px 5px;
			border:1px solid #eee;
			}
			
			.hasGradient #secondLevelContent{
				padding: 0 !important;
			}
			
			#secondLevelContent{
				max-height: 800px !important;
			}
			
			ul.setPaginate li.setPage{
			padding:15px 10px;
			font-size:14px;
			}

			ul.setPaginate{
			margin:0px;
			padding:0px;
			height:100px;
			overflow:hidden;
			font:12px 'Tahoma';
			list-style-type:none;	
			}  

			ul.setPaginate li.dot{padding: 3px 0;}

			ul.setPaginate li{
			float:left;
			margin:0px;
			padding:0px;
			margin-left:5px;
			display: inline;
			}

			.param{
				font-weight: bold;
			}

			ul.setPaginate li a
			{
			background: none repeat scroll 0 0 #ffffff;
			border: 1px solid #cccccc;
			color: #999999;
			display: inline-block;
			font: 15px/25px Arial,Helvetica,sans-serif;
			margin: 5px 3px 0 0;
			padding: 0 5px;
			text-align: center;
			text-decoration: none;
			}	

			ul.setPaginate li a:hover,
			ul.setPaginate li a.current_page
			{
			background: none repeat scroll 0 0 #0d92e1;
			border: 1px solid #000000;
			color: #ffffff;
			text-decoration: none;
			}

			ul.setPaginate li a{
			color:black;
			display:block;
			text-decoration:none;
			padding:5px 8px;
			text-decoration: none;
			}
			.ui-dialog{
				top: 150px !important;
				padding: 0px;
				left: 215px;
			}
			
			.slot{
				white-space: pre-wrap;
				text-indent: 20px;
				line-height: 20px;
				font-family: Verdana, Arial, Helvetica, sans-serif;
			}
			.ui-dialog-title{
				padding: 1px;
			}
			.ui-widget-header{
				border-radius: 0px;
			}
			#param-table td{
				padding: 2px 25px;
			}
			.ui-dialog-buttonpane{
				border: none;
			}
			.ui-button .ui-widget .ui-state-default{
				background: #0767a8!important;
				color: white!important;
			}
			/*.ui-icon-closethick{
				background: #ccc;
			}*/
		</style>   
	</head>
	<body>
		<!--add bidder param - start-->
		<div style="float:right;"><a  style="display: block;width: 132px;height: 10px;
			background: #0767a8;
			padding: 10px;
			text-align: center;
			border-radius: 5px;
			color:white;
			font-weight: bold;text-decoration:none;"  href="affiliate-headerbid-requestadd.php?affiliateid=<?php echo $affiliateid;?>">Request Bidder</a></div>

		<!--add bidder param - end-->
		<div style="clear:both;"></div>	

		<div class="tableWrapper">
		<div class="tableHeader">
			<ul class='tableActions'>
			  <li class='inactive activeIfSelected'>            
					 <a id='deleteSelection'  href="" class='inlineIcon disable'>Delete</a>                
					 <script type='text/javascript'>         
						$('#deleteSelection').click(function(event) {                    event.preventDefault();        var page='<?php echo $_GET['page'];?>'; 
								var accid = '<?php echo $affiliateid;?>';         
						if (!$(this).parents('li').hasClass('inactive')) {
							var ids = [];
							$(this).parents('.tableWrapper').find('.toggleSelection input:checked').each(function() {
								ids.push(this.value);
							});
							window.location = 'bid_action.php?action=pubdelete&page='+page+'&aid='+accid+'&bid=' + ids.join(',');
						}
						
						});
					</script>                
				        
				<li class='inactive activeIfSelected'>	
					  <a id='disableSelection' href="" >&nbsp;Block</a>    
					  <script type='text/javascript'>
							
						$('#disableSelection').click(function(event) {
							event.preventDefault();    
							var page='<?php echo $_GET['page'];?>';  
							var accid = '<?php echo $affiliateid;?>';              
							if (!$(this).parents('li').hasClass('inactive')) {
								var ids = [];
								$(this).parents('.tableWrapper').find('.toggleSelection input:checked').each(function() {
									ids.push(this.value);
								});
								window.location = 'bid_action.php?action=pubdisable&page='+page+'&aid='+accid+'&bid=' + ids.join(',');		                   
							}
						});
						</script>         	             
				</li>       
				
				 <li class='inactive activeIfSelected'>	
					   <a id='enableSelection' href="">&nbsp;Unblock</a> 
						<script type='text/javascript'>
						$('#enableSelection').click(function(event) {
							
							event.preventDefault();
							 var page='<?php echo $_GET['page'];?>';
							 var accid = '<?php echo $affiliateid;?>'; 
							if (!$(this).parents('li').hasClass('inactive')) {
								var ids = [];
								$(this).parents('.tableWrapper').find('.toggleSelection input:checked').each(function() {
									ids.push(this.value);
								});
								window.location = 'bid_action.php?action=pubenable&page='+page+'&aid='+accid+'&bid=' + ids.join(',');
						
															   
							}
						});                
						</script>          	             
				</li> 
				
				<li class=''>	
				   <div><img src="assets/images/adxactive.png" width="15px" height="15px">&nbsp;Active</div> 
					<!--script type='text/javascript'>
					$('#enableSelection').click(function(event) {
						event.preventDefault();
						if (!$(this).parents('li').hasClass('inactive')) {
							var ids = [];
							$(this).parents('.tableWrapper').find('.toggleSelection input:checked').each(function() {
								ids.push(this.value);
							});
							window.location = 'bid_action.php?action=enable&aid=' + ids.join(',');
					
														   
						}
					});                
					</script-->          	             
				</li>            
				<li class=''>	
				   <div><img src="assets/images/waiting.png" width="15px" height="15px">&nbsp;Require Bidder Details</div> 
					<!--script type='text/javascript'>
					$('#enableSelection').click(function(event) {
						event.preventDefault();
						if (!$(this).parents('li').hasClass('inactive')) {
							var ids = [];
							$(this).parents('.tableWrapper').find('.toggleSelection input:checked').each(function() {
								ids.push(this.value);
							});
							window.location = 'bid_action.php?action=enable&aid=' + ids.join(',');
					
														   
						}
					});                
					</script-->          	             
				</li>            
				<li class=''>	
				  <div><img src="assets/images/adxdeactive.png" width="15px" height="15px">&nbsp;InActive</div>    
				  <!--script type='text/javascript'>
						
					$('#disableSelection').click(function(event) {
						event.preventDefault();                   
						if (!$(this).parents('li').hasClass('inactive')) {
							var ids = [];
							$(this).parents('.tableWrapper').find('.toggleSelection input:checked').each(function() {
								ids.push(this.value);
							});
							window.location = 'bid_action.php?action=disable&aid=' + ids.join(',');		                   
						}
					});
					</script-->         	             
				</li>            
			</ul>
			<div class="clear"></div>
			<div class="corner left"></div>
			<div class="corner right"></div>
		</div>
		<form method="POST" id="parameter_list">
			<table cellspacing="0" id="paramlist" summary="">
				<thead>
					<tr>
					   <th class='first toggleAll' style="width:10%;">
						  <input type='checkbox' />
						</th>
						<th style="width:25%;">
						   <p class='inlineIcon iconAdx'>Bidder Name</p>
						</th>                
						 <th style="width:25%;">
							<p>Bidder Code</p>
						</th>                
						<th style="width:15%;">
							<p>Status</p>
						</th>                
					   <th style="width:25%;">
							<P>Action</P>
						</th>
						<th></th>
					</tr>
				</thead>
				<tbody>
<?php

	//pagination - start
				
		 if(isset($_GET["page"])){
			$page = (int)$_GET["page"]; 
		 }else{
			$page = 1;
		 }
		 $setLimit = 10;
		 $pageLimit = ($page * $setLimit) - $setLimit;
	//pagination - end
	
	$listbidder=OA_Dal_Delivery_query("SELECT hbr.is_approved,hbr.is_deleted,hbr.is_denied,hbr.bidder_id,hbl.hb_bidder_name,hbl.hb_bidder_code FROM {$table_prefix}djax_bidder_request as hbr join {$table_prefix}djax_hb_bidders_list as hbl ON hbl.hb_bidder_id = hbr.bidder_id where hbl.dj_is_deleted = '0' AND hbl.dj_is_denied='0' AND  hbr.is_admin_deleted=0 and hbr.is_admin_denied = 0 AND hbr.is_deleted = '0' AND hbr.publisher_id='".$affiliateid."' LIMIT $pageLimit,$setLimit");
	
	
	$i =1;
	
	//list bidder details
	if(OA_Dal_Delivery_numRows($listbidder)>0)
	{
	while($row1=OA_Dal_Delivery_fetchAssoc($listbidder))
	{
		$listbidderparam=OA_Dal_Delivery_query("SELECT pv.account_id,hp.hb_bidder_id,hp.hb_parameter_id,hp.hb_parameter_name,pv.param_value,pv.parameter_id,hs.hb_sub_parameter_id,hs.hb_sub_parameter_name,sp.sub_param_value, sp.hb_parameter_sub_value_id, hp.required as prequired,hs.srequired as srequired 
		from {$table_prefix}djax_hb_params as hp
		left join (SELECT * from {$table_prefix}djax_hb_param_value where account_id ='$affiliateid')as pv on pv.parameter_id = hp.hb_parameter_id 
		left join 
		(SELECT GROUP_CONCAT(hb_sub_parameter_id) as hb_sub_parameter_id ,GROUP_CONCAT(hb_sub_parameter_name) as hb_sub_parameter_name,GROUP_CONCAT(required) as srequired,hb_parameter_id from {$table_prefix}djax_hb_sub_param WHERE dj_is_deleted = 0 group by hb_parameter_id ) as hs on hs.hb_parameter_id = hp.hb_parameter_id
		left join (SELECT sub_para_id,GROUP_CONCAT(sub_param_value) as sub_param_value, GROUP_CONCAT(hb_parameter_sub_value_id) as hb_parameter_sub_value_id from  {$table_prefix}djax_hb_sub_param_value group by parameter_id) as sp on sp.sub_para_id = hs.hb_sub_parameter_id
		where hp.hb_bidder_id='".$row1['bidder_id']."'");
		
	if($i == 1) {

			$_class = "odd hilite";

		} elseif($i%2 == 0) {

			$_class = "even";

		} else {

			$_class = "odd";

		}

		//Before approve
	if(OA_Dal_Delivery_numRows($listbidderparam) == 0){
		?>
		
		<tr class="<?php echo $_class; ?>">
				<td class='toggleSelection'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					<input type='checkbox' value="<?php print_r($row1['bidder_id']);?>" />	      
				</td>
				<!--For biddder name-->
				<td>
					<p class='inlineIcon iconAdx'><?php print_r($row1['hb_bidder_name']); ?></p>	
				</td>
				
				<!--For biddder code-->
				<td>
					<?php print_r($row1['hb_bidder_code']); ?>
				</td>	
				<!--For biddder status-->
				<td>
					
					<?php
		
						if($row1['is_approved'] == 1 && $row1['is_denied'] == 0){
							
						?>	
							<a href="#" class='inlineIcon iconAdxdeactive'><img src="assets/images/adxactive.png" width="15px" height="15px"></a>
						<?php
						}elseif($row1['is_approved'] == 2 && $row1['is_denied'] == 0){
						?>
				
						<a href="#" class='inlineIcon iconAdxactive'><img src="assets/images/waiting.png" width="15px" height="15px"></a>
						
						<?php
						 }elseif($row1['is_denied'] == 1){
						
						?>						
							<a href="#" class='inlineIcon iconAdxactive'><img src="assets/images/adxdeactive.png" width="15px" height="15px"></a>
						<?php
						}	
						?>
				</td> 
				
				<!--For biddder action - start-->
				
				<td>		 						
					<a  href="bid_action.php?aid=<?php echo $affiliateid;?>&bid=<?php print_r($row1['bidder_id']);?>&action=pubdelete&bname=<?php print_r($row1['hb_bidder_name']);?>&page=<?php echo $_GET['page'];?>">Delete</a>						
				</td>
				<!--For biddder action - end-->	
				<td class="alignRight verticalActions">
					<ul class="rowActions"> <li></li></ul>
				</td>
			</tr>
	<?php	
	}else{
?>		
		<tr class="<?php echo $_class; ?>" <?php if($row1['is_denied']=='1'){ ?>style="background-color: #e4e4e4"<?php } ?>>
				<td class='toggleSelection'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					<input type='checkbox' value="<?php print_r($row1['bidder_id']);?>" />	        
				</td>
				<!--For biddder name-->
				<td>
					<p class='inlineIcon iconAdx'><?php print_r($row1['hb_bidder_name']); ?></p>	
				</td>
				
				<!--For biddder code-->
				<td>
					<?php print_r($row1['hb_bidder_code']); ?>
				</td>	
				<!--For biddder status-->
				<td>
					
					<?php
		
						if($row1['is_approved'] == 1 && $row1['is_denied'] == 0){
							
						?>	
							<a href="#" class='inlineIcon iconAdxdeactive'><img src="assets/images/adxactive.png" width="15px" height="15px"></a>
						<?php
						}elseif($row1['is_approved'] == 2 && $row1['is_denied'] == 0){
						?>
				
							<a href="#" class='inlineIcon iconAdxactive'><img src="assets/images/waiting.png" width="15px" height="15px"></a>
						
						<?php
						 }elseif($row1['is_denied'] == 1){
						
						?>						
							<a href="#" class='inlineIcon iconAdxactive'><img src="assets/images/adxdeactive.png" width="15px" height="15px"></a>
						<?php
						}	
						?>
				</td> 
				
				<!--For biddder action - start-->	
							
				<td style="width:25%;">		
					<?php if($row1['is_approved'] >= 1){ ?>
					<a href='#' class='review_param' id="bidder_<?php print_r($row1['bidder_id']);?>">Review</a>
					 &nbsp; / &nbsp;
					  <!--for pop-up menu - start-->
						<div class ='dialog' id="dialog_<?php print_r($row1['bidder_id']);?>" title="Parameters for <?php echo $row1['hb_bidder_name'];?>" hidden="hidden">
						<div>
							<table id="param-table">
	<?php 			while($row=OA_Dal_Delivery_fetchAssoc($listbidderparam)){
					$psreq = ($row['prequired']==1) ? "<span style='color:red;'>*</span>" : '';
		?>
							<tr>
								<td class="param">
									<?php echo $row['hb_parameter_name'];?> <?php echo $psreq;?> &nbsp;
								</td>
	<?php				if(!empty($row['hb_sub_parameter_id'])){ 
		
							$subparamid = explode(',',$row['hb_sub_parameter_id']);
							$subparamname = explode(',',$row['hb_sub_parameter_name']);
							$subparamvalue = explode(',',$row['sub_param_value']);
							$hb_parameter_sub_value_id = explode(',',$row['hb_parameter_sub_value_id']);
							$subparamreq = explode(',',$row['srequired']);
							echo "</tr>";
							
						foreach($subparamid as $sid => $sval){
							
							$ssreq = ($subparamid[$sid]==1) ? "<span style='color:red;'>*</span>" : '';
		
		?>
							<tr>
								<td>
									&nbsp;&nbsp;&nbsp;<?php echo $subparamname[$sid];?><?php echo $ssreq;?>&nbsp;
								</td>
								<td>
									<input type="text" is_required='<?=$row['srequired'];?>' class='subparamid_<?=$row['hb_bidder_id']?>' id='<?=$hb_parameter_sub_value_id[$sid]?>' value="<?php echo $subparamvalue[$sid];?>" <?php echo $sreq;?> >
								</td>
							</tr>
										
	<?php				}
						}else{ ?>
								<td>
									<input type="text" value='<?php echo $row['param_value'];?>' is_required='<?=$row['prequired'];?>' class='paramid_<?=$row['hb_bidder_id']?>' id='<?=$row['hb_parameter_id']?>' >
								</td>
							</tr>	
	<?php				}?>
									
							<?php
						} ?>
								</table>
							</div>
						</div>
					<!-- for pop up menu end-->
				<!-- Block and Unblock - bidder-->
					 <?php
					 if($row1['is_denied']=='0'){ ?>	
						<a  href="bid_action.php?aid=<?php echo $affiliateid;?>&bid=<?php print_r($row1['bidder_id']);?>&action=pubdisable&bname=<?php print_r($row1['hb_bidder_name']);?>&page=<?php echo $_GET['page'];?>">Block</a>
					<?php }else{ ?>
						<a  href="bid_action.php?aid=<?php echo $affiliateid;?>&bid=<?php print_r($row1['bidder_id']);?>&action=pubenable&bname=<?php print_r($row1['hb_bidder_name']);?>&page=<?php echo $_GET['page'];?>">Unblock</a>
					<?php }?>
					<!-- Block and Unblock-->
					 &nbsp; / &nbsp; 
					 <?php } ?>
					<?php 
					if($row1['is_deleted']== '0'){ ?>
						
						<a  href="bid_action.php?aid=<?php echo $affiliateid;?>&bid=<?php print_r($row1['bidder_id']);?>&action=pubdelete&bname=<?php print_r($row1['hb_bidder_name']);?>&page=<?php echo $_GET['page'];?>">Delete</a>
						
					<?php	} ?>
				</td>
				<!--For biddder action - end-->	
				
				<td class="alignRight verticalActions">
					<ul class="rowActions"> <li></li></ul>
				</td>
			</tr>

<?php		
	}
		$i++;
}
}
else
{
?>
		  <tr class='odd'>
			<td colspan='6'>&nbsp;</td>
	      </tr>
		  <tr class='even'>
			<td colspan='4' class="hasPanel">
				<div class='tableMessage'>
					<div class='panel'>
						CURRENTLY THERE ARE NO BIDDER VAlUES AVAILABLE TO LIST                            
						<div class='corner top-left'></div>
						<div class='corner top-right'></div>
						<div class='corner bottom-left'></div>
						<div class='corner bottom-right'></div>
					</div>
				</div>
			</td>
			<td>&nbsp;</td>
   		 </tr>
		 <tr class='odd'>
			<td colspan='4'>&nbsp;</td>
			<td colspan='4'>&nbsp;</td>
		 </tr>
<?php
}
?>	
	</tbody>
</table>

<br/><br/>

	<div style="float: right">
				<!-- pagination - start -->
		<?php
					
		 echo displayPaginationBelow($setLimit,$page,$affiliateid,$table_prefix);								
			
		?>		
				<!-- pagination - end -->	
	</div>
</form>
</div>
</body>
</html>

<?php
	
	function displayPaginationBelow($per_page,$page,$affiliateid,$table_prefix){
		
		$page_query = OA_Dal_Delivery_query("SELECT hbr.is_approved,hbr.is_deleted,hbr.is_denied,hbr.bidder_id,hbl.hb_bidder_name,hbl.hb_bidder_code from ".$table_prefix."djax_bidder_request as hbr join ".$table_prefix."djax_hb_bidders_list as hbl ON hbl.hb_bidder_id = hbr.bidder_id where hbl.dj_is_deleted = '0' AND hbl.dj_is_denied='0' AND hbr.is_deleted = '0' AND hbr.publisher_id='".$affiliateid."' AND hbr.is_denied = '0'");
		
		
		$total = OA_Dal_Delivery_numRows($page_query);
		
		$adjacents = "2"; 
		$page = ($page == 0 ? 1 : $page);  
		$start = ($page - 1) * $per_page;
		$prev = $page - 1;       
		$next = $page + 1;
		$setLastpage = ceil($total/$per_page);
		$lpm1 = $setLastpage - 1;
		//~ $page_url="?";
		$page_url="http://".$GLOBALS['conf']['webpath']['admin']."/affiliate-headerbid.php?affiliateid=".$affiliateid."&";
		$setPaginate = "";
		if($setLastpage > 1){
			
			$setPaginate .= "<ul class='setPaginate'>";
			$setPaginate .= "<li class='setPage'>Page $page of $setLastpage</li>";
			if ($setLastpage < 7 + ($adjacents * 2)){
				
				for ($counter = 1; $counter <= $setLastpage; $counter++){
					if ($counter == $page)
						$setPaginate.= "<li><a class='current_page'>$counter</a></li>";
					else
						$setPaginate.= "<li><a href='{$page_url}page=$counter'>$counter</a></li>";                  
				}
			}
			elseif($setLastpage > 5 + ($adjacents * 2)){
				
				if($page < 1 + ($adjacents * 2)){
					for ($counter = 1; $counter < 4 + ($adjacents * 2); $counter++){
						if ($counter == $page){
							$setPaginate.= "<li><a class='current_page'>$counter</a></li>";
						}
						else
							$setPaginate.= "<li><a href='{$page_url}page=$counter'>$counter</a></li>";                 
					}
					$setPaginate.= "<li class='dot'>...</li>";
					$setPaginate.= "<li><a href='{$page_url}page=$lpm1'>$lpm1</a></li>";
					$setPaginate.= "<li><a href='{$page_url}page=$setLastpage'>$setLastpage</a></li>";
				}
				elseif($setLastpage - ($adjacents * 2) > $page && $page > ($adjacents * 2)){
					$setPaginate.= "<li><a href='{$page_url}page=1'>1</a></li>";
					$setPaginate.= "<li><a href='{$page_url}page=2'>2</a></li>";
					$setPaginate.= "<li class='dot'>...</li>";
					for ($counter = $page - $adjacents; $counter <= $page + $adjacents; $counter++){
						if ($counter == $page)
    						$setPaginate.= "<li><a class='current_page'>$counter</a></li>";
    					else
    						$setPaginate.= "<li><a href='{$page_url}page=$counter'>$counter</a></li>";
					}
					$setPaginate.= "<li class='dot'>..</li>";
    				$setPaginate.= "<li><a href='{$page_url}page=$lpm1'>$lpm1</a></li>";
    				$setPaginate.= "<li><a href='{$page_url}page=$setLastpage'>$setLastpage</a></li>";
				}
				else{
    				$setPaginate.= "<li><a href='{$page_url}page=1'>1</a></li>";
    				$setPaginate.= "<li><a href='{$page_url}page=2'>2</a></li>";
    				$setPaginate.= "<li class='dot'>..</li>";
    				for ($counter = $setLastpage - (2 + ($adjacents * 2)); $counter <= $setLastpage; $counter++)
    				{
    					if ($counter == $page)
    						$setPaginate.= "<li><a class='current_page'>$counter</a></li>";
    					else
    						$setPaginate.= "<li><a href='{$page_url}page=$counter'>$counter</a></li>";					
    				}
    			}
			}
			if ($page < $counter - 1){ 
    			$setPaginate.= "<li><a href='{$page_url}page=$next'>Next</a></li>";
                $setPaginate.= "<li><a href='{$page_url}page=$setLastpage'>Last</a></li>";
    		}else{
    			$setPaginate.= "<li><a class='current_page'>Next</a></li>";
                $setPaginate.= "<li><a class='current_page'>Last</a></li>";
            }

    		$setPaginate.= "</ul>\n";
				
		}
		
		return $setPaginate;
	}
/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

phpAds_PageFooter();

function addPageTools($affiliateid)
{
    addPageLinkTool($GLOBALS["strLinkUser_Key"], "affiliate-user-start.php?affiliateid=$affiliateid", "iconWebsiteUserAdd", $GLOBALS["keyLinkUser"] );
}

?>


<script type="text/javascript">

	var id = 0;

	var jq = $.noConflict(true);

	jq('.review_param').click(function(event) 
	{
		event.preventDefault();
		id = jq(this).attr('id');
		var lid = id.split('_');
		id = lid[lid.length-1];	

		jq( "#dialog_"+id ).dialog('open');
		
		return false;
	});

	jq(function () {
		jq( ".dialog" ).dialog({
		autoOpen: false,
		width: 500,
		modal: true,
		buttons: 
		{
			SaveChanges: function() {

				var i = 0;
				var value = [];
				var hb_parameter_id = [];
				var account_id = '<?=$_GET['affiliateid']?>';
				
				$(".paramid_"+id).each(function()
				{
					if($(this).attr('is_required') == 1 && $(this).val() == '')
					{
						alert('Required Fields should be Filled!');
						return false;
					}
					
					value[i] = $(this).val();
					hb_parameter_id[i] = $(this).attr('id');

					i++;
				});

				//~SUB PARAMETERS
				var sub_param_id = [];
				var sub_param_value = [];
				var j = 0;

				$(".subparamid_"+id).each(function()
				{
					if($(this).attr('is_required') == 1 && $(this).val() == '')
					{
						alert('Required Fields should be Filled!');
						return false;
					}
					
					sub_param_id[j] = $(this).attr('id');
					sub_param_value[j] = $(this).val();

					j++;
				});

			  	$.ajax(
			  	{
			  		type: 'POST',
			  		url: "save_bidparams.php", 
			  		data: 
			  		{ 
			  			'hb_parameter_id' : JSON.stringify(hb_parameter_id), 
			  			'bidder_id' : id, 
			  			'account_id' : account_id, 
			  			'value' : JSON.stringify(value),
			  			'sub_param_id' : JSON.stringify(sub_param_id),
			  			'sub_param_value' : JSON.stringify(sub_param_value),
			  		},
			  		success: function(result)
			  		{
					}
				});

			}
		}
	});

	});

</script>