<?php
/* 
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/


// Require the initialisation file
require_once '../../../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';

require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/max/Admin_DA.php';

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER, OA_ACCOUNT_TRAFFICKER);
OA_Permission::enforceAccessToObject('affiliates', $affiliateid);
OA_Permission::enforceAccessToObject('zones', $zoneid);

if (OA_Permission::isAccount(OA_ACCOUNT_TRAFFICKER)) {
    OA_Permission::enforceAllowed(OA_PERM_ZONE_INVOCATION);
}

/*-------------------------------------------------------*/
/* Store preferences									 */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['affiliateid'] = $affiliateid;
phpAds_SessionDataStore();

//~ $oHeaderModel = MAX_displayWebsiteBreadcrumbs($affiliateid);

 //~ phpAds_PageHeader('zone-edit', $oHeaderModel);

/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

// Initialise some parameters
$pageName = basename($_SERVER['SCRIPT_NAME']);
$tabIndex = 1;
$agencyId = OA_Permission::getAgencyId();
$aEntities = array('affiliateid' => $affiliateid, 'zoneid' => $zoneid);

$aOtherPublishers = Admin_DA::getPublishers(array('agency_id' => $agencyId));
$aOtherZones = Admin_DA::getZones(array('publisher_id' => $affiliateid));
MAX_displayNavigationZone($pageName, $aOtherPublishers, $aOtherZones, $aEntities);

/**  databse declaration - start **/

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

if ($GLOBALS['_MAX']['SSL_REQUEST']) 
{
	$djprotocol='https://';
}
else
{
	$djprotocol='http://';
}
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
$conf = $GLOBALS['_MAX']['CONF'];

/**  databse declaration - end **/

/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/
/** submit value into database  - start**/

if(isset($_POST['submit']))
{
	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
	//$details = json_encode($_POST['bidder']);
	$bdetails = $_POST['bidder_detail'];


	$timeout = $_POST['timeout'];
	$zone_type = $_POST['zone_type'];
	$is_update = $_POST['is_update'];
	
	$affiliateid = $_GET['affiliateid'];
	$zone_id = $_GET['zoneid'];
	$details = [];
	$bidder_id = [];

	foreach($bdetails as $bname => $bvalue)
	{
		if(is_array($bvalue['value']))
		{
			$bidder_id[] = $bname;
		}

		foreach($bvalue['value'] as $pname => $pvalue)
		{	
			if($_POST['bidder'][$bvalue['bidder_code']] == 'on' && $is_update)
			{			
				if(is_array($pvalue['value']))
				{
					foreach($pvalue['value'] as $sname => $svalue)
					{
						$details['bidder'][$bvalue['bidder_code']][$pvalue['name']][$svalue['name']] = $svalue['value'];
					}
				}
				else
				{	
					$details['bidder'][$bvalue['bidder_code']][$pvalue['name']] = $pvalue['value'];
				}
			}	

			else
			{	
				if(is_array($pvalue['value']))
				{
					foreach($pvalue['value'] as $sname => $svalue)
					{
						$details['bidder'][$bvalue['bidder_code']][$pvalue['name']][$svalue['name']] = $svalue['value'];
					}
				}
				else
				{	
					$details['bidder'][$bvalue['bidder_code']][$pvalue['name']] = $pvalue['value'];
				}
			}	
		}

		if($_POST['bidder'][$bvalue['bidder_code']] == 'on')
		{
			$bdetails[] = $bdetails[$bvalue[3]];
		}

	}

	$details = serialize($details);
	$bdetails = serialize($bdetails);
	$bidder_id = serialize($bidder_id);
	$bidding_type = $_POST['bidding_type'];

	$ext = pathinfo($_POST['vid_source'], PATHINFO_EXTENSION);

	$vid_extention = explode('?', $ext);

	$vid_details = array(

						'vid_source' => $_POST['vid_source'],
						'vid_width' => $_POST['vid_width'],
						'vid_height' => $_POST['vid_height'],
						'vid_extention' => 'video/'.$vid_extention[0]
					);
	$vid_details = serialize($vid_details);
	
	if($is_update){
		OA_Dal_Delivery_query("UPDATE {$table_prefix}djax_thirdparty_invocation SET bidder_detail='{$details}',bidders='{$bdetails}',bidder_id='{$bidder_id}',timeout={$timeout}, bidding_type = {$bidding_type}, vid_details = '{$vid_details}' WHERE affiliate_id={$affiliateid} AND zone_id={$zone_id}");
	}else{
		$query = OA_Dal_Delivery_query("INSERT INTO {$table_prefix}djax_thirdparty_invocation(affiliate_id,zone_id,bidder_detail,banner_type,bidders,bidder_id,timeout, bidding_type, vid_details) VALUES ({$affiliateid},{$zone_id},'{$details}','{$zone_type}','{$bdetails}','{$bidder_id}',{$timeout}, '{$bidding_type}', '{$vid_details}')");
	}
}
/** submit value into database  - end**/

?>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
<link rel="stylesheet" href="assets/css/font-awesome.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

<style>
body{
	font-size: 11px;
}
div.breadcrumb h3 span.label{
	font-size : 20px;
}

#thirdLevelHeader div.breadcrumb{
	margin : 0px;
}

#settingsform1 .table td{
	font-size : 13px;
}
.expanded .label{
	color:black;
}

.container label{
	font-size: 12px;
	font-weight: normal;
}
.param_details{
	padding-left: 25px;
}

.subparam_details{
	padding-left: 50px;
}
.bidname{
	width: 18%;
	font-weight: normal;
}
#submitButton{
	margin-left: 50px;
}
#chsubmitButton{
	text-align: center;
}
.param_details li input{
    border-radius: 5px;
    padding: 5px;
    border: 1px solid #ccc;
    margin-bottom: 5px;
}
.container
{
	margin-left: 0px;
}

</style>

<script>
var jq = $.noConflict(true);

function getparams(e)
{
	var bidderid = e.getAttribute('data-bidder');
	var biddername = e.getAttribute('data-bidder-name');
	var affid = "<?php echo $affiliateid;?>";

	var class_name = e.getAttribute('class');

	if(class_name.match('client_side'))
	{
		class_name = 'client_side';
	}
	else if(class_name.match('server_side'))
	{
		class_name = 'server_side';
	}
	else
	{
		class_name = 'both';
	}
	
	if(e.checked == true){

		jq.ajax({
		
			type: "GET",
			
			url:"hbidajax.php",

			data:"bidderid="+bidderid+"&affid="+affid,
			
			dataType: 'json',

			success: function(data)
			{
				jq(".param_details_"+bidderid).parent().parent().remove();
				
				var param = '<div class="form-group '+class_name+' "><div class="col-sm-offset-3"><ul class="param_details param_details_'+bidderid+'">';
				
				jq.each(data, function(key, value) 
				{	
					param  += '<li><div><label class="bidname">'+value.paramname+'</label><input type="hidden"  name="bidder_detail['+bidderid+'][value]['+value.paramid+'][name]" value="'+value.paramname+'">';
				
					if(value.parareq == '1')
					{
						param += '<input type="text" name="bidder_detail['+bidderid+'][value]['+value.paramid+'][value]" value="'+value.paramval+'">';
					}
					else
					{
						param += '<input type="text" name="bidder_detail['+bidderid+'][value]['+value.paramid+'][value]" value="'+value.paramval+'">';
					}

				});
				param +='</div></li></ul></div></div>';
							
				jq("#bid_detail_"+bidderid).after(param);

			}
		});
		
	}else{
		
		jq(".param_details_"+bidderid).parent().parent().remove();
		
	}

	if(jq(".param_details_"+bidderid).length > 0){
		if(jq("#submitButton").length > 0){
			jq("#submitButton").attr('id','#chsubmitButton');
		}else{
			jq("#chsubmitButton").attr('id','#submitButton');
		}
	}
	
}

</script>

<?php

$zone_query = OA_Dal_Delivery_fetchAssoc(OA_Dal_Delivery_query("SELECT delivery from {$table_prefix}zones WHERE zoneid =  ".$_GET['zoneid']));

$condition = '';

if($zone_query['delivery'] == 6)
{
	$condition = ' AND dj_is_video = 1 ';
}

if($zone_query['delivery'] == 0 || $zone_query['delivery'] == 1)
{
	$condition = ' AND dj_is_banner = 1 ';
}


//get existing value - start
$exst_bid = OA_Dal_Delivery_query("SELECT * FROM {$table_prefix}djax_thirdparty_invocation WHERE affiliate_id={$affiliateid} AND zone_id={$zoneid}");

$get_bidderlist = OA_Dal_Delivery_query("SELECT DISTINCT(bl.hb_bidder_id), bl.hb_bidder_code, bl.hb_bidder_name, bl.server_side, bl.hb_ad_format FROM {$table_prefix}djax_bidder_request as r left join {$table_prefix}djax_hb_bidders_list as bl on bl.hb_bidder_id = r.bidder_id WHERE r.publisher_id = {$affiliateid} and r.is_deleted=0 and r.is_denied=0 and r.is_admin_deleted=0 and r.is_admin_denied = 0 and r.is_approved='1' ".$condition." ");


/** if first time enter headerbidding value then list -start**/
if(!OA_Dal_Delivery_numRows($exst_bid))
{

//get bidder details and timout values
$timeout = OA_Dal_Delivery_query("SELECT request_timeout,bidding_type FROM {$table_prefix}hb_bidding_type_setting");

$tout ='';
$bidding_type = '';

//check timeout has entry or not
if(OA_Dal_Delivery_numRows($timeout) > 0){
$bid_details = OA_Dal_Delivery_fetchAssoc($timeout);
$tout = $bid_details['request_timeout'];
$bidding_type = $bid_details['bidding_type'];
}else{
$tout = 500;
$bidding_type = 1;
}

/**List bidder's which is choosed by publisher - start*/
if(OA_Dal_Delivery_numRows($get_bidderlist) > 0)
{
?>
<div class="container">
<p style="font-size: 17px;font-weight: bold;">Bidder settings</p>
<hr/>
<form method="POST" class="form-horizontal">	
<div class="form-group">
<label class="control-label col-sm-3" style="font-size: 14px; width: 150px;"> Request Timeout</label>
<div class="col-sm-4">
	<input type="text" name="timeout" class="form-control" value="<?php echo $tout;?>">
</div>
</div>			
<div class="form-group">
<label class="control-label col-sm-3" style="font-size: 14px;">Bidding Type</label>
<div class="col-sm-4">
	<select class="control-label col-sm-6 form-select"  name="bidding_type" id="bidding_type">
		<option value="1" <?php echo ($brow['bidding_type'] ==1) ? "selected" : "";?>>Client Side</option>
		<option value="2" <?php echo ($brow['bidding_type'] ==2) ? "selected" : "";?>>Server Side</option>
	</select>
</div>
</div>

<?php if($zone_query['delivery'] == 6) { ?>

	<div class="form-group">
		<label class="control-label col-sm-3" style="font-size: 14px;">Video Dimention</label>
		<div class="col-sm-4">
			<input type="text" name="vid_width" placeholder="Width">
			<input type="text" name="vid_height" placeholder="Height">
		</div>
	</div>				
	<div class="form-group">
		<label class="control-label col-sm-3" style="font-size: 14px;">Video Source</label>
		<div class="col-sm-4">
			<input type="text" name="vid_source" placeholder="Source Video">
		</div>
	</div>

<?php } ?>

<div class="form-group">
<label class="control-label col-sm-3" style="
font-size: 14px;">Bidder details</label>
</div>

<?php
		while($bidder_details = OA_Dal_Delivery_fetchAssoc($get_bidderlist))
		{

			$bid_type = $bidder_details['server_side'];
			$class_name = '';

			if($bid_type == 1)
			{
				$class_name = 'client_side';
			}
			else if($bid_type == 2)
			{		
				$class_name = 'server_side';
			}
			else
			{
				$class_name = 'both';
			}
			if($bidder_details['hb_bidder_name'] !="" && $bidder_details['hb_bidder_name'] !=null)
			{
				
			?>
				<div class="form-group" id="bid_detail_<?php echo $bidder_details['hb_bidder_id'];?>">
					<div class="col-sm-offset-2">					
						<label class="control-label col-sm-6 <?=$class_name?>" style="text-align:left;">						
							<input type="checkbox" class="<?=$class_name?>" name="bidder[<?php echo $bidder_details['hb_bidder_id'];?>]" data-bidder ="<?php echo $bidder_details['hb_bidder_id'];?>"  data-bidder-name ="<?php echo $bidder_details['hb_bidder_code'];?>" onclick = "getparams(this);">					
						<?php echo $bidder_details['hb_bidder_name'];?>
						<!--this hidden used to get bidder name to store into database -->
						<input type="hidden" name="bidder_detail[<?php echo $bidder_details['hb_bidder_id'];?>][name]" value='<?php echo $bidder_details["hb_bidder_name"];?>'>
						<!--this hidden used to get bidder code to store into database -->
						<input type="hidden" name="bidder_detail[<?php echo $bidder_details['hb_bidder_id'];?>][bidder_code]" value='<?php echo $bidder_details["hb_bidder_code"];?>'>
						</label>
					</div>
				</div>
			<?php
				}
			}
			?>
			
		<div class="form-group">        
		  <div class="col-sm-offset-2 col-sm-6" style="text-align: right;">
			<button type="submit" class="btn btn-default" name="submit">Save changes</button>
			<!-- store zone type -->
			<input type="hidden" name="zone_type" value="<?php echo $aOtherZones[$zoneid]['type'];?>">
		  </div>
		</div>	
			<?php
		}
		else{
		?>
			<div class="alert alert-warning">
				Currently no Bidder's avaliable for <strong><?php echo $aOtherPublishers[$affiliateid]['name'];?></strong>
			</div>


		<?php	
		}/**List bidder's which is choosed by publisher - end*/
		?>			
	</div>
</form>
<?php
}/** if first time enter headerbidding value then list - end**/
/** if already exist headerbid value then list - start**/
else{
	
	$existing_biddingdetail = OA_Dal_Delivery_fetchAssoc($exst_bid);
	$bidders = unserialize($existing_biddingdetail['bidders']);
	$active_bidders = array();
	$active_bidders_key = array();

	$vid_details = unserialize($existing_biddingdetail['vid_details']);
	
	$bidding_type = $existing_biddingdetail['bidding_type'];
	$class_name = array();
	$i = 0;

	while($bidder_details = OA_Dal_Delivery_fetchAssoc($get_bidderlist))
	{
		$active_bidders_keys[] = $bidder_details["hb_bidder_id"];
		$active_bidders[] = $bidder_details;
		$i++;
	}
	$exst_bidder_ids = array_keys($bidders);
	?>
	<div class="container">
	<p style="font-size: 17px;font-weight: bold;">Bidder settings</p>
	<hr/>
	<form method="POST" class="form-horizontal">	
		<div class="form-group">
			<label class="control-label col-sm-3" style="font-size: 14px;"> Request Timeout</label>
			<div class="col-sm-4">
				<input type="text" name="timeout" class="form-control" value="<?php echo $existing_biddingdetail['timeout'];?>">
			</div>
		</div>				
		<div class="form-group">
			<label class="control-label col-sm-3" style="font-size: 14px;">Bidding Type</label>
			<div class="col-sm-4">
				<select class="control-label col-sm-6 form-select"  name="bidding_type" id="bidding_type">
					<option value="1" <?php echo ($existing_biddingdetail['bidding_type'] ==1) ? "selected" : "";?>>Client Side</option>
					<option value="2" <?php echo ($existing_biddingdetail['bidding_type'] ==2) ? "selected" : "";?>>Server Side</option>
				</select>
			</div>
		</div>	

		<?php if($zone_query['delivery'] == 6) { ?>

			<div class="form-group">
				<label class="control-label col-sm-3" style="font-size: 14px;">Video Dimention</label>
				<div class="col-sm-4">
					<input type="text" value="<?=$vid_details['vid_width']?>" name="vid_width" placeholder="Width">
					<input type="text" value="<?=$vid_details['vid_height']?>" name="vid_height" placeholder="Height">
				</div>
			</div>				
			<div class="form-group">
				<label class="control-label col-sm-3" style="font-size: 14px;">Video Source</label>
				<div class="col-sm-4">
					<input type="text" value="<?=$vid_details['vid_source']?>" name="vid_source" placeholder="Source Video">
				</div>
			</div>

		<?php } ?>

		<div class="form-group">
			<label class="control-label col-sm-3" style="font-size: 14px;">Bidder details</label>
      </div>
	<?php
	/** List bidder details - start **/

	foreach($bidders as $bidname => $bidvalue)
	{
		$query = OA_Dal_Delivery_query("SELECT server_side FROM {$table_prefix}djax_hb_bidders_list WHERE hb_bidder_code =  '".$bidvalue['bidder_code']."'");
		$value = OA_Dal_Delivery_fetchAssoc($query);
		$bid_type = $value['server_side'];
		$class_name = '';

		if($bid_type == 1)
		{
			$class_name = 'client_side';
		}
		else if($bid_type == 2)
		{		
			$class_name = 'server_side';
		}
		else
		{
			$class_name = 'both';
		}

		/**check it was choosed (has params)**/
		if(in_array($bidname, $active_bidders_keys))
		{
			if(is_array($bidvalue['value'])){
			?>
			<div class="form-group" id="bid_detail_<?php echo $bidname;?>">
					<div class="col-sm-offset-2">					
						<label class="control-label col-sm-2 <?=$class_name?>" style="text-align:left;">						
							<input type="checkbox" class="<?=$class_name?>_checkbox bid_detail_<?php echo $bidname;?>" name="bidder[<?php echo $bidvalue['bidder_code'];?>]" data-bidder ="<?php echo $bidname;?>"  data-bidder-name ="<?php echo $bidvalue['bidder_code'];?>" onclick = "getparams(this);" checked>					
						<?php echo $bidvalue['name'];?>
						<input type="hidden" name="bidder_detail[<?php echo $bidname;?>][name]" value='<?php echo $bidvalue["name"];?>'>
						<input type="hidden" name="bidder_detail[<?php echo $bidname;?>][bidder_code]" value='<?php echo $bidvalue["bidder_code"];?>'>
						</label>
					</div>
				</div>
				<div class="form-group">
					<div class="col-sm-offset-3">
						<ul class="param_details param_details_<?php echo $bidname;?>">
				<?php
				
				/**list param details  - start**/
				foreach($bidvalue['value'] as $paramname => $paramvalue)
				{
				
				?>
				
				<li>
					<div class="<?=$class_name?>_params">
						<label class="bidname"><?php echo $paramvalue['name']?></label>
						<input type="hidden" name="bidder_detail[<?php echo $bidname;?>][value][<?php echo $paramname;?>][name]" value="<?php echo $paramvalue['name']?>">
						<?php
						/** check it has subparameter or not**/
						if(is_array($paramvalue['value'])){
						?>
						<ul class="subparam_details param_details_<?php echo $paramname;?>">
						<?php
						/** list subparameter - start**/
							foreach($paramvalue['value'] as $subparamname => $subparamvalue){
						?>
							<li>
								<div>
									<label class="bidname"><?php echo $subparamvalue['name'];?></label>
									<input type="hidden" name="bidder_detail[<?php echo $bidname;?>][value][<?php echo $paramname;?>][value][<?php echo $subparamname;?>][name]" value="<?php echo $subparamvalue['name'];?>">
									<input type="text" name="bidder_detail[<?php echo $bidname;?>][value][<?php echo $paramname;?>][value][<?php echo $subparamname;?>][value]" value="<?php echo ($subparamvalue['value']=='null')? "":$subparamvalue['value'] ;?>">
								</div>
							</li>
						<?php	
							}
							/** list subparameter - end**/
						?>
						</ul>
						<?php	
						/** list parameter value **/
						}else{
						?>
						<input type="text" name="bidder_detail[<?php echo $bidname;?>][value][<?php echo $paramname;?>][value]" value="<?php echo ($paramvalue['value']=='null')?'':$paramvalue['value'];?>">
						<?php
					}
					?>
					</div>
				</li>
						
				<?php	
					}
					/** list parameter details -end**/
				?>
				</ul>
					</div>
				</div>
				<?php
		}else{ /** list unchecked bidder details - start **/
			?>
			<div class="form-group" id="bid_detail_<?php echo $bidname;?>">
					<div class="col-sm-offset-2">					
						<label class="control-label col-sm-2 <?=$class_name?>" style="text-align:left;">						
							<input type="checkbox" class="<?=$class_name?>_checkbox" name="bidder[<?php echo $bidvalue['bidder_code'];?>]" data-bidder ="<?php echo $bidname;?>"  data-bidder-name ="<?php echo $bidvalue['bidder_code'];?>" onclick = "getparams(this);">					
						<?php echo $bidvalue['name'];?>
						<input type="hidden" name="bidder_detail[<?php echo $bidname;?>][name]" value='<?php echo $bidvalue["name"];?>'>
						<input type="hidden" name="bidder_detail[<?php echo $bidname;?>][bidder_code]" value='<?php echo $bidvalue["bidder_code"];?>'>
						</label>
					</div>
				</div>
			
			<?php
		}
		}

		/** list unchecked bidder details - end **/
	}

			foreach ($active_bidders as $key => $value) {
				if((!in_array($value["hb_bidder_id"], $exst_bidder_ids)) && $value['hb_bidder_name']!="" && $value['hb_bidder_name'] !=null)
				{
				
			?>
				<div class="form-group" id="bid_detail_<?php echo $value['hb_bidder_id'];?>">
					<div class="col-sm-offset-2">					
						<label class="control-label col-sm-6" style="text-align:left;">						
							<input type="checkbox" class="" name="bidder[<?php echo $value['hb_bidder_id'];?>]" data-bidder ="<?php echo $value['hb_bidder_id'];?>"  data-bidder-name ="<?php echo $value['hb_bidder_code'];?>" onclick = "getparams(this);">					
						<?php echo $value['hb_bidder_name'];?>
						<!--this hidden used to get bidder name to store into database -->
						<input type="hidden" name="bidder_detail[<?php echo $value['hb_bidder_id'];?>][name]" value='<?php echo $value["hb_bidder_name"];?>'>
						<!--this hidden used to get bidder code to store into database -->
						<input type="hidden" name="bidder_detail[<?php echo $value['hb_bidder_id'];?>][bidder_code]" value='<?php echo $value["hb_bidder_code"];?>'>
						</label>
					</div>
				</div>
			<?php
				}
			}

	/** list bidder details - end **/	
	?>
	<div class="form-group">        
		  <div class="col-sm-offset-2 col-sm-6" style="text-align: right;">
			<button type="submit" class="btn btn-default" name="submit">Save changes</button>
			<!-- store zone type -->
			<input type="hidden" name="zone_type" value="<?php echo $aOtherZones[$zoneid]['type'];?>">
			<input type="hidden" name="is_update" value='1'>
		  </div>
		</div>	
	<?php
}

/** if already exist headerbid value then list - end**/
/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

phpAds_PageFooter();

?>

<script type="text/javascript">
	
	$(document).ready(function(){

		$("#bidding_type").change(function()
		{
			change_biddingtype($(this).val());
		});

		var bidding_type = $("#bidding_type").val();

		change_biddingtype(bidding_type);

		function change_biddingtype(type)
		{
			if(type == 2)
			{
				$(".server_side").show();
				// $(".server_side_checkbox").attr('checked', true);
				$(".server_side_params").show();
				$(".server_side").show();

				// $(".client_side_checkbox").attr('checked', false);
				$(".client_side_checkbox").hide();
				$(".client_side_params").hide();
				$(".client_side").hide();
				$(".client_side_checkbox").removeAttr('checked');
			}
			else
			{
				// $(".client_side_checkbox").attr('checked', true);
				$(".client_side_checkbox").show();
				$(".client_side_params").show();
				$(".client_side").show();
				$(".client_side").show();

				$(".server_side").hide();
				// $(".server_side_checkbox").attr('checked', false);
				$(".server_side_params").hide();
				$(".server_side").hide();
			}
		}
	});

</script>


<script type="text/javascript">
	
	var affiliateid = '<?=$_GET['affiliateid']?>';
	var link = '<?=$djprotocol?>'+'<?=$GLOBALS['_MAX']['CONF']['webpath']['admin']?>'+'/affiliate-edit.php?affiliateid='+affiliateid;
	
	$(".entityLinks").html('<span class="entityLinks"><a href="'+link+'" class="ent inlineIcon webs">Website: Auto Publisher</a></span>');

</script>