<?php
ob_start();
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';

require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/www/admin/config.php';


// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);


$title = 'DMP Settings';

// Display the settings page's header and sections
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);
phpAds_PageHeader('account-settings-dmp-settings', $oHeaderModel);
$host = OX_getHostName();
$file = '../../../../var/' . $host .'.conf.php';
$searchfor = 'dmp_pixel_url';
$contents = file_get_contents($file);
$pattern = preg_quote($searchfor, '/');
$pattern = "/^.*$pattern.*\$/m";
if (isset($_POST['submit']))
{
	$url = $_POST['url'];
		if(!empty($url)) {
			$txt = "dmp_pixel_url=\"".$url."\"";
			if(preg_match_all($pattern, $contents, $matches)){
			   $str=str_replace($matches[0],$txt,$contents);
			   file_put_contents($file, $str);
			}
			else{
			   $txt = "[dmpSettings]\ndmp_pixel_url=\"".$url."\"";
			   $myfile = file_put_contents($file, PHP_EOL.$txt.PHP_EOL , FILE_APPEND | LOCK_EX);
			}
		}
	$translation = new OX_Translation ();
	$translated_message = $translation->translate ("Pixel URL has been added");	
	OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);			
	header("Location: account-settings-dmp-settings.php");		
}else{
	if(preg_match_all($pattern, $contents, $matches)){ 
		$url_conf = substr($matches[0][0], strpos($matches[0][0], "\"") + 1);     
	}
}
?>
<table width='100%'>
    <tbody>
		<tr>
            <td colspan='4' height='25'>                           
                <img src='../../assets/images/icon-settings.gif' height='16' width='16' align='absmiddle'>&nbsp;
                <b>DMP Settings</b>
            </td>
        </tr>
        <tr height='1'>
            <td width='30' bgcolor='#888888'><img src='../../assets/images/break.gif' height='1' width='30'></td>
            <td width='30' bgcolor='#888888'><img src='../../assets/images/break.gif' height='1' width='250'></td>
            <td width='30' bgcolor='#888888'><img src='../../assets/images/break.gif' height='1' width='1'></td>
            <td width='30' bgcolor='#888888'><img src='../../assets/images/break.gif' height='1' width='30'></td>
        </tr>
        <tr>
            <td colspan='4' height='10'><img src='../../assets/images/spacer.gif' height='1' width='30'></td>
        </tr>
</table>
<form action="account-settings-dmp-settings.php" method="POST">
	<label>Set DMP Pixel URL</label>
	<input type="text" name="url" id="url" value="<?= $url_conf ?>"/><br/><br/>	
	<input type="submit" value="submit" name="submit" id="submit">
</form>
<br/>
<?php
// Display the page footer
phpAds_PageFooter();
?>
