package main

import (
	"gorilla/mux"
	"net/http"
	"fmt"
	"crypto/tls"
	"flag"
	
)

func home(w http.ResponseWriter, r *http.Request) {
	html := `<html>
				<title>Golang SSP APsadasdasdI</title>    
				<body>
					<h1>` + `Golang SSP APIxzzzzzzzzzzzzzz` + `</h1>
				</body>
			</html>`
	w.Write([]byte(fmt.Sprintf(html)))
}

func main() {

	certFile := flag.String("certfile", "/etc/letsencrypt/live/dev.djaxbidder.com/fullchain.pem", "certificate PEM file")
	keyFile := flag.String("keyfile", "/etc/letsencrypt/live/dev.djaxbidder.com/privkey.pem", "key PEM file")
	flag.Parse()

	router := mux.NewRouter().StrictSlash(true)
	router.HandleFunc("/", home)
	srv := &http.Server{
		Addr:    "8090",
		Handler: router,
		TLSConfig: &tls.Config{
			MinVersion: tls.VersionTLS13,
			PreferServerCipherSuites: true,
		},
	}

	if err := srv.ListenAndServeTLS(*certFile, *keyFile); err != nil {
		panic(err)
	}
	
	
}
