package openrtb3

type Audio struct {
	Mime        []string `json:"mime,omitempty"`
	Delay       int      `json:"delay,omitempty"`
	Skip        int      `json:"skip,omitempty"`
	Skipmin     int      `json:"skipmin,omitempty"`
	Skipafter   int      `json:"skipafter,omitempty"`
	Playmethod  int      `json:"playmethod,omitempty"`
	Feed        int      `json:"feed,omitempty"`
	Nvol        int      `json:"nvol,omitempty"`
	Api         []int    `json:"api,omitempty"`
	Ctype       []int    `json:"ctype,omitempty"`
	Mindur      int      `json:"mindur,omitempty"`
	Maxdur      int      `json:"maxdur,omitempty"`
	MaxExtended int      `json:"maxextended,omitempty"` // Maximum extended video ad duration
	Maxext      int      `json:"maxext,omitempty"`
	Minbitr     int      `json:"minbitr,omitempty"`
	Maxbitr     int      `json:"maxbitr,omitempty"`
	Delivery    []int    `json:"delivery,omitempty"`
	Maxseq      int      `json:"maxseq,omitempty"`
	Comp        []*Comp  `json:"comp,omitempty"`
	Comptype    []int    `json:"comptype,omitempty"`
}
